% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/micro_aust.R
\encoding{UTF-8}
\name{micro_aust}
\alias{micro_aust}
\title{Australian implementation of the microclimate model.}
\usage{
micro_aust(loc = c(130.5686, -22.6523), ystart = 1990, yfinish = 1990,
REFL = 0.15, slope = 0, aspect = 0, DEP = c(0, 2.5,  5,  10,  15,  20,  30,  50,  100,  200), minshade = 0, maxshade = 90,
Usrhyt = 0.01, ...)
}
\arguments{
\item{loc}{Longitude and latitude (decimal degrees)}

\item{ystart}{First year to run}

\item{yfinish}{Last year to run}

\item{REFL}{Soil solar reflectance, decimal \%}

\item{elev}{Elevation, if to be user specified (m)}

\item{slope}{Slope in degrees}

\item{aspect}{Aspect in degrees (0 = north)}

\item{DEP}{Soil depths at which calculations are to be made (cm), must be 10 values starting from 0, and more closely spaced near the surface}

\item{minshade}{Minimum shade level to use (\%) (can be a single value or a vector of daily values)}

\item{maxshade}{Maximum shade level to us (\%) (can be a single value or a vector of daily values)}

\item{Usrhyt}{Local height (m) at which air temperature, wind speed and humidity are to be computed for organism of interest}

\item{...}{Additional arguments, see Details}
}
\value{
metout The above ground micrometeorological conditions under the minimum specified shade

shadmet The above ground micrometeorological conditions under the maximum specified shade

soil Hourly predictions of the soil temperatures under the minimum specified shade

shadsoil Hourly predictions of the soil temperatures under the maximum specified shade

soilmoist Hourly predictions of the soil moisture under the minimum specified shade

shadmoist Hourly predictions of the soil moisture under the maximum specified shade

soilpot Hourly predictions of the soil water potential under the minimum specified shade

shadpot Hourly predictions of the soil water potential under the maximum specified shade

humid Hourly predictions of the soil humidity under the minimum specified shade

shadhumid Hourly predictions of the soil humidity under the maximum specified shade

plant Hourly predictions of plant transpiration, leaf water potential and root water potential under the minimum specified shade

shadplant Hourly predictions of plant transpiration, leaf water potential and root water potential under the maximum specified shade

sunsnow Hourly predictions of snow temperature under the minimum specified shade

shadsnow Hourly predictions snow temperature under the maximum specified shade
}
\description{
An implementation of the NicheMapR microclimate model that uses the AWAP daily weather database
}
\details{
\strong{ Parameters controlling how the model runs:}\cr\cr
\code{runshade}{ = 1, Run the microclimate model twice, once for each shade level (1) or just once for the minimum shade (0)?}\cr\cr
\code{clearsky}{ = 0, Run for clear skies (1) or with observed cloud cover (0)}\cr\cr
\code{run.gads}{ = 1, Use the Global Aerosol Database? 1=yes (Fortran version), 2=yes (R version), 0=no}\cr\cr
\code{IR}{ = 0, Clear-sky longwave radiation computed using Campbell and Norman (1998) eq. 10.10 (includes humidity) (0) or Swinbank formula (1)}\cr\cr
\code{solonly}{ = 0, Only run SOLRAD to get solar radiation? 1 = yes, 0 = no}\cr\cr
\code{lamb}{ = 0, Return wavelength-specific solar radiation output?}\cr\cr
\code{IUV}{ = 0, Use gamma function for scattered solar radiation? (computationally intensive)}\cr\cr
\code{microclima}{ = 0, Use microclima and elevatr package to adjust solar radiation for terrain? 1 = yes, 0 = no}\cr\cr
\code{writecsv}{ = 0, Make Fortran code write output as csv files? 1 = yes, 0 = no}\cr\cr
\code{manualshade}{ = 1, Use CSIRO Soil and Landscape Grid of Australia? 1 = yes, 0 = no}\cr\cr
\code{soildata}{ = 0, Extract emissivities from gridded data? 1 = yes, 0 = no}\cr\cr
\code{terrain}{ = 0, Use 250m resolution terrain data? 1 = yes, 0 = no}\cr\cr
\code{dailywind}{ = 1, use McVicar grids for wind speed (does not work for opendap = 1)? 1 = yes, 0 = no}\cr\cr
\code{windfac}{ = 1, factor to multiply wind speed by e.g. to simulate forest}\cr\cr
\code{adiab_cor}{ = 1, use adiabatic lapse rate correction? 1 = yes, 0 = no}\cr\cr
\code{warm}{ = 0, warming offset vector, °C (negative values mean cooling). Can supply a single value or a vector the length of the number of days to be simulated.}\cr\cr
\code{spatial}{ = "c:/Australian Environment/", choose location of terrain data}\cr\cr
\code{opendap}{ = 1, query met grids via opendap}\cr\cr
\code{soilgrids}{ = 0, query soilgrids.org database for soil hydraulic properties?}\cr\cr
\code{message}{ = 0, allow the Fortran integrator to output warnings? (1) or not (0)}\cr\cr
\code{fail}{ = nyears x 24 x 365, how many restarts of the integrator before the Fortran program quits (avoids endless loops when solutions can't be found)}\cr\cr

\strong{ General additional parameters:}\cr\cr
\code{ERR}{ = 1.5, Integrator error tolerance for soil temperature calculations}\cr\cr
\code{Refhyt}{ = 1.2, Reference height (m), reference height at which air temperature, wind speed and relative humidity input data are measured}\cr\cr
\code{RUF}{ = 0.004, Roughness height (m), e.g. smooth desert is 0.0003, closely mowed grass may be 0.001, bare tilled soil 0.002-0.006, current allowed range: 0.00001 (snow) - 0.02 m.}\cr\cr
\code{ZH}{ = 0, heat transfer roughness height (m) for Campbell and Norman air temperature/wind speed profile (invoked if greater than 0, 0.02 * canopy height in m if unknown)}\cr\cr
\code{D0}{ = 0, zero plane displacement correction factor (m) for Campbell and Norman air temperature/wind speed profile (0.6 * canopy height in m if unknown)}\cr\cr
\code{Z01}{ = 0, Top (1st) segment roughness height(m) - IF NO EXPERIMENTAL WIND PROFILE DATA SET THIS TO ZERO! (then RUF and Refhyt used)}\cr\cr
\code{Z02}{ = 0, 2nd segment roughness height(m) - IF NO EXPERIMENTAL WIND PROFILE DATA SET THIS TO ZERO! (then RUF and Refhyt used).}\cr\cr
\code{ZH1}{ = 0, Top of (1st) segment, height above surface(m) - IF NO EXPERIMENTAL WIND PROFILE DATA SET THIS TO ZERO! (then RUF and Refhyt used).}\cr\cr
\code{ZH2}{ = 0, 2nd segment, height above surface(m) - IF NO EXPERIMENTAL WIND PROFILE DATA SET THIS TO ZERO! (then RUF and Refhyt used).}\cr\cr
\code{EC}{ = 0.0167238, Eccenricity of the earth's orbit (current value 0.0167238, ranges between 0.0034 to 0.058)}\cr\cr
\code{SLE}{ = 0.95, Substrate longwave IR emissivity (decimal \%), typically close to 1}\cr\cr
\code{Thcond}{ = 2.5, Soil minerals thermal conductivity, single value or vector of 10 specific to each depth (W/mK)}\cr\cr
\code{Density}{ = 2.56, Soil minerals density, single value or vector of 10 specific to each depth (Mg/m3)}\cr\cr
\code{SpecHeat}{ = 870, Soil minerals specific heat, single value or vector of 10 specific to each depth (J/kg-K)}\cr\cr
\code{BulkDensity}{ = 1.3, Soil bulk density (Mg/m3), single value or vector of 10 specific to each depth}\cr\cr
\code{PCTWET}{ = 0, \% of ground surface area acting as a free water surface (overridden if soil moisture model is running)}\cr\cr
\code{rainwet}{ = 1.5, mm of rainfall causing the ground to be 90\% wet for the day}\cr\cr
\code{cap}{ = 1, organic cap present on soil surface? (cap has lower conductivity - 0.2 W/mC - and higher specific heat 1920 J/kg-K)}\cr\cr
\code{CMH2O}{ = 1, Precipitable cm H2O in air column, 0.1 = very dry; 1.0 = moist air conditions; 2.0 = humid, tropical conditions (note this is for the whole atmospheric profile, not just near the ground)}\cr\cr
\code{hori}{ = rep(0, 24), Horizon angles (degrees), from 0 degrees azimuth (north) clockwise in 15 degree intervals}\cr\cr
\code{lapse_min}{ = 0.0039 Lapse rate for minimum air temperature (degrees C/m)}\cr\cr
\code{lapse_max}{ = 0.0077 Lapse rate for maximum air temperature (degrees C/m)}\cr\cr
\code{TIMAXS}{ = c(1.0, 1.0, 0.0, 0.0), Time of Maximums for Air Wind RelHum Cloud (h), air & Wind max's relative to solar noon, humidity and cloud cover max's relative to sunrise}\cr\cr
\code{TIMINS}{ = c(0, 0, 1, 1), Time of Minimums for Air Wind RelHum Cloud (h), air & Wind min's relative to sunrise, humidity and cloud cover min's relative to solar noon}\cr\cr
\code{timezone}{ = 0, Use GNtimezone function in package geonames to correct to local time zone (excluding daylight saving correction)? 1 = yes, 0 = no}\cr\cr

\strong{ Soil moisture mode parameters:}

\code{runmoist}{ = 1, Run soil moisture model? 1 = yes, 0 = no  1 = yes, 0 = no (note that this may cause slower runs)}\cr\cr
\code{PE}{ = rep(1.1, 19), Air entry potential (J/kg) (19 values descending through soil for specified soil nodes in parameter}
\code{DEP}
{ and points half way between)}\cr\cr
\code{KS}{ = rep(0.0037, 19), Saturated conductivity, (kg s/m3) (19 values descending through soil for specified soil nodes in parameter}
\code{DEP}
{ and points half way between)}\cr\cr
\code{BB}{ = rep(4.5, 19), Campbell's soil 'b' parameter (-) (19 values descending through soil for specified soil nodes in parameter}
\code{DEP}
{ and points half way between)}\cr\cr
\code{BD}{ = rep(1.3, 19), Soil bulk density (Mg/m3)  (19 values descending through soil for specified soil nodes in parameter}
\code{DEP}
{ and points half way between)}\cr\cr
\code{DD}{ = rep(2.56, 19), Soil density (Mg/m3)  (19 values descending through soil for specified soil nodes in parameter DEP and points half way between)}\cr\cr
\code{DEP}
{ and points half way between)}\cr\cr
\code{maxpool}{ = 10000, Max depth for water pooling on the surface (mm), to account for runoff}\cr\cr
\code{rainmult}{ = 1, Rain multiplier for surface soil moisture (-), used to induce runon}\cr\cr
\code{evenrain}{ = 0, Spread daily rainfall evenly across 24hrs (1) or one event at midnight (0)}\cr\cr
\code{SoilMoist_Init}{ = c(0.1, 0.12, 0.15, 0.2, 0.25, 0.3, 0.3, 0.3, 0.3, 0.3), initial soil water content at each soil node, m3/m3}\cr\cr
\code{L}{ = c(0, 0, 8.2, 8.0, 7.8, 7.4, 7.1, 6.4, 5.8, 4.8, 4.0, 1.8, 0.9, 0.6, 0.8, 0.4, 0.4, 0, 0)*10000, root density (m/m3), (19 values descending through soil for specified soil nodes in parameter}\cr\cr
\code{R1}{ = 0.001, root radius, m}\cr\cr
\code{RW}{ = 2.5e+10, resistance per unit length of root, m3 kg-1 s-1}\cr\cr
\code{RL}{ = 2e+6, resistance per unit length of leaf, m3 kg-1 s-1}\cr\cr
\code{PC}{ = -1500, critical leaf water potential for stomatal closure, J kg-1}\cr\cr
\code{SP}{ = 10, stability parameter for stomatal closure equation, -}\cr\cr
\code{IM}{ = 1e-06, maximum allowable mass balance error, kg}\cr\cr
\code{MAXCOUNT}{ = 500, maximum iterations for mass balance, -}\cr\cr
\code{LAI}{ = 0.1, leaf area index (can be a single value or a vector of daily values), used to partition traspiration/evaporation from PET}\cr\cr
\code{microclima.LAI}{ = 0, leaf area index, used by package microclima for radiation calcs}\cr\cr
\code{microclima.LOR}{ = 1, leaf orientation for package microclima radiation calcs}\cr\cr

\strong{ Snow mode parameters:}

\code{snowmodel}{ = 0, run the snow model 1 = yes, 0 = no (note that this may cause slower runs)}\cr\cr
\code{snowtemp}{ = 1.5, Temperature (°C) at which precipitation falls as snow}\cr\cr
\code{snowdens}{ = 0.375, snow density (mg/m3), overridden by densfun}\cr\cr
\code{densfun}{ = c(0, 0, 0, 0), slope and intercept of model of snow density as a linear function of snowpack age if first two values are nonzero, and following the exponential function of Sturm et al. 2010 J. of Hydromet. 11:1380-1394 if all values are non-zero; if it is c(0, 0, 0, 0) then fixed density used}\cr\cr
\code{snowmelt}{ = 1, proportion of calculated snowmelt that doesn't refreeze}\cr\cr
\code{undercatch}{ = 1, undercatch multipier for converting rainfall to snow}\cr\cr
\code{rainmelt}{ = 0.0125, paramter in equation that melts snow with rainfall as a function of air temp}\cr\cr
\code{snowcond}{ = 0, effective snow thermal conductivity W/mC (if zero, uses inbuilt function of density)}\cr\cr
\code{intercept}{ = max(maxshade) / 100 * 0.3, snow interception fraction for when there's shade (0-1)}\cr\cr
\code{grasshade}{ = 0, if 1, means shade is removed when snow is present, because shade is cast by grass/low shrubs}\cr\cr

\strong{ Intertidal mode parameters:}

\code{shore}{ Include tide effects? If 1, the matrix}
\code{tides}
{ is used to specify tide presence, sea water temperature and presence of wavesplash}\cr\cr
\code{tides}{ = matrix(data = 0, nrow = 24 \* 365 \* nyears, ncol = 3), matrix of 1. tide state (0 = out, 1 = in), 2. Water temperature (°C) and 3. Wave splash (0 = yes, 1 = no)}\cr\cr

\strong{Outputs:}

\code{ndays}{ - number of days for which predictions are made}\cr\cr
\code{longlat}{ - longitude and latitude for which simulation was run (decimal degrees)}\cr\cr
\code{dates}{ - vector of dates (hourly, POSIXct, timezone = GMT+10)}\cr\cr
\code{dates2}{ - vector of dates (daily, POSIXct, timezone = GMT+10)}\cr\cr
\code{nyears}{ - number of years for which predictions are made}\cr\cr
\code{RAINFALL}{ - vector of daily rainfall (mm)}\cr\cr
\code{elev}{ - elevation at point of simulation (m)}\cr\cr
\code{minshade}{ - minimum shade for each day of simulation (\%)}\cr\cr
\code{maxshade}{ - maximum shade for each day of simulation (\%)}\cr\cr
\code{DEP}{ - vector of depths used (cm)}\cr\cr

metout/shadmet variables:
\itemize{
\item 1 DOY - day-of-year
\item 2 TIME - time of day (mins)
\item 3 TALOC - air temperature (°C) at local height (specified by 'Usrhyt' variable)
\item 4 TAREF - air temperature (°C) at reference height (specified by 'Refhyt', 1.2m default)
\item 5 RHLOC - relative humidity (\%) at local height (specified by 'Usrhyt' variable)
\item 6 RH  - relative humidity (\%) at reference height (specified by 'Refhyt', 1.2m default)
\item 7 VLOC - wind speed (m/s) at local height (specified by 'Usrhyt' variable)
\item 8 VREF - wind speed (m/s) at reference height (specified by 'Refhyt', 1.2m default)
\item 9 SNOWMELT - snowmelt (mm)
\item 10 POOLDEP - water pooling on surface (mm)
\item 11 PCTWET - soil surface wetness (\%)
\item 12 ZEN - zenith angle of sun (degrees - 90 = below the horizon)
\item 13 SOLR - solar radiation (W/m2) (unshaded, horizontal plane)
\item 14 TSKYC - sky radiant temperature (°C)
\item 15 DEW - dew presence (0 or 1)
\item 16 FROST - frost presence (0 or 1)
\item 17 SNOWFALL - snow predicted to have fallen (cm)
\item 18 SNOWDEP - predicted snow depth (cm)
\item 19 SNOWDENS - snow density (g/cm3)
}
soil and shadsoil variables:
\itemize{
\item 1 DOY - day-of-year
\item 2 TIME - time of day (mins)
\item 3-12 D0cm ... - soil temperature (°C) at each of the 10 specified depths
}

if soil moisture model is run i.e. parameter runmoist = 1\cr

soilmoist and shadmoist variables:
\itemize{
\item 1 DOY - day-of-year
\item 2 TIME - time of day (mins)
\item 3-12 WC0cm ... - soil moisture (m3/m3) at each of the 10 specified depths
}
soilpot and shadpot variables:
\itemize{
\item 1 DOY - day-of-year
\item 2 TIME - time of day (mins)
\item 3-12 PT0cm ... - soil water potential (J/kg = kPa = bar/100) at each of the 10 specified depths
}
humid and shadhumid variables:
\itemize{
\item  1 DOY - day-of-year
\item  2 TIME - time of day (mins)
\item  3-12 RH0cm ... - soil relative humidity (decimal \%), at each of the 10 specified depths
}
plant and shadplant variables:
\itemize{
\item  1 DOY - day-of-year
\item  2 TIME - time of day (mins)
\item  3 TRANS - plant transpiration rate (g/m2/h)
\item  4 LEAFPOT - leaf water potential (J/kg = kPa = bar/100)
\item  5-14 RPOT0cm ... - root water potential (J/kg = kPa = bar/100), at each of the 10 specified depths
}

if snow model is run i.e. parameter lamb = 1\cr
sunsnow and shdsnow variables:
\itemize{
\item  1 DOY - day-of-year
\item  2 TIME - time of day (mins)
\item  3-10 SN1 ... - snow temperature (°C), at each of the potential 8 snow layers (layer 8 is always the bottom - need metout$SNOWDEP to interpret which depth in the snow a given layer represents)
}

if wavelength-specific solar output is selected i.e. parameter lamb = 1\cr
solar output variables
drlam (direct solar), drrlam (direct Rayleigh solar) and srlam (scattered solar) variables:
\itemize{
\item  1 DOY - day-of-year
\item  2 TIME - time of day (mins)
\item  3-113 290, ..., 4000 - irradiance (W/(m2 nm)) at each of 111 wavelengths from 290 to 4000 nm
}
}
\examples{
ystart <- 2014
yfinish <- 2015
nyears <- yfinish - ystart + 1
loc <- c(130.5686, -22.6523) # Nyrripi, Northern Territory, Australia
micro <- micro_aust(loc = loc, ystart = ystart, yfinish = yfinish, opendap = 1, elev = 0, runshade = 0) # run the model for the middle of the desert in Australia, using opendap

metout <- as.data.frame(micro$metout) # above ground microclimatic conditions, min shade
soil <- as.data.frame(micro$soil) # soil temperatures, minimum shade
soilmoist <- as.data.frame(micro$soilmoist) # soil temperatures, minimum shade

# append dates
dates <- micro$dates
metout <- cbind(dates, metout)
soil <- cbind(dates, soil)
soilmoist <- cbind(dates, soilmoist)
minshade <- micro$minshade[1]

# plotting above-ground conditions in minimum shade
with(metout, {plot(TALOC ~ dates, xlab = "Date and Time", ylab = "Temperature (Â°C)"
, type = "l" ,main = paste("air and sky temperature, ", minshade, "\% shade", sep = ""), ylim = c(-20, 60))})
with(metout, {points(TAREF ~ dates, xlab = "Date and Time", ylab = "Temperature (Â°C)"
, type = "l", lty = 2, col = 'blue')})
with(metout,{points(TSKYC ~ dates, xlab = "Date and Time", ylab = "Temperature (Â°C)"
,  type = "l", col = 'light blue', main = paste("sky temperature, ", minshade, "\% shade", sep = ""))})
with(metout, {plot(RHLOC ~ dates, xlab = "Date and Time", ylab = "Relative Humidity (\%)"
, type = "l", ylim = c(0, 100), main = paste("humidity, ", minshade, "\% shade", sep = ""))})
with(metout, {points(RH ~ dates, xlab = "Date and Time", ylab = "Relative Humidity (\%)"
, type = "l", col = 'blue', lty = 2, ylim = c(0, 100))})
with(metout, {plot(VREF ~ dates, xlab = "Date and Time", ylab = "Wind Speed (m/s)"
,  type = "l", main = "wind speed", ylim = c(0, 15))})
with(metout, {points(VLOC ~ dates, xlab = "Date and Time", ylab = "Wind Speed (m/s)"
,  type = "l", lty = 2, col = 'blue')})
with(metout, {plot(SOLR ~ dates, xlab = "Date and Time", ylab = "Solar Radiation (W/m2)"
,  type = "l", main="solar radiation")})
with(metout, {plot(SNOWDEP ~ dates, xlab = "Date and Time", ylab = "Snow Depth (cm)"
,  type = "l", main = "snow depth")})

# plotting soil temperature
for(i in 1:10){
 if(i == 1){
   plot(soil[, i + 3] ~ soil[, 1], xlab = "Date and Time", ylab = "Soil Temperature (Â°C)"
   , col = i, type = "l", main = paste("soil temperature ", minshade, "\% shade",sep=""))
 }else{
   points(soil[, i + 3] ~ soil[, 1], xlab = "Date and Time", ylab = "Soil Temperature
    (Â°C)", col = i, type = "l")
 }
}

# plotting soil moisture
for(i in 1:10){
 if(i == 1){
   plot(soilmoist[, i + 3] * 100 ~ soilmoist[, 1], xlab = "Date and Time", ylab = "Soil Moisture (\% volumetric)"
   ,col = i, type = "l", main = paste("soil moisture ", minshade, "\% shade", sep = ""))
 }else{
   points(soilmoist[, i + 3] * 100 ~ soilmoist[, 1], xlab = "Date and Time", ylab = "Soil Moisture
    (\%)", col = i, type = "l")
 }
}
}
