% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/WETAIR.rh.R
\name{WETAIR.rh}
\alias{WETAIR.rh}
\title{WETAIR.rh}
\usage{
WETAIR.rh(db = db, rh = rh, bp = 101325)
}
\arguments{
\item{db}{Dry bulb temperature (degrees C)}

\item{rh}{Relative humidity (\%)}

\item{bp}{Barometric pressure (pascal)}
}
\value{
e Vapour pressure (Pa)

esat Saturation vapour pressure (Pa)

vd Vapour density (kg m-3)

rw Mixing ratio (kg kg-1)

tvir Virtual temperature (K)

tvinc Virtual temperature increment (K)

denair Density of the air (kg m-3)

cp Specific heat of air at constant pressure (J kg-1 K-1)

wtrpot Water potential (Pa)

rh Relative humidity (\%)
}
\description{
Calculates several properties of humid air as output variables below. The program
is based on equations from List, R. J. 1971. Smithsonian Meteorological Tables. Smithsonian
Institution Press. Washington, DC. WETAIR must be used in conjunction with function VAPPRS.
}
\details{
Input variables are shown below. The user must supply known values for rh, db and pb (bp at one standard
atmosphere is 101 325 pascals).
}
