% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DRYAIR.R
\name{DRYAIR}
\alias{DRYAIR}
\title{DRYAIR}
\usage{
DRYAIR(db = db, bp = 0, alt = 0)
}
\arguments{
\item{db}{Dry bulb temperature (degrees C)}

\item{bp}{Barometric pressure (pascal)}

\item{alt}{Altitude (m)}
}
\value{
patmos Standard atmospheric pressure (Pa)

densty Density (kg m-3)

visdyn Dynamic viscosity (kg m-1 s-1)

viskin Kinematic viscosity (m2 s-1)

difvpr Diffusivity of water vapour in air (m2 s-1)

thcond Thermal conductivity (W m-1 K-1)

htovpr Latent heat of vapourisation of water (J kg-1)

tcoeff Temperature coefficient of volume expansion (K-1)

ggroup Group of variables in Grashof number (1-m3 -K)

bbemit black body emittance (W m-2)

emtmax Wave length of maximum emittance (m)
}
\description{
Calculates several properties of dry air and related characteristics shownas output variables below. The program
is based on equations from List, R. J. 1971. Smithsonian Meteorological Tables. Smithsonian
Institution Press. Washington, DC. WETAIR must be used in conjunction with function VAPPRS.
}
\details{
The user must supply values for the input variables (db, bp and alt).
If alt is known (-1000 < alt < 20000) but not BP, then set BP=0
}
