#!/usr/bin/env Rscript

hlp = "Plot MSP statistics and names. "

# Paths
in.data = "./data/data.Robj"
out.dir = file.path("./output/composition/")
dir.create(out.dir, recursive = TRUE, showWarnings = FALSE)

# Colors
COLORS = c("#73BA9B", "#003E1F", "#01110A")

# Libs
require(ggplot2)

# Load data object
load(in.data)
obj = .GlobalEnv$obj

# Plot distribution
mm = obj$assays$MSPCore$metadata
fname = file.path(out.dir, "msp_stats.pdf")
ggplot(data=mm, mapping=aes(x=genes_quant, fill=level)) + geom_bar() +
  xlab("Number of Genes") + ylab("Number of MSPs") + 
  guides(fill=guide_legend(title="Annotation level", nrow=2)) +
  theme(text = element_text(size=7),
        legend.position = "top",
        panel.background = element_blank()) +
  theme(legend.margin = margin(t=1, r=1, b=1, l=1)) +
  scale_fill_manual(values=COLORS)
ggsave(fname, width = 2.4, height = 2)
message(sprintf("Written %s", fname))
