## Tips & Tricks

Here we share different ways in which you can get done a specific action or task that may not be so obvious or direct.
We will add to this list on the basis of suggestions and queries from users.

1. How to zoom in on the 360 video?
    - You can use several tools to do this.
    For example, the *mirror cam*, the *recam* and the *drawing/near-plane canvas* tools all have a zoom function built-in.
    Just open the tool, point it at the area of the 360 video you wish to see in more detail, and zoom to your heart's content.
    Of course, the digital zoom will not give you more detail than the pixel depth allows.
    - Zooming is also built into the *comic creator/cameras* and the *keyframe sequencer* tools.

1. How to share saved assets with others?
    - It is easy to share snapshot images, comics, recammed videos, keyframe sequences, etc. with others.
    - They are stored in the appropriate folder in the _AVA360VR_ project that you are working in.
    Usually, the saved assets are given a name that includes the date/time they were made.
    They may also be in a folder with the date/time as well.
    They may also have additional information to help you keep track, eg. frame numbers, panel numbers, etc.
    - Once you have tracked down the correct folder, you can just copy the folder or files as you wish and share them.
    They are in standard formats, such as `PNG` or `MP4`.

1. How to share VolCaps with others
    - VolCaps are stored in a folder called `Volumetric Capture` in the current project you are working in.
    The folder is given a name that includes the date/time they were made.
    Once you have tracked down the correct folder, you can share them with someone who already has the same _AVA360VR_ project on their computer.
    - Just copy the folder, compress it into an archive file (zip), then send them the file.
    They can decompress the file to a folder on their computer, then move or copy that folder in the `Volumetric Capture` folder in the same project.
    The VolCap can now be imported and replayed on their computer.
    - Note: If the project does not have the same audio-visual assets as the original, then it will not work.

1. How to work with the original data and then anonymise it later?
    - Almost everything in _AVA360VR_ can be done with the original files, and later the files can be substituted by anonymised (degraded) files, and the project will still function.
    - For example, one can create comics and VolCaps with the original 360 and 2D video data, and then swap the video files for anonymised versions for publication or distribution.
    The saved comics (not exported to disk yet) will now open identically to the original, eg. with unchanged captions,speech bubbles, camera positions etc.
    - And the original VolCaps can be imported and they will work with the anonymised data.
    - Note that some things may need be altered separately, eg. images, thumbnails etc that are hardcoded.

 