## How to install and run AVA360VR

From GitHub you will be able to download the latest build release of AVA360VR and run it from Windows 10 on your computer.

> Note that the _AVA360VR_ software package is closed-source (build only) and is free to use for non-commercial purposes.
Unauthorised use, distribution or alteration of the code is not permitted.
Copyright (c) 2021 BigSoftVideo.

To use _AVA360VR_, your computer system and VR gear will need to fulfil certain requirements.

### Requirements

You will need a fast **VR-ready** PC laptop (eg. a gaming laptop) with **Windows 10**.
_AVA360VR_ now works with most mid- to high-end VR headsets with six-degrees of freedom controllers.
We have tested successfully with the following headsets:
- HTC VIVE
- HTC VIVE PRO
- HTC VIVE Cosmos
- Oculus Rift S
- HP Reverb G1 (not the G2)
- Valve Index

_AVA360VR_ should work with any VR headset that supports _SteamVR_, including _Windows Mixed Reality_ and _Oculus_.
If you are unsure if you have a compatible laptop/workstation and VR headset/controllers, then just ask us.

You will need to install Steam and Steam VR with the relevant VR software for your headset, eg. _Windows Mixed Reality_, _Viveport_ or _Oculus_.
An account will have to be created for Steam (and also for other software to be able to use some VR headsets).

You will need to setup the room space so tracking will work with your headset and controllers.

### Downloading _AVA360VR_

Download the [latest build release](https://github.com/BigSoftVideo/AVA360VR/releases) from GitHub.

After you have downloaded the current release of _AVA360VR_, you should also download the latest `DEMO PACKAGE.zip` files.
If you have already done so, then there is no need to download it again unless there is an update.
This package includes all the [help tutorials](help.md) and a [demonstration project](demo.md).

### Installing _AVA360VR_

Unzip the release of AVA360VR that you downloaded to a folder on your computer, preferably a fast SSD drive (internal or external).
There is no need to install the software.
Just locate the `AVA360VR.exe` file in the root folder and launch the application.

### Running _AVA360VR_

If you are running the correct VR software with SteamVR, and the VR headset and controllers are recognised and tracked, then AVA360VR will load a menu screen so you can load your demo project.

See the [help](help.md) and [demo](demo.md) projects to get started with some pre-prepared projects with [open data](https://wiki.creativecommons.org/wiki/data) that are public under the [Creative Commons Attribution-NonCommercial-ShareAlike 4.0 International (CC BY-NC-SA 4.0)](http://creativecommons.org/licenses/by-nc-sa/4.0/) license.

![](images/Cc-by-nc-sa_icon.svg.png)
