## Main features of _AVA360VR_

This is a list of some of the key features of AVA360VR according to different categories, with links and some indication of whether or not there is a tutorial video (📼) or 'VolCap' (🌐) available in the [Demo Package](demo.md).
Note that all the VolCaps are also available to download rendered as flat 2D videos, but these videos cannot be included in the Demo Package because of space restrictions.
Instead, they are available for individual download from the [release page on GitHub](https://github.com/BigSoftVideo/AVA360VR/releases/tag/v3.0.0-tutorial-videos).
The VolCaps are 50 to 100 times smaller in MBytes than the equivalent video.
Besides making immersive VolCap Tutorials, the main purpose of this rich feature is for qualitative researchers to capture their live analyses volumetrically, replay them in 3D and share them with others to replay (and re-enact) immersively at a later date.
One could compare it to transplanar, volumetric CGI scenes found in cinema and television, such as _Star Trek_, _The Matrix_, _Ready Player One_, _Soul_, _Made for Love_, _The Flight Attendant_, _WandaVision_ and _Raised by Wolves_.

### Project management

- Add multimedia assets to your project folder structure (📼)
- [Create new projects and analyses](project.md) and load a saved analysis version in a project (📼)
- Build and manipulate a visual mapping of groups of analysis version in one project (🌐)
- Create multiple projects and map groups of saved analysis versions across projects (📼)

### Multimedia assets

- Import and play synced and unsynced audio-visual clips (🌐)
- Import and play multiple 360 videos and switch intuitively between them (🌐)
- Import and resize images and 3D models (🌐)

### Controls

- Use the buttons and radial menus on the controllers (🌐)
- Resize, pin and rotate lock all windows (🌐)
- Rotate the 360 scene (🌐)
- Toggle the audience view of the action (POV, over-the-shoulder, slide show, transcript viewer) (📼)

### Playback

- Scrub the timeline (video) (🌐)
- Synchronisation of all audio-visual assets imported in the scene
- View mirror cam that makes visible what is behind you (🌐)

### Sound

- Adjust the master volume (video) (🌐)
- Adjust the volume of individual audio sources (🌐)
- Mute and solo individual audio sources (🌐)
- Mix multiple audio sources together spatially (🌐)

### Sketching

- Draw on the 360 video (🌐)
- Animate drawings, objects and windows (🌐)

### Generating 2D representations

- Export 360 screenshots (video) (🌐)
- Generate and play 2D recam clips from the master 360 video (🌐)
- Create and export (Muybridge) keyframe sequences (🌐)
- Generate, edit and export comic panel sequences (🌐)

### Presenting

- Import, view and loop time-coded transcripts in VR (🌐)
- Present a slideshow in VR with timer countdown and play inserted video clips (🌐)
- Show handy private slide notes

### Capturing

- Create volumetric captures (VolCaps) while using AVA360VR (📼)
- Replay and pause VolCaps
- Teleport in a VolCap replay
- Toggle the audience view of the replay (static cameras, POV, Quad)
