#!/bin/bash


######## for Xingjie ########
######## a new script "fcFilter.sh" can be used on top of existing crispy run 
######## to get fc track that passed a pvalue cutoff and a sgRNA number cutoff. 
######## there are 2 input files and 1 output file. 
######## input INSGRNA (-s for crispy input), and input sgRNA pvalue tsv file (pvalTsv, generated by crispy)
######## output "fc.filtered" file in the same result directory. 
######## the key parameter to tweak is fcPvalCut
######## fcPvalCut=0.05 # eg. "0.05" # a sgRNA need to have <=$fcPvalCut to be considered for FC calculation. Default is 1 (consider all sgRNAs)


######## here is a demo 
## use sin3A, no qnorm as example. 

INREAD="demos/d4.SIN3A/reads.tsv"
INREGION="demos/d4.SIN3A/regions.bed"
INSGRNA="demos/d4.SIN3A/oligos.tsv"
DIR="results.sin3a"

############## mcherry
####### run Crispy
PREFIX="M"
./crispy.sh -i $INREAD \
            -r $INREGION \
            -s $INSGRNA \
            -o $DIR \
            -p $PREFIX \
            -b "XR029,XR034" \
            -f "XR032,XR037" \
           	-n 1

####### run fc filter
fcPvalCut=0.05 
./fcFilter.sh $INSGRNA $DIR $PREFIX $fcPvalCut

fcPvalCut=0.1 
./fcFilter.sh $INSGRNA $DIR $PREFIX $fcPvalCut

fcPvalCut=0.5 
./fcFilter.sh $INSGRNA $DIR $PREFIX $fcPvalCut

############### GFP
####### run Crispy
PREFIX="G"
./crispy.sh -i $INREAD \
            -r $INREGION \
            -s $INSGRNA \
            -o $DIR \
            -p $PREFIX \
            -b "XR029,XR034" \
            -f "XR031,XR036" \
           	-n 1

####### run fc filter
fcPvalCut=0.05 
./fcFilter.sh $INSGRNA $DIR $PREFIX $fcPvalCut

fcPvalCut=0.1 
./fcFilter.sh $INSGRNA $DIR $PREFIX $fcPvalCut

fcPvalCut=0.5 
./fcFilter.sh $INSGRNA $DIR $PREFIX $fcPvalCut

############## mcherry + GFP
####### run Crispy
PREFIX="MG"
./crispy.sh -i $INREAD \
            -r $INREGION \
            -s $INSGRNA \
            -o $DIR \
            -p $PREFIX \
            -b "XR029,XR034" \
            -f "XR031,XR036,XR032,XR037" \
           	-n 1

####### run fc filter
fcPvalCut=0.05 
./fcFilter.sh $INSGRNA $DIR $PREFIX $fcPvalCut

fcPvalCut=0.1 
./fcFilter.sh $INSGRNA $DIR $PREFIX $fcPvalCut

fcPvalCut=0.5 
./fcFilter.sh $INSGRNA $DIR $PREFIX $fcPvalCut


