#!/bin/bash


######## for Xingjie ########
######## a new script "fcFilter.sh" can be used on top of existing crispy run 
######## to get fc track that passed a pvalue cutoff and a sgRNA number cutoff. 
######## there are 2 input files and 1 output file. 
######## input INSGRNA (-s for crispy input), and input sgRNA pvalue tsv file (pvalTsv, generated by crispy)
######## output "fc.filtered" file in the same result directory. 
######## the key parameter to tweak is fcPvalCut
######## fcPvalCut=0.05 # eg. "0.05" # a sgRNA need to have <=$fcPvalCut to be considered for FC calculation. Default is 1 (consider all sgRNAs)


######## here is a demo 
## use sin3A, with qnorm as example. 

INREAD="demos/d7.sin3a.2/sin3a_ipsc_reads_3L_3R_12262018.tsv"
INREGION="demos/d7.sin3a.2/sin3a_regions.bed"
INSGRNA="demos/d7.sin3a.2/sin3a_oligos.tsv"
DIR="results.sin3a.qnorm"

############## mcherry
####### run Crispy
PREFIX="M.q"
./crispy.sh -i $INREAD \
            -r $INREGION \
            -s $INSGRNA \
            -o $DIR \
            -p $PREFIX \
            -b "XR029,XR034" \
            -f "XR032,XR037" \
			-q "XR029,XR034;XR030,XR035;XR032,XR037,XR031,XR036" \
           	-n 1

####### run fc filter
fcPvalCut=0.05 
./fcFilter.sh $INSGRNA $DIR $PREFIX $fcPvalCut

fcPvalCut=0.1 
./fcFilter.sh $INSGRNA $DIR $PREFIX $fcPvalCut

fcPvalCut=0.5 
./fcFilter.sh $INSGRNA $DIR $PREFIX $fcPvalCut

############### GFP
####### run Crispy
PREFIX="G.q"
./crispy.sh -i $INREAD \
            -r $INREGION \
            -s $INSGRNA \
            -o $DIR \
            -p $PREFIX \
            -b "XR029,XR034" \
            -f "XR031,XR036" \
			-q "XR029,XR034;XR030,XR035;XR032,XR037,XR031,XR036" \
           	-n 1

####### run fc filter
fcPvalCut=0.05 
./fcFilter.sh $INSGRNA $DIR $PREFIX $fcPvalCut

fcPvalCut=0.1 
./fcFilter.sh $INSGRNA $DIR $PREFIX $fcPvalCut

fcPvalCut=0.5 
./fcFilter.sh $INSGRNA $DIR $PREFIX $fcPvalCut

############## mcherry + GFP
####### run Crispy
PREFIX="MG.q"
./crispy.sh -i $INREAD \
            -r $INREGION \
            -s $INSGRNA \
            -o $DIR \
            -p $PREFIX \
            -b "XR029,XR034" \
            -f "XR031,XR036,XR032,XR037" \
			-q "XR029,XR034;XR030,XR035;XR032,XR037,XR031,XR036" \
           	-n 1

####### run fc filter
fcPvalCut=0.05 
./fcFilter.sh $INSGRNA $DIR $PREFIX $fcPvalCut

fcPvalCut=0.1 
./fcFilter.sh $INSGRNA $DIR $PREFIX $fcPvalCut

fcPvalCut=0.5 
./fcFilter.sh $INSGRNA $DIR $PREFIX $fcPvalCut


