---
name: Bug report
about: Create a report to help us improve
title: "[BUG]"
labels: bug
assignees: ''

---

Read the instructions and fill out your responses at the bottom.

## Instructions

### Description
A clear and concise description of what the bug is.

### Reproducibility

Describe the exact steps which reproduce the problem in as many details as possible. For example, start by explaining how you started the computing environment or which command exactly you used in the terminal. When listing steps, don't just say what you did, but explain how you did it.

Steps to reproduce the behavior:

1. Go to '...'
2. Click on '....'
3. Scroll down to '....'
4. See error

### Expectation

A clear and concise description of what you expected to happen.

### Recency

Did the problem start happening recently (e.g. after updating to a new version) or was this always a problem?

### Files

If the problem is related to working with files (e.g. opening and editing files), does the problem happen for all files and projects or only some? Does the problem happen only when working with local or remote files (e.g. on network drives), with files of a specific type (e.g. only JavaScript or Python files), with large files or files with very long lines, or with files in a specific encoding? Is there anything else special about the files you are using?

### Environment

- OS: [e.g. Windows 10, Ubuntu 18.04]
- Programming language and version: [e.g. MATLAB 2019a, Julia 1.1.1]
- Computing environment: [e.g. MATLAB, VS Code]
- Are you running in a virtual machine" [e.g. yes, no]
- Compiler (if applicable): [e.g. g++, cl]

### Screenshots

Include screenshots and animated GIFs which show you following the described steps and clearly demonstrate the problem. You can use this [tool](https://www.cockos.com/licecap/) to record GIFs on macOS and Windows, and this [tool](https://github.com/colinkeenan/silentcast) or this [tool](https://github.com/GNOME/byzanz) on Linux.

### Additional context

Add any other context about the problem here.

## FILL ME OUT

### Description

### Reproducibility

### Expectation

### Recency

### Files

### Environment

### Screenshots

### Additional
