/*---------------------------------------------------------------------------*\
Copyright (C) 2015 Cyrille Bonamy, Julien Chauchat, Tian-Jian Hsu
                   and contributors

License
    This file is part of SedFOAM.

    SedFOAM is free software: you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    SedFOAM is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
    FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
    for more details.

    You should have received a copy of the GNU General Public License
    along with SedFOAM.  If not, see <http://www.gnu.org/licenses/>.

\*---------------------------------------------------------------------------*/

#include "MuIdimLess.H"
#include "addToRunTimeSelectionTable.H"

// * * * * * * * * * * * * * * Static Data Members * * * * * * * * * * * * * //

namespace Foam
{
namespace granularRheologyModels
{
    defineTypeNameAndDebug(MuIdimLess, 0);
    addToRunTimeSelectionTable(FrictionModel, MuIdimLess, dictionary);
}
}

// * * * * * * * * * * * * * * * * Constructors  * * * * * * * * * * * * * * //

Foam::granularRheologyModels::MuIdimLess::MuIdimLess(const dictionary& dict)
:
    FrictionModel(dict)
{}


// * * * * * * * * * * * * * * * * Destructor  * * * * * * * * * * * * * * * //

Foam::granularRheologyModels::MuIdimLess::~MuIdimLess()
{}


// * * * * * * * * * * * * * * * Member Functions  * * * * * * * * * * * * * //

Foam::tmp<Foam::volScalarField> Foam::granularRheologyModels::MuIdimLess::muI
(
    const dimensionedScalar& mus,
    const dimensionedScalar& mu2,
    const dimensionedScalar& I0,
    const volScalarField& pa,
    const dimensionedScalar& rhoa,
    const dimensionedScalar& da,
    const dimensionedScalar& rhob,
    const dimensionedScalar& nub,
    const volScalarField& magD,
    const dimensionedScalar& Dsmall
) const
{
    // MuI inertial regime friction model: mu(I) = mus + (mu2-mus)/(I0/I+1)
    //          with I=da magD / sqrt(pa)
    return mus + (mu2 - mus)*magD/(I0*pow(pa, 0.5)/da + magD + Dsmall);
}

Foam::tmp<Foam::volScalarField> Foam::granularRheologyModels::MuIdimLess::I
(
    const volScalarField& pa,
    const dimensionedScalar& rhoa,
    const dimensionedScalar& da,
    const dimensionedScalar& rhob,
    const dimensionedScalar& nub,
    const volScalarField& magD
) const
{
    // inertial regime I=da magD / sqrt(pa)
    return magD * da * pow(pa, -0.5);
}
// ************************************************************************* //
