%% Simulate Shared Gas Burner
% Run the simulation and generate a tsv file containing a result of the simulation.
% All the configurations are hardcoded to the Simulink model

% Run the simulation using the shared gas burner model in Fig. 1 of [Doyen+, FORMATS'05].
result = sim('shared_gas_burner');

% Write the simulation result to the tsv file
result_matrix = [result.yout.signals(1).values, result.yout.signals(2).values, result.tout];
result_filename = 'raw_result.tsv';
writematrix(result_matrix, result_filename, 'FileType', 'text', 'Delimiter', 'tab');