Navigation
==========

This directory contains a robot navigation benchmark taken from [Fehnker & Ivančić,HSCC'04].

You can download generated files by the following.

```bash
wget XXXXXXXXXX -O navigation.zip
```

Files
-----

- `navigation_lha.dot`: The bounded model for the navigation benchmark. The LHA is generated by the overapproximation in [Frehse,STTT'08].
- `compute_robust.sh`: A shell script to compute the robustness of a log.
- `simulink/`: The directory containing the Simulink model.
- `simulink/navigation.slx`: The Simulink model of the navigation benchmark. The model is an affine hybrid automaton.
- `simulink/run.m`: A MATLAB script to run `navigation.slx` to generate logs.

Usage
-----

An example usage is as follows. You can download input traces from [here](XXXXXXXXXX).

```sh
../../build/hamoni --vector --c_polyhedron -f ./navigation_lha.dot < example_log.tsv
```

Reference
---------

- [Fehnker & Ivančić,HSCC'04]: Fehnker, Ansgar, and Franjo Ivančić. "Benchmarks for hybrid systems verification." International Workshop on Hybrid Systems: Computation and Control. Springer, Berlin, Heidelberg, 2004.
- [Frehse,STTT'08]: Frehse, Goran. "PHAVer: algorithmic verification of hybrid systems past HyTech." International Journal on Software Tools for Technology Transfer 10.3 (2008): 263-279.

