#!/usr/bin/env stack
-- stack runghc

import System.Random (randomRIO)
import System.Environment (getArgs)
import Data.List (intercalate)
import Control.Monad (replicateM, mapM)

flow0Each :: Int -> (Int, Int) -> IO Int
flow0Each duration (x, ind) = do
  flow <- randomRIO (indD - 1, 2 * indD)
  return $ (floor flow * (fromIntegral duration)) + x
  where
    indD :: Double
    indD = fromIntegral ind

flow0 :: Int -> [Int] -> IO [Int]
flow0 duration xs = mapM (flow0Each duration) xsWithIndex
  where
    xsWithIndex = zip xs [1..]

flow1Each :: Int -> (Int, Int) -> IO Int
flow1Each duration (x, ind) = do
  flow <- randomRIO (- indD - 1, - indD + 1)
  return $ (ceiling flow * (fromIntegral duration)) + x
  where
    indD :: Double
    indD = fromIntegral ind

flow1 :: Int -> [Int] -> IO [Int]
flow1 duration xs = mapM (flow1Each duration) xsWithIndex
  where
    xsWithIndex = zip xs [1..]

sample :: [Int] -> Loc -> Int -> IO [[Int]]
data Loc = L0 | L1
sample (t:xs) L0 size =
  if size == 0 then
    return []
  else do
    duration <- randomRIO (1, 2 :: Int)
    if last xs >= 5 * (length xs) then do
      goL1 <- randomRIO (0, 5 :: Int)
      if goL1 > 0 then do
        updatedXs <- replicateM ((length xs) `div`  2) $ randomRIO (-2, -1 :: Int)
        nextXs <- flow1 duration $ (take ((length xs) - ((length xs) `div` 2)) xs) ++ updatedXs
        if or $ map (\x -> x < -10 * dimension || 10 * dimension < x) nextXs then
          sample (t:xs) L0 size
          else do
          tailXss <- sample ((t + duration):nextXs) L1 (size - 1)
          return $ ((t + duration):nextXs) : tailXss
        else do
        nextXs <- flow0 duration xs
        if or $ map (\x -> x < -10 * dimension || 10 * dimension < x) nextXs then
          sample (t:xs) L0 size
          else do
          tailXss <- sample ((t + duration):nextXs) L0 (size - 1)
          return $ ((t + duration):nextXs) : tailXss
      else do
      nextXs <- flow0 duration xs
      if or $ map (\x -> x < -10 * dimension || 10 * dimension < x) nextXs then
          sample (t:xs) L0 size
          else do
          tailXss <- sample ((t + duration):nextXs) L0 (size - 1)
          return $ ((t + duration):nextXs) : tailXss
  where
    dimension = length xs
sample (t:xs) L1 size =
  if size == 0 then
    return []
  else do
    duration <- randomRIO (1, 2 :: Int)  
    if last xs <= -8 * (length xs) then do
      goL0 <- randomRIO (0, 5 :: Int)
      if goL0 > 0 then do
        updatedXs <- replicateM ((length xs) - ((length xs) `div` 2)) $ randomRIO (0, 1 :: Int)
        nextXs <- flow0 duration $ updatedXs ++ (drop ((length xs) - ((length xs) `div` 2)) xs)
        if or $ map (\x -> x < -10 * dimension || 10 * dimension < x) nextXs then
          sample (t:xs) L1 size
          else do
          tailXss <- sample ((t + duration):nextXs) L0 (size - 1)
          return $ ((t + duration):nextXs) : tailXss
        else do
        nextXs <- flow1 duration xs
        if or $ map (\x -> x < -10 * dimension || 10 * dimension < x) nextXs then
          sample (t:xs) L1 size
          else do
          tailXss <- sample ((t + duration):nextXs) L1 (size - 1)
          return $ ((t + duration):nextXs) : tailXss
      else do
      nextXs <- flow1 duration xs
      if or $ map (\x -> x < -10 * dimension || 10 * dimension < x) nextXs then
        sample (t:xs) L1 size
        else do
        tailXss <- sample ((t + duration):nextXs) L1 (size - 1)
        return $ ((t + duration):nextXs) : tailXss
  where
    dimension = length xs

main :: IO ()
main = do
  args <- getArgs
  if length args <= 1 then
    putStrLn "Usage: ./genRP11.hs [DIMENSION] [LENGTH]"
    else
      let dimension = read $ head args :: Int
          size = read $ head $ tail args :: Int in
        if dimension < 1 then
          putStrLn "Error: dimension should be a positive integer."
        else do
         xs <- replicateM dimension $ randomRIO (0, 1 :: Int)
         xss <- map (\ (t:xs) -> xs ++ [t]) <$> sample (0:xs) L0 size
         putStr $ unlines $ (map unwords) $ map (map show) xss
