RP11
====

This directory contains an example taken from [RP11]. RP11 example is a kind of conformance monitoring.

You can download generated files by the following.

```bash
wget https://1drv.ws/u/s!AgmwSTftArYRjX8xCCzW9RjFNBb5?e=YILoJh -O RP11.zip
```

Files
-----

- `genRP11Dot.hs`: The Haskell script to generate the bounded model for RP11 benchmark with the specified parameters.
- `genRP11Word.hs`: The Haskell script to generate the models used in the experiment.
- `Makefile`: The Makefile to generate suitable bounded models and logs. We note that the generated logs (and also models) are available from [here](https://1drv.ws/u/s!AgmwSTftArYRjX8xCCzW9RjFNBb5?e=YILoJh).
- `models/*.dot`: The generated bounded models.

Usage
-----

An example usage is as follows. You can download input traces from [here](https://1drv.ws/u/s!AgmwSTftArYRjX8xCCzW9RjFNBb5?e=YILoJh).

```sh
./genRP11Word.hs 2 10 | ../../build/hamoni --vector --c_polyhedron -f ./models/RP11-2.dot 
```

genRP11Dot.hs
------------

You can generate models by `genRP11Dot.hs`. The example usage is as follows.

```bash
./genACCDot.hs 2 # generate the model of dimension 2
./genACCDot.hs 5 # generate the model of dimension 5
./genACCDot.hs 10 # generate the model of dimension 10
```

genRP11Word.hs
------------

You can generate logs by `genRP11Word.hs`. The example usage is as follows.

```bash
./genACCWord.hs 2 10 # generate the model of dimension 2 and length 10
./genACCWord.hs 5 50 # generate the model of dimension 5 and length 50
```

Reference
---------

- [RP11]: Chen, Xin, Erika Ábrahám, and Goran Frehse. "Efficient bounded reachability computation for rectangular automata." International Workshop on Reachability Problems. Springer, Berlin, Heidelberg, 2011.

