example
=======

This directory contains the following examples of HAMoni. See each directory for an example usage.

- ACCC
- ACCI
- RP11
- simple_acc
- overapprox
- shared\_gas\_model
- navigation

ACCC
----

The directory `ACCC` contains the Adaptive Cruise Control of Constant dynamics (ACCC) benchmark taken from [Bu+,ARCH-COMP19].

ACCI
----

The directory `ACCI` contains the Adaptive Cruise Control of Interval dynamics (ACCI) benchmark taken from [Frehse+,ARCH-COMP19].

RP11
----

The directory `RP11` contains the benchmark taken from [Chen+,RP11]. This benchmark is useful to observe the scalability with respect to the number of the dimensions because we can change the dimensions without changing the number of the locations.

simple_acc
----------

The directory `simple_acc` contain a simple example of an adaptive cruise control model.

overapprox
----------

The directory `overapprox` contains the examples to show that `--box` and `--bds` options of `hamoni` actually cause overapproximation.

shared\_gas\_model
------------------

The directory `shared_gas_model` contains the shared gas burner model taken from [Doyen+,FORMATS'05]. In shared gas model, the original model is an affine hybrid automaton while the bounding model is an LHA, and thus there can be false alarms due to the approximation.

navigation
----------

The directory `navigation` contains the navigation model taken from [Fehnker & Ivančić,HSCC'04]. In navigation model, there can be false alarms due to the same reason as the navigation benchmark.

Reference
---------

- [Bu+,ARCH-COMP19]: Bu, Lei, Rajarshi Ray, and Stefan Schupp. "ARCH-COMP19 Category Report: Bounded Model Checking of Hybrid Systems with Piecewise Constant Dynamics." EPiC Series in Computing 61 (2019): 120-128.
- [Chen+,RP11]: Efficient Bounded Reachability Computation for Rectangular Automata, Chen et al., RP 2011.
- [Frehse+,ARCH-COMP19]: Frehse, Goran, et al. "ARCH-COMP19 Category Report: Hybrid Systems with Piecewise Constant Dynamics." EPiC Series in Computing 61 (2019): 1-13.
- [Doyen+,FORMATS'05]: Doyen, Laurent, Thomas A. Henzinger, and Jean-François Raskin. "Automatic rectangular refinement of affine hybrid systems." International Conference on Formal Modeling and Analysis of Timed Systems. Springer, Berlin, Heidelberg, 2005.
- [Fehnker & Ivančić,HSCC'04]: Fehnker, Ansgar, and Franjo Ivančić. "Benchmarks for hybrid systems verification." International Workshop on Hybrid Systems: Computation and Control. Springer, Berlin, Heidelberg, 2004.
