Adaptive Cruise Controller (ACCI)
=================================

This directory contains the adaptive cruise controller model in [Frehse+, ARCH-COMP'19]. For detail, we referred the [PHAVerLite benchmarks](http://www.cs.unipr.it/~zaffanella/PPLite/releases/sas19.tar.gz) rather than the original paper.

Files
-----

- `genACCDot.hs`: The Haskell script to generate the bounded model for ACCI benchmark with the specified parameters
- `generate_models.sh`: The shell script to run `genACCDot.hs` to generate the models used in the experiment.
- `Makefile`: The Makefile to generate suitable bounded models and logs. We note that the generated logs (and also models) are available from [here](https://1drv.ms/u/s!AgmwSTftArYRjhYZoQF3PGWbQ5mu?e=UJhH3p).
- `models/*.dot`: The generated bounded models.

Usage
-----

An example usage is as follows. You can also use other input traces from [here](https://1drv.ms/u/s!AgmwSTftArYRjhYZoQF3PGWbQ5mu?e=UJhH3p). We note that we use `hamoni-sim` to simulate the bounding model.

```sh
# The following returns matching because the log follows the dynamics in the bounding model
../../build/hamoni-sim -f ./models/ACCU02_conformance.dot -l 50 | ../../build/hamoni --vector --c_polyhedron -f ./models/ACCU02_conformance.dot
# The following returns "no reachable configuration" warning because the log does not follows the dynamics in the bounding model.
../../build/hamoni-sim -f ./models/ACCS02_conformance.dot -l 50 | ../../build/hamoni --vector --c_polyhedron -f ./models/ACCU02_conformance.dot
```


Parameters
----------

The ACCI benchmark has the following three parameters. 

- safe vs. unsafe (`U` or `S`)
    - This defines if the system is safe or unsafe by changing the flow. See [Frehse+, ARCH-COMP'19] for the detail.
- safety vs. conformance (`safety` or `conformance`)
    - This defines if the objective is to monitor the safety (i.e. accepting iff. we have a safety violation) or conformance (i.e. accepting iff. the values in the log follow the dynamics in the bounding model).
- system dimension (an integer number)
    - This defines the dimension of the system

genACCDot.hs
------------

You can generate models by `genACCDot.hs`. The example usage is as follows.

```bash
./genACCDot.hs U safety 2
./genACCDot.hs S safety 4
./genACCDot.hs U conformance 3
./genACCDot.hs S conformance 5
```

Reference
---------

- [Frehse+, ARCH-COMP'19]: Frehse, Goran, et al. "ARCH-COMP19 Category Report: Hybrid Systems with Piecewise Constant Dynamics." EPiC Series in Computing 61 (2019): 1-13.

