<?xml version="1.0" encoding="UTF-8"?>
<!--
    USAGE
      saxon -xslt:hamoni.xsl motorcar_5.xml
    NOTE
      I tested this xslt code using saxson
-->
<xsl:stylesheet version="2.0"
  xmlns:spaceex="http://www-verimag.imag.fr/xml-namespaces/sspaceex"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="text" encoding="UTF-8" indent="no"/>

<xsl:template match="/">
  <xsl:apply-templates select="spaceex:sspaceex/spaceex:component[1]" />
</xsl:template>

<xsl:template match="spaceex:component">
  <xsl:text>digraph </xsl:text><xsl:value-of select="@id" /><xsl:text>{
  graph [dimension=</xsl:text>
  <xsl:value-of select="count(//spaceex:component[1]/spaceex:param[@type='real'])" />
  <xsl:text>];
  </xsl:text>
  <xsl:apply-templates select="spaceex:location" />
  <xsl:apply-templates select="spaceex:transition" />
  <xsl:text>}</xsl:text>
</xsl:template>

<xsl:template match="spaceex:location">
  <xsl:value-of select="@name"/>
  <xsl:text> [</xsl:text>
  <!-- This match is ad hoc to ACCC benchmark-->
  <!--FROM HERE-->
  <xsl:if test="position()=last()">
    <xsl:text>match=1, </xsl:text>
  </xsl:if>
  <xsl:if test="not(position()=last())">
    <xsl:text>match=0, </xsl:text>
  </xsl:if>
  <!--TO HERE-->
  <xsl:apply-templates select="spaceex:invariant" />
  <xsl:apply-templates select="spaceex:flow" />
  <!-- This init_zone is ad hoc to NAV benchmark-->
  <!--FROM HERE-->
  <xsl:if test="position()=1">
    <xsl:variable name="dimension" select="count(//spaceex:component[1]/spaceex:param[@type='real'])" />
    <xsl:text>init_zone="{</xsl:text>
    <xsl:for-each select='//spaceex:component[1]/spaceex:param[@type="real"]'>
      <xsl:value-of select='@name' />
      <xsl:text> == </xsl:text>
      <xsl:value-of select='$dimension * 5 + 20 - 5 * position()' />
      <xsl:if test="not(position()=last())">
        <xsl:text>, </xsl:text>
      </xsl:if>
    </xsl:for-each>
    <xsl:text>};"</xsl:text>
  </xsl:if>
  <xsl:if test="not(position()=1)">
    <xsl:text>init_zone="{false};"</xsl:text>
  </xsl:if>
  <!--TO HERE-->
  <xsl:text>];
  </xsl:text>
</xsl:template>

<xsl:template match="spaceex:invariant">
  <xsl:text>invariant="{</xsl:text>
  <xsl:value-of select='replace(replace(., " &amp;", ","), "&lt;=(x\d+)&lt;=", " &lt;= $1, $1 &lt;= ")' />
  <xsl:text>};"</xsl:text>
  <xsl:text>, </xsl:text>    
</xsl:template>

<xsl:template match="spaceex:flow">
  <xsl:text>flow="{</xsl:text>
  <xsl:value-of select='replace(replace(., " &amp;", ","), "&apos;", "")' />
  <xsl:text>};"</xsl:text>  
  <xsl:text>, </xsl:text>
</xsl:template>

<xsl:template match="spaceex:transition">
  <xsl:variable name="src_id" select="@source" />
  <xsl:variable name="tgt_id" select="@target" />
  <xsl:value-of select="//spaceex:location[@id=$src_id]/@name" />
  <xsl:text> -> </xsl:text>
  <xsl:value-of select="//spaceex:location[@id=$tgt_id]/@name" />
  <xsl:text> [</xsl:text>
  <xsl:apply-templates select="spaceex:guard" />
  <!-- This is specific to NAV model -->
  <xsl:text>, updated_vars="{}", updated_zone="{true};"];
  </xsl:text>
</xsl:template>

<xsl:template match="spaceex:guard">
  <xsl:text>guard="{</xsl:text>
  <xsl:value-of select="text()" />
  <xsl:text>};"</xsl:text>  
</xsl:template>

</xsl:stylesheet>
