#include <sstream>
#include <boost/test/unit_test.hpp>
#include "../src/io_operators.hh"

BOOST_AUTO_TEST_SUITE(IOOperatorsTest)
BOOST_AUTO_TEST_SUITE(ConstraintSystems)

BOOST_AUTO_TEST_CASE(SingleConstraintTest1) {
  using namespace Parma_Polyhedra_Library;

  const std::string str = "{2 <= x0 - x1};";
  std::stringstream stream;
  stream << str;
  Constraint_System cs;
  BOOST_TEST(stream.good());
  BOOST_TEST(!stream.bad());
  BOOST_TEST(!stream.eof());
  BOOST_TEST(!stream.fail());
  stream >> cs;
  BOOST_TEST(stream.good());
  BOOST_TEST(!stream.bad());
  BOOST_TEST(!stream.eof());
  BOOST_TEST(!stream.fail());

  auto x0 = Variable(0);
  auto x1 = Variable(1);
  auto expected = Constraint_System(2 <= x0 - x1);
  BOOST_TEST((expected == cs));
}

BOOST_AUTO_TEST_CASE(MultipleConstraintsTest1) {
  using namespace Parma_Polyhedra_Library;

  const std::string str = "{2 <= x0 - x1, x0 - x1 >= 10};";
  std::stringstream stream;
  stream << str;
  Constraint_System cs;
  BOOST_TEST(stream.good());
  BOOST_TEST(!stream.bad());
  BOOST_TEST(!stream.eof());
  BOOST_TEST(!stream.fail());
  stream >> cs;
  BOOST_TEST(stream.good());
  BOOST_TEST(!stream.bad());
  BOOST_TEST(!stream.eof());
  BOOST_TEST(!stream.fail());

  auto x0 = Variable(0);
  auto x1 = Variable(1);
  auto expected = Constraint_System(2 <= x0 - x1);
  expected.insert(x0 - x1 >= 10);
  BOOST_TEST((expected == cs));
}

BOOST_AUTO_TEST_CASE(DiagonalMultiplicationConstraintsTest1) {
  using namespace Parma_Polyhedra_Library;

  const std::string str = "{10 * x0 - 10 * x1 <= 10};";
  std::stringstream stream;
  stream << str;
  Constraint_System cs;
  BOOST_TEST(stream.good());
  BOOST_TEST(!stream.bad());
  BOOST_TEST(!stream.eof());
  BOOST_TEST(!stream.fail());
  stream >> cs;
  BOOST_TEST(stream.good());
  BOOST_TEST(!stream.bad());
  BOOST_TEST(!stream.eof());
  BOOST_TEST(!stream.fail());

  auto x0 = Variable(0);
  auto x1 = Variable(1);
  auto expected = Constraint_System(x0 - x1 <= 1);
  BOOST_TEST((expected == cs));
}

BOOST_AUTO_TEST_SUITE_END() // ConstraintSystems

BOOST_AUTO_TEST_SUITE(VariablesSet)

BOOST_AUTO_TEST_CASE(EmptyTest1) {
  using namespace Parma_Polyhedra_Library;

  const std::string str = "{}";
  std::stringstream stream;
  stream << str;
  Variables_Set vs;
  BOOST_TEST(stream.good());
  BOOST_TEST(!stream.bad());
  BOOST_TEST(!stream.eof());
  BOOST_TEST(!stream.fail());
  stream >> vs;
  BOOST_TEST(stream.good());
  BOOST_TEST(!stream.bad());
  BOOST_TEST(!stream.eof());
  BOOST_TEST(!stream.fail());

  auto expected = Variables_Set();
  BOOST_TEST((expected == vs));
}

BOOST_AUTO_TEST_CASE(SingleVariableTest1) {
  using namespace Parma_Polyhedra_Library;

  const std::string str = "{x1}";
  std::stringstream stream;
  stream << str;
  Variables_Set vs;
  BOOST_TEST(stream.good());
  BOOST_TEST(!stream.bad());
  BOOST_TEST(!stream.eof());
  BOOST_TEST(!stream.fail());
  stream >> vs;
  BOOST_TEST(stream.good());
  BOOST_TEST(!stream.bad());
  BOOST_TEST(!stream.eof());
  BOOST_TEST(!stream.fail());

  auto expected = Variables_Set(Variable(1));
  BOOST_TEST((expected == vs));
}

BOOST_AUTO_TEST_CASE(MultipleConstraintsTest1) {
  using namespace Parma_Polyhedra_Library;

  const std::string str = "{x1, x3}";
  std::stringstream stream;
  stream << str;
  Variables_Set vs;
  BOOST_TEST(stream.good());
  BOOST_TEST(!stream.bad());
  BOOST_TEST(!stream.eof());
  BOOST_TEST(!stream.fail());
  stream >> vs;
  BOOST_TEST(stream.good());
  BOOST_TEST(!stream.bad());
  BOOST_TEST(!stream.eof());
  BOOST_TEST(!stream.fail());

  auto expected = Variables_Set(Variable(1));
  expected.insert(Variable(3));
  BOOST_TEST((expected == vs));
}

BOOST_AUTO_TEST_CASE(MultipleConstraintsTest2) {
  using namespace Parma_Polyhedra_Library;

  const std::string str = "{x1 x2}";
  std::stringstream stream;
  stream << str;
  Variables_Set vs;
  BOOST_TEST(stream.good());
  BOOST_TEST(!stream.bad());
  BOOST_TEST(!stream.eof());
  BOOST_TEST(!stream.fail());
  stream >> vs;
  BOOST_TEST(stream.good());
  BOOST_TEST(!stream.bad());
  BOOST_TEST(!stream.eof());
  BOOST_TEST(!stream.fail());

  auto expected = Variables_Set(Variable(1));
  expected.insert(Variable(2));
  BOOST_TEST((expected == vs));
}

BOOST_AUTO_TEST_CASE(MultipleConstraintsTest3) {
  using namespace Parma_Polyhedra_Library;

  const std::string str = "{x1  , ,  x0}";
  std::stringstream stream;
  stream << str;
  Variables_Set vs;
  BOOST_TEST(stream.good());
  BOOST_TEST(!stream.bad());
  BOOST_TEST(!stream.eof());
  BOOST_TEST(!stream.fail());
  stream >> vs;
  BOOST_TEST(stream.good());
  BOOST_TEST(!stream.bad());
  BOOST_TEST(!stream.eof());
  BOOST_TEST(!stream.fail());

  auto expected = Variables_Set(Variable(0));
  expected.insert(Variable(1));
  BOOST_TEST((expected == vs));
}

BOOST_AUTO_TEST_SUITE_END() // VariablesSet

BOOST_AUTO_TEST_SUITE_END() // IOOperatorsTest
