#pragma once
/*!
  @file invalid_transit_automaton_fixture.hh
  @brief Fixture for the LHA with a transition violating the target invariant
  @author Masaki Waga <masakiwaga@gmail.com>
  @date 2020/06/09
  @copyright GPL3+
  @sa vector_monitor_test.cc
*/

 #include <sstream>

#include "../../src/automaton.hh"

/*
  @brief This automaton contains a transition violating the target invariant
*/
struct InvalidTransitionFixture {
  InvalidTransitionFixture() {
    Parma_Polyhedra_Library::Variable x = Parma_Polyhedra_Library::Variable(0);
    auto clock = Parma_Polyhedra_Library::Variable(1);

    // Construct automaton
    automaton.states.resize(2);
    for (auto &state: automaton.states) {
      state = std::make_shared<PolyhedraHAState>();
    }
    /// set accept/reject
    automaton.states[0]->isMatch = false;
    automaton.states[1]->isMatch = true;

    /// set the invariant
    automaton.states[0]->invariant = Parma_Polyhedra_Library::NNC_Polyhedron(2);
    automaton.states[1]->invariant = Parma_Polyhedra_Library::NNC_Polyhedron(2);
    automaton.states[1]->invariant.add_constraint(x > 2);

    /// set the flow
    Parma_Polyhedra_Library::Constraint_System flowCS;
    flowCS.insert(x == 1);
    flowCS.insert(clock == 1);
    automaton.states[0]->flow = Parma_Polyhedra_Library::NNC_Polyhedron(flowCS);
    automaton.states[1]->flow = Parma_Polyhedra_Library::NNC_Polyhedron(flowCS);

    // set the initial zone
    Parma_Polyhedra_Library::Constraint_System initCS;
    initCS.insert(x == 0);
    initCS.insert(clock == 0);
    automaton.states[0]->initZone = Parma_Polyhedra_Library::NNC_Polyhedron(initCS);
    // We put another dimension for clock variable
    automaton.states[1]->initZone = Parma_Polyhedra_Library::NNC_Polyhedron(2, Parma_Polyhedra_Library::EMPTY);

    // Set the transitions
    const auto emptyVariables = Parma_Polyhedra_Library::Variables_Set();
    const auto universalZone = Parma_Polyhedra_Library::NNC_Polyhedron(Dimension + 1);

    // #### FROM STATE 0 ####
    automaton.states[0]->next.resize(1);
    {
      auto tmpZone = universalZone;
      tmpZone.add_constraint(x < 1);
      automaton.states[0]->next[0] = {tmpZone, emptyVariables, universalZone, automaton.states[1]};
    }

    // #### FROM STATE 1 ####
    automaton.states[1]->next.clear();
  }

  /*!
    @brief The hybrid automaton
    
    Since there are diagonal constraints and invariants, we use NNC_Polyhedron.
   */
  const std::size_t Dimension = 1;
  PolyhedraHA automaton {Dimension};
};
