#include <boost/test/unit_test.hpp>
#include <boost/mpl/list.hpp>
#include "../src/automaton.hh"

using namespace Parma_Polyhedra_Library;

BOOST_AUTO_TEST_SUITE(FlowTest)

BOOST_AUTO_TEST_CASE(NNC_Polyhedra_Test1)
{
  auto x = Parma_Polyhedra_Library::Variable(0);
  auto y = Parma_Polyhedra_Library::Variable(1);
  auto state = std::make_shared<AutomatonState<NNC_Polyhedron, Variables_Set>>();
  auto confZone = NNC_Polyhedron(2);
  confZone.add_constraint(x < 10);
  confZone.add_constraint(x > 5);
  confZone.add_constraint(y < 2);
  confZone.add_constraint(y > 1);

  state->invariant = NNC_Polyhedron(2);
  state->invariant.add_constraint(y < 10);

  state->flow = NNC_Polyhedron(2);
  state->flow.add_constraint(x < 2);
  state->flow.add_constraint(x > 1);
  state->flow.add_constraint(y < 2);
  state->flow.add_constraint(y > 1);

  flow(state, confZone);

  auto expectedZone = NNC_Polyhedron(2);
  expectedZone.add_constraint(x > 5);
  expectedZone.add_constraint(y > 1);
  expectedZone.add_constraint(y < 10);
  expectedZone.add_constraint(2 * (y - 1) > x - 10);
  expectedZone.add_constraint((y - 2) < 2 * (x - 5));

  using namespace Parma_Polyhedra_Library::IO_Operators;
  // std::cout << confZone << std::endl;
  BOOST_TEST((expectedZone == confZone));
}

BOOST_AUTO_TEST_SUITE_END()


BOOST_AUTO_TEST_SUITE(TransitTest)

BOOST_AUTO_TEST_CASE(NNC_Polyhedra_Test1)
{
  auto x = Parma_Polyhedra_Library::Variable(0);
  auto y = Parma_Polyhedra_Library::Variable(1);
  AutomatonTransition<NNC_Polyhedron, Variables_Set> transition;
  auto confZone = NNC_Polyhedron(2);
  confZone.add_constraint(x < 10);
  confZone.add_constraint(x > 1);
  confZone.add_constraint(y < 2);
  confZone.add_constraint(y > 1);

  transition.updatedZone = NNC_Polyhedron(2);
  transition.updatedZone.add_constraint(y < 10);

  transition.guard = NNC_Polyhedron(2);
  transition.guard.add_constraint(x < 2);
  transition.guard.add_constraint(x > 1);
  transition.guard.add_constraint(y < 2);
  transition.guard.add_constraint(y > 1);

  auto target = std::make_shared<AutomatonState<NNC_Polyhedron, Variables_Set>>();
  target->invariant = NNC_Polyhedron(2);
  transition.target = target;

  BOOST_TEST(transit(transition, confZone));

  auto expectedZone = NNC_Polyhedron(2);
  expectedZone.add_constraint(x > 1);
  expectedZone.add_constraint(x < 2);
  expectedZone.add_constraint(y > 1);
  expectedZone.add_constraint(y < 2);

  using namespace Parma_Polyhedra_Library::IO_Operators;
  // std::cout << confZone << std::endl;
  BOOST_TEST((expectedZone == confZone));
}

BOOST_AUTO_TEST_CASE(NNC_Polyhedra_Test2)
{
  auto x = Parma_Polyhedra_Library::Variable(0);
  auto y = Parma_Polyhedra_Library::Variable(1);
  AutomatonTransition<NNC_Polyhedron, Variables_Set> transition;
  auto confZone = NNC_Polyhedron(2);
  confZone.add_constraint(x < 10);
  confZone.add_constraint(x > 1);
  confZone.add_constraint(y < 2);
  confZone.add_constraint(y > 1);

  transition.updatedZone = NNC_Polyhedron(2);
  transition.updatedZone.add_constraint(y < 10);

  transition.guard = NNC_Polyhedron(2);
  transition.guard.add_constraint(x < 2);
  transition.guard.add_constraint(x > 1);
  transition.guard.add_constraint(y < 4);
  transition.guard.add_constraint(y > 3);

  auto target = std::make_shared<AutomatonState<NNC_Polyhedron, Variables_Set>>();
  target->invariant = NNC_Polyhedron(2);
  transition.target = target;

  BOOST_TEST(!transit(transition, confZone));
}

BOOST_AUTO_TEST_SUITE_END()
