#pragma once

#include "powerset_monitor.hh"
#include "vector_monitor.hh"

template<typename Zone>
struct PowersetPrinter : public Observer<PowersetMonitorResult<Zone>> {
  PowersetPrinter() = default;

  virtual ~PowersetPrinter() = default;

  void notify(const PowersetMonitorResult<Zone> &result) override {
    using Parma_Polyhedra_Library::IO_Operators::operator<<;
    std::cout << "@" << result.timestamp << ".\t(time-point " << result.index << ")\t";
    std::cout << result.zone
              << "\n";
  }
};

template<typename Zone>
struct VectorPrinter : public Observer<VectorMonitorResult<Zone>> {
  VectorPrinter() = default;

  virtual ~VectorPrinter() = default;

  void notify(const VectorMonitorResult<Zone> &result) override {
    using Parma_Polyhedra_Library::IO_Operators::operator<<;
    std::cout << "@" << result.timestamp << ".\t(time-point " << result.index << ")\t";
    std::cout << result.zone
              << "\n";
  }
};
