/*!
  @file io_operators.hh
 */
#pragma once

#include <iostream>
#include <functional>
#define mem_fun_ref mem_fn
#include <ppl.hh>
#include "constraint_driver.hh"

static inline
std::istream &operator>>(std::istream &is, Parma_Polyhedra_Library::Constraint_System &cs) {
  static ConstraintDriver driver;
  driver.parse(is);
  cs = driver.getResult();
  return is;
}

static inline
std::istream &operator>>(std::istream &is, Parma_Polyhedra_Library::Variables_Set &vs) {
  if (is.get() != '{') {
    is.setstate(std::ios_base::failbit);
    return is;
  }

  if (!is) {
    is.setstate(std::ios_base::failbit);
    return is;
  }

  vs = Parma_Polyhedra_Library::Variables_Set();
  while (true) {
    bool found = false;
    do {
      found = false;
      if (is.eof()) {
        return is;
      }
      switch (is.get()) {
      case 'x':
        found = true;
      case ' ':
      case ',':
        break;
      case EOF:
      case '}':
        return is;
      default:
        is.setstate(std::ios_base::failbit);
        return is;      
      }
    } while (!found);
    std::size_t id;
    is >> id;
    auto x = Parma_Polyhedra_Library::Variable(id);
    vs.insert(std::move(x));
  }

  return is;
}
