%skeleton "lalr1.cc"
%require  "3.0"
%debug 
%defines 
%define parser_class_name {ConstraintParser}
//                       %define api.parser.class {ConstraintParser}

%code requires{
   #include <memory>
   #include <functional>
   #define mem_fun_ref mem_fn
   #define register 
   #include <ppl.hh>
   class ConstraintDriver;
   class ConstraintScanner;
}

%parse-param { ConstraintScanner  &scanner  }
%parse-param { ConstraintDriver  &driver  }

%code{
   #include <iostream>
   #include <cstdlib>
   #include <fstream>

   #include "constraint_driver.hh"

#undef yylex
#define yylex scanner.yylex
}

%define api.value.type variant
%define parse.assert

%token END 0  "end of file"
%token BLANK
%token <int>       INT
%token <int>       VARIABLE
%token
  PLUS        "+"
  MINUS       "-"
  STAR        "*"
  LPAREN      "("
  RPAREN      ")"
  LT          "<"
  LE          "<="
  GE          ">="
  GT          ">"
  EQ          "=="
  COMMA       ","
  BEGIN_TOKEN "{"
  TRUE "true"
  FALSE "false"
;

%left LT GT EQ NE LE GE
%left PLUS MINUS
%left STAR

%locations

%type <Parma_Polyhedra_Library::Constraint_System>   constraint_system
%type <Parma_Polyhedra_Library::Constraint>          constraint
%type <Parma_Polyhedra_Library::Linear_Expression>   expr
%type <int>   integer
%type <std::size_t>                                  variable

%%

unit : BEGIN_TOKEN constraint_system END { driver.result = $2; }

constraint_system : TRUE { $$ = Parma_Polyhedra_Library::Constraint_System();}
                  | FALSE { $$ = Parma_Polyhedra_Library::Constraint_System(Parma_Polyhedra_Library::Variable(0) > Parma_Polyhedra_Library::Variable(0));}
                  | constraint { $$ = Parma_Polyhedra_Library::Constraint_System($1);}
                  | constraint_system COMMA constraint { $1.insert($3); $$ = std::move($1);}

/* The order matters */
constraint : expr LT expr { $$ = $1 < $3; }
           | expr LT integer { $$ = $1 < $3; }
           | integer LT expr { $$ = $1 < $3; }
           | expr GT expr { $$ = $1 > $3; }
           | expr GT integer { $$ = $1 > $3; }
           | integer GT expr { $$ = $1 > $3; }
           | expr LE expr { $$ = $1 <= $3; }
           | expr LE integer { $$ = $1 <= $3; }
           | integer LE expr { $$ = $1 <= $3; }
           | expr GE expr { $$ = $1 >= $3; }
           | expr GE integer { $$ = $1 >= $3; }
           | integer GE expr { $$ = $1 >= $3; }
           | expr EQ expr { $$ = $1 == $3; }
           | expr EQ integer { $$ = $1 == $3; }
           | integer EQ expr { $$ = $1 == $3; }

expr : variable { $$ = Parma_Polyhedra_Library::Variable($1); }
     | expr STAR integer { $$ = $1 * $3; }
     | integer STAR expr { $$ = $1 * $3; }
     | PLUS expr { $$ = +$2; }
     | expr PLUS expr { $$ = $1 + $3; }
     | integer PLUS expr { $$ = $1 + $3; }
     | expr PLUS integer { $$ = $1 + $3; }
     | MINUS expr { $$ = -$2; }
     | expr MINUS expr { $$ = $1 - $3; }
     | integer MINUS expr { $$ = $1 - $3; }
     | expr MINUS integer { $$ = $1 - $3; }

integer : INT { $$ = $1; }
        | integer STAR integer { $$ = $1 * $3; }
        | PLUS integer { $$ = +$2; }
        | integer PLUS integer { $$ = $1 + $3; }
        | MINUS integer { $$ = -$2; }
        | integer MINUS integer { $$ = $1 - $3; }


variable : VARIABLE { $$ = $1; }
%%



void yy::ConstraintParser::error( const location_type &l, const std::string &err_message )
{
   std::cerr << "Error: " << err_message << " at " << l << "\n";
}
