#pragma once

#include <cstdlib>
#include <cstdint>
#include <memory>
#include <vector>
#include <functional>
#define mem_fun_ref mem_fn
#include <ppl.hh>

/*!
  @brief An automaton
 */
template<class State>
struct Automaton {
  //! @brief The states of this automaton.
  std::vector<std::shared_ptr<State>> states;

  //! @brief Returns the number of the states.
  inline std::size_t stateSize() const {return states.size ();}

  inline bool operator == (const Automaton<State> &A) const {
    return states == A.states;
  }
};

template<typename, typename = void>
struct hasStringUpdate : std::false_type {};

template<typename T>
struct hasStringUpdate<T, std::void_t<decltype(std::declval<T>().stringUpdate)>> : std::true_type {};

template<typename, typename = void>
struct hasNumberUpdate : std::false_type {};

template<typename T>
struct hasNumberUpdate<T, std::void_t<decltype(std::declval<T>().numberUpdate)>> : std::true_type {};

template<typename Update>
struct UpdateTraits {
  static_assert(hasStringUpdate<Update>::value, "Update must have a member ``stringUpdate''.");
  static_assert(hasNumberUpdate<Update>::value, "Update must have a member ``numberUpdate''.");

  static decltype(std::declval<Update>().stringUpdate)& stringUpdate(Update& update) {
    return update.stringUpdate;
  }
  static decltype(std::declval<Update>().numberUpdate)& numberUpdate(Update& update) {
    return update.numberUpdate;
  }
};

template<typename, typename = void>
struct hasUnconstrain : std::false_type {};

template<typename T>
struct hasUnconstrain<T, std::void_t<decltype(std::declval<T>().unconstrain(std::declval<Parma_Polyhedra_Library::Variables_Set>()))>> : std::true_type {};

template<typename, typename, typename = void>
struct hasIntersectionAssign : std::false_type {};

template<typename T, typename U>
struct hasIntersectionAssign<T, U, std::void_t<decltype(std::declval<T>().intersection_assign(std::declval<U>()))>> : std::true_type {};

template<typename, typename, typename = void>
struct hasTimeElapseAssign : std::false_type {};

template<typename T, typename U>
struct hasTimeElapseAssign<T, U, std::void_t<decltype(std::declval<T>().time_elapse_assign(std::declval<U>()))>> : std::true_type {};
