#pragma once

#include <boost/graph/adjacency_list.hpp>
// io_operators.hh should come before graphviz.hpp
#include "io_operators.hh"

namespace boost {
  using ::operator>>;
  using ::operator<<;
  using Parma_Polyhedra_Library::IO_Operators::operator<<;
  using namespace Parma_Polyhedra_Library::IO_Operators;
}

namespace std {
  using ::operator>>;
  using ::operator<<;
  using Parma_Polyhedra_Library::IO_Operators::operator<<;
  using namespace Parma_Polyhedra_Library::IO_Operators;
}

#include <boost/graph/graphviz.hpp>
#include <boost/optional.hpp>
#include <fstream>
#include <iostream>
#include <functional>
#define mem_fun_ref mem_fn
#include <ppl.hh>

#include "automaton.hh"

namespace boost {
  enum vertex_match_t {
    vertex_match
  };
  enum vertex_invariant_t {
    vertex_invariant
  };
  enum vertex_flow_t {
    vertex_flow
  };
  enum vertex_init_zone_t {
    vertex_init_zone
  };
  enum edge_guard_t {
    edge_guard
  };
  enum edge_update_vars_t {
    edge_update_vars
  };
  enum edge_update_zone_t {
    edge_update_zone
  };
  enum graph_dimension_t {
    graph_dimension
  };

  BOOST_INSTALL_PROPERTY(graph, dimension);
  BOOST_INSTALL_PROPERTY(vertex, match);
  BOOST_INSTALL_PROPERTY(vertex, invariant);
  BOOST_INSTALL_PROPERTY(vertex, flow);
  BOOST_INSTALL_PROPERTY(vertex, init_zone);
  BOOST_INSTALL_PROPERTY(edge, guard);
  BOOST_INSTALL_PROPERTY(edge, update_vars);
  BOOST_INSTALL_PROPERTY(edge, update_zone);
}

template<typename Zone, typename Variables>
struct BoostHATransition {
  Zone guard;
  Variables updatedVars;
  Zone updatedZone;
};

template<typename Zone, typename Variables>
using BoostHybridAutomaton =
  boost::adjacency_list< boost::listS, boost::vecS, boost::directedS,
                         AutomatonState<Zone, Variables>, 
                         BoostHATransition<Zone, Variables>,
                         boost::property<boost::graph_dimension_t, std::size_t>>;

template<typename Zone, typename Variables>
static inline
void parseBoostHA(std::istream &file,
                  BoostHybridAutomaton<Zone, Variables> &BoostHA) {

  boost::dynamic_properties dp(boost::ignore_other_properties);

  boost::ref_property_map<BoostHybridAutomaton<Zone, Variables> *, std::size_t> 
    gdimension(get_property(BoostHA, boost::graph_dimension));
  dp.property("dimension", gdimension);

  dp.property("match", boost::get(&AutomatonState<Zone, Variables>::isMatch, BoostHA));
  dp.property("invariant", boost::get(&AutomatonState<Zone, Variables>::invariant, BoostHA));
  dp.property("flow", boost::get(&AutomatonState<Zone, Variables>::flow, BoostHA));
  dp.property("init_zone", boost::get(&AutomatonState<Zone, Variables>::initZone, BoostHA));
  dp.property("guard",
              boost::get(&BoostHATransition<Zone, Variables>::guard, BoostHA));
  dp.property("updated_vars",
              boost::get(&BoostHATransition<Zone, Variables>::updatedVars, BoostHA));
  dp.property("updated_zone",
              boost::get(&BoostHATransition<Zone, Variables>::updatedZone, BoostHA));

  boost::read_graphviz(file, BoostHA, dp, "id");
}

template<typename Zone>
static inline
void convBoostHA(const BoostHybridAutomaton<Parma_Polyhedra_Library::Constraint_System, Parma_Polyhedra_Library::Variables_Set> &BoostHA,
                 HybridAutomaton<Zone, Parma_Polyhedra_Library::Variables_Set> &HA) {
  HA.dimension = boost::get_property(BoostHA, boost::graph_dimension);
  HA.states.clear();

  using BoostZone = Parma_Polyhedra_Library::Constraint_System;
  using Variables = Parma_Polyhedra_Library::Variables_Set;

  const auto timingVar = Parma_Polyhedra_Library::Variable(HA.dimension);

  auto vertex_range = boost::vertices(BoostHA);
  std::unordered_map<typename BoostHybridAutomaton<BoostZone, Variables>::vertex_descriptor, std::shared_ptr<AutomatonState<Zone, Variables>>> stateConvMap;
  for (auto first = vertex_range.first, last = vertex_range.second; first != last; ++first) {
    typename BoostHybridAutomaton<BoostZone, Variables>::vertex_descriptor v = *first;
    stateConvMap[v] = std::make_shared<AutomatonState<Zone, Variables>>();
    stateConvMap[v]->isMatch = boost::get(&AutomatonState<BoostZone, Variables>::isMatch, BoostHA, v);
    stateConvMap[v]->invariant = Zone(HA.dimension + 1);
    stateConvMap[v]->invariant.add_constraints(boost::get(&AutomatonState<BoostZone, Variables>::invariant, BoostHA, v));
    stateConvMap[v]->flow = Zone(HA.dimension + 1);
    stateConvMap[v]->flow.add_constraints(boost::get(&AutomatonState<BoostZone, Variables>::flow, BoostHA, v));
    stateConvMap[v]->flow.add_constraint(timingVar == 1);
    stateConvMap[v]->initZone = Zone(HA.dimension + 1);
    stateConvMap[v]->initZone.add_constraints(boost::get(&AutomatonState<BoostZone, Variables>::initZone, BoostHA, v));
    stateConvMap[v]->initZone.add_constraint(timingVar >= 0);

    HA.states.emplace_back(stateConvMap[v]);
  }

  for (auto first = vertex_range.first, last = vertex_range.second; first != last; ++first) {
    auto edge_range = boost::out_edges(*first, BoostHA);
    for (auto firstEdge = edge_range.first, lastEdge = edge_range.second; firstEdge != lastEdge; ++firstEdge) {
      AutomatonTransition<Zone, Variables> transition;
      transition.target = stateConvMap[boost::target(*firstEdge, BoostHA)];//.get();

      transition.guard = Zone(HA.dimension + 1);
      transition.guard.add_constraints(boost::get(&BoostHATransition<BoostZone, Variables>::guard, BoostHA, *firstEdge));

      transition.updatedVars = boost::get(&BoostHATransition<BoostZone, Variables>::updatedVars, BoostHA, *firstEdge);

      transition.updatedZone = Zone(HA.dimension + 1);
      transition.updatedZone.add_constraints(boost::get(&BoostHATransition<BoostZone, Variables>::updatedZone, BoostHA, *firstEdge));
      
      stateConvMap[*first]->next.emplace_back(std::move(transition));
    }
  }
}
