#!/bin/sh -u

expect_success() {
    if ! eval "$*" > /dev/null 2>&1; then
        echo "The execution of \`\`$*'' failed while it is expected to succeed"
        exit 1
    fi
}

expect_failure() {
    if eval "$*" > /dev/null 2>&1; then
        echo "The execution of \`\`$*'' succeeded while it is expected to fail"
        exit 1
    fi
}

cd "$(dirname "$0")" || exit 1

for mode in powerset vector; do
   expect_success "echo '' | ../build/hamoni --$mode --box -f ./nnc.dot"
   expect_failure "echo '' | ../build/hamoni --$mode --bds -f ./nnc.dot"
   expect_failure "echo '' | ../build/hamoni --$mode --c_polyhedron -f ./nnc.dot"
   expect_success "echo '' | ../build/hamoni --$mode --polyhedron -f ./nnc.dot"
done

expect_success "../build/hamoni --vector --polyhedron -i ../example/ACCC/input.txt -f ../example/ACCC/adaptive_cruise_controller.dot | diff  ../example/ACCC/polyhedron.out -"
expect_success "../build/hamoni --vector --polyhedron -i ../example/ACCC/partial_input.txt -f ../example/ACCC/adaptive_cruise_controller.dot | diff  ../example/ACCC/polyhedron.out -"
expect_success "../build/hamoni --powerset --c_polyhedron -i ../example/simple_acc/simple_acc-20.input.txt -f ../example/simple_acc/simple_acc.dot | diff  ../example/simple_acc/simple_acc-20.output.txt -"
