Simple ACC
==========

This directory contains the simple adaptive cruise controller model. This model is a variant of the adaptive cruise controller model in [BRS19](https://easychair.org/publications/open/q6RV). In this model, the unsafe locations is reachable while it is unreachable in the original model.

![The simple ACC model](./figures/simple_acc.png)

The generated logs are uploaded [here](https://1drv.ws/u/s!AgmwSTftArYRjhnMJXLU17e0Vv6L?e=87rBMR).

Files
-----

- `simple_acc.dot`: the simple acc model
- `interpolation.input`: An example signal trace where an unsafe behavior can be detected thanks to the interpolation in HAMoni
- `extrapolation_safe.input`: An example signal trace where the safety is assured using extrapolation
- `extrapolation_unsafe.input`: An example signal trace where an unsafe behavior is detected thank to the extrapolation
- `Makefile`: a script to generate the (longer) inputs used in the experiment

Usage
-----

An example usage is as follows.

```sh
../../build/hamoni --vector --c_polyhedron -f ./simple_acc.dot < extrapolation_safe.input
```

Reference
---------

- [BRS19](https://easychair.org/publications/open/q6RV): Bu, Lei, Rajarshi Ray, and Stefan Schupp. "ARCH-COMP19 Category Report: Bounded Model Checking of Hybrid Systems with Piecewise Constant Dynamics." EPiC Series in Computing 61 (2019): 120-128.



