Shared Gas Model
================

This directory contains a shared gas burner benchmark taken from [Doyen+,FORMATS'05].

Files
-----

- `shared_gas_burner.dot`: The bounded model for the shared gas burner benchmark. The LHA is generated by the overapproximation in [Frehse,STTT'08].
- `raw_result.tsv`: The log generated by the Simulink model for the shared gas burner benchmark.
- `simulink/`: The directory containing the Simulink model.
- `simulink/shared_gas_burner.slx`: The Simulink model of the shared gas burner benchmark. The model is an affine hybrid automaton.
- `simulink/run.m`: A MATLAB script to run `shared_gas_burner.slx` to generate logs.

Usage
-----

An example usage is as follows.

```sh
make interval_500_ms_result.tsv
../../build/hamoni --vector --c_polyhedron -f ./shared_gas_burner_lha.dot < interval_500_ms_result.tsv
```

Reference
---------

- [Doyen+,FORMATS'05]: Doyen, Laurent, Thomas A. Henzinger, and Jean-François Raskin. "Automatic rectangular refinement of affine hybrid systems." International Conference on Formal Modeling and Analysis of Timed Systems. Springer, Berlin, Heidelberg, 2005.
- [Frehse,STTT'08]: Frehse, Goran. "PHAVer: algorithmic verification of hybrid systems past HyTech." International Journal on Software Tools for Technology Transfer 10.3 (2008): 263-279.

