%% Simulate Navigation
% Run the simulation and generate a tsv file containing a result of the simulation.
% All the configurations are hardcoded to the Simulink model

for i = 5:5
    % Run the simulation using the shared gas burner model in Fig. 1 of [Doyen+, FORMATS'05].
    x = rand;
    y = 3 - rand;
    vx = rand;
    if rand > 0.5
        vx = vx * -1;
    end
    vy = rand;
    if rand > 0.5
        vy = vy * -1;
    end
    
    result = sim('navigation', 'timeout', 10000);
    
    % Write the simulation result to the tsv file
    % format: x, y, vx, vy, t
    result_matrix = [result.yout.signals(2).values,...
        result.yout.signals(1).values,...
        result.tout];
    result_filename = sprintf('sample%d_raw_result.tsv', i);
    writematrix(result_matrix, result_filename, 'FileType', 'text', 'Delimiter', 'tab');
end