#!/usr/bin/env stack
-- stack runghc

import System.Environment (getArgs)
import Data.List (intercalate)

invariant 0 dimension = ""
invariant num dimension = invariant (num - 1) dimension ++ ", -10 * " ++ show dimension ++ " <= x" ++ show (num - 1) ++ ", x" ++ show (num - 1) ++ " <= 10 * " ++ show dimension

initZone0 0 = ""
initZone0 num = initZone0 (num - 1) ++ ", 0 <= x" ++ show (num - 1) ++ ", x" ++ show (num - 1) ++ " <= 1"

flow0 0 = ""
flow0 num = flow0 (num - 1) ++ ", " ++ show num ++ " - 1 <= x" ++ show (num - 1) ++ ", x" ++ show (num - 1) ++ " <= 2 * " ++ show num ++ " - 1"

flow1 0 = ""
flow1 num = flow1 (num - 1) ++ ", -" ++ show num ++ " <= x" ++ show (num - 1) ++ ", x" ++ show (num - 1) ++ " <= -" ++ show num ++ " + 1"

updatedVars01 dim = unwords $ map (\ i -> "x" ++ (show i)) [lb..dim-1]
  where
    lb = ceiling $ (fromIntegral dim) / 2

updatedVars10 dim = unwords $ map (\ i -> "x" ++ (show i)) [0..ub]
  where
    ub = (ceiling $ (fromIntegral dim) / 2) - 1

updatedZone01 dim = intercalate ", " $ map (\ i -> "-2 <= x" ++ (show i) ++ ", x" ++ (show i) ++ "<= -1") [lb..dim-1]
  where
    lb = ceiling $ (fromIntegral dim) / 2

updatedZone10 dim = intercalate ", " $ map (\ i -> "0 <= x" ++ (show i) ++ ", x" ++ (show i) ++ "<= 1") [0..ub]
  where
    ub = (ceiling $ (fromIntegral dim) / 2) - 1

main :: IO ()
main = do
  args <- getArgs
  if length args == 0 then
    putStrLn "Usage: ./genRP11.hs [DIMENSION]"
    else
      let dimension = (read $ head args :: Int) in
        if dimension < 1 then
          putStrLn "Error: dimension should be a positive integer."
        else 
          let header = "digraph RP11 {"
              loc0 = ["loc0 [match=1,", 
                      "invariant=\"{" ++ tail (invariant dimension dimension) ++ "};\",",
                      "flow=\"{" ++ tail (flow0 dimension) ++ "};\",",
                      "init_zone=\"{" ++ tail (initZone0 dimension) ++ "};\"];"]
              loc1 = ["loc1 [match=0,", 
                      "invariant=\"{" ++ tail (invariant dimension dimension) ++ "};\",",
                      "flow=\"{" ++ tail (flow1 dimension) ++ "};\",",
                      "init_zone=\"{false};\"];"]
              edge01 = "loc0->loc1 [guard=\"{x" ++ (show (dimension - 1)) ++ ">= 5 * " ++ show dimension ++ "};\", updated_vars=\"{" ++ updatedVars01 dimension ++ "}\", updated_zone=\"{" ++ updatedZone01 dimension ++ "};\"];"
              edge10 = "loc1->loc0 [guard=\"{x" ++ (show (dimension - 1)) ++ "<= -8 * " ++ show dimension ++ "};\", updated_vars=\"{" ++ updatedVars10 dimension ++ "}\", updated_zone=\"{" ++ updatedZone10 dimension ++ "};\"];"
              dimLine = "    graph [dimension = " ++ show dimension ++ "];"
              loc_edge_separator = "//TRANSITIONS"
              footer = "}" in
            putStrLn $ unlines $ [header, dimLine] ++ loc0 ++ loc1 ++ [loc_edge_separator, edge01, edge10, footer]
