Adaptive Cruise Controller (ACCC)
=================================

This directory contains the adaptive cruise controller used in [BRS19](https://easychair.org/publications/open/q6RV).

Files
-----

- `adaptive_cruise_controller.dot`: The controlled plant model
- `input.txt`: An example execution trace of this adaptive cruise controller.

More input traces are available [here](https://1drv.ws/u/s!AgmwSTftArYRjhebP5rHAFhudzWz?e=EurAWE).

Usage
-----

An example usage is as follows. You can also use other input traces from [here](https://1drv.ws/u/s!AgmwSTftArYRjhebP5rHAFhudzWz?e=EurAWE).

```sh
../../build/hamoni --vector --c_polyhedron -f ./adaptive_cruise_controller.dot < ./input.txt
```

Reference
---------

- [BRS19](https://easychair.org/publications/open/q6RV): Bu, Lei, Rajarshi Ray, and Stefan Schupp. "ARCH-COMP19 Category Report: Bounded Model Checking of Hybrid Systems with Piecewise Constant Dynamics." EPiC Series in Computing 61 (2019): 120-128.
