HAMoni --- Hybrid Automata MONItor
==========================

[![Actions Status](https://github.com/ERATOMMSD/parametric_HA_monitor/workflows/Boost.Test/badge.svg)](https://github.com/ERATOMMSD/parametric_HA_monitor/actions)
[![Actions Status](https://github.com/ERATOMMSD/parametric_HA_monitor/workflows/integrated_test/badge.svg)](https://github.com/ERATOMMSD/parametric_HA_monitor/actions)


This is the source code repository for HAMoni --- A tool for monitoring over a specification in hybrid automaton.

Usage
-----

### Synopsis

    hamoni [OPTIONS] -f [AUTOMATON_FILE] (-i [LOG_FILE])

### Options

**-h**, **--help** Print a help message. <br />
**-i** *file*, **--input** *file* Read the log from *file*. <br />
**-f** *file*, **--automaton** *file* Read the hybrid automaton from *file*. <br />
**--box** Use box for the symbolic computation. <br />
**--bds** Use bounded difference shapes for the symbolic computation. <br />
**--c_polyhedron** Use closed convex polyhedra for the symbolic computation. <br />
**--polyhedron** Use convex polyhedra for the symbolic computation.

Example
-------
    
    ./build/hamoni --c_polyhedra -f ./example/simple_acc/simple_acc.dot < ./example/simple_acc/simple_acc-20.input.txt
    ./build/hamoni --polyhedra -f ./example/simple_acc/simple_acc.dot < ./example/simple_acc/simple_acc-20.input.txt


Installation
------------

HAMoni is tested on macOS 10.15.4

### Requirements

* C++ compiler supporting C++17 and the corresponding libraries.
* Boost (>= 1.67.0)
* CMake
* Parma Polyhedra Library

### Instructions

```sh
mkdir build 
cd build && cmake -DCMAKE_BUILD_TYPE=Release .. && make
```

How to make compile_commands.json
---------------------------------

``` shell
mkdir build
cd build && cmake -DCMAKE_EXPORT_COMPILE_COMMANDS=ON ..
```

<!-- References -->
<!-- ---------- -->

<!-- We have no publication yet :-( -->

<!-- - [Masaki Waga](http://group-mmm.org/~mwaga/), [Étienne André](https://lipn.univ-paris13.fr/~andre/), and [Ichiro Hasuo](http://group-mmm.org/~ichiro/), **Symbolic Monitoring against Specifications Parametric in Time and Data**, To appear in *Proc. [CAV 2019](http://i-cav.org/2019/)*. -->
