#!/usr/bin/python
# coding=utf8

############################################################
# word2phaver
#
# Version 0.1
# Author       : Étienne André
# Created      : 2020/01/21
# Last modified: 2020/01/22
############################################################

import sys
import datetime

############################################################
# CONSTANTS
############################################################

script_name = "word2PHAVerLITE"

location_prefix = "word_"

variable_prefix = "x"

# For interfacing with the generated model
SPECIAL_COMMENT = "-- HERE COMES THE WORD"


############################################################
# FUNCTIONS
############################################################

  
# Return the variable name corresponding to an index
#def make_variable(i):
    #return variable_prefix + i
  
## We double all numbers using map() 
#numbers = (1, 2, 3, 4) 
#result = map(addition, numbers) 
#print(list(result)) 



############################################################
# MAIN
############################################################

if len(sys.argv) <> 3:
	raise Exception("Syntax: " + str(sys.argv[0]) + ' [word file] [model file]')

word_file_name = sys.argv[1]
model_file_name = sys.argv[2]
converted_model_file_name = model_file_name + "-withword.pha"
property_file_name = model_file_name + "-withword.cfg"

print "############################################################"
print "Hello, this is " + script_name + "!"
print "############################################################"

#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-
# Generating word automaton
#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-

print "Considering input word " + word_file_name + "…"

# Location index
location = 0

automaton = ""

# Header
automaton += "\n" + "------------------------------------------------------------"
automaton += "\n" + "automaton word"
automaton += "\n" + "-- automatically generated by " + script_name + " from word '" + word_file_name + "' on " + datetime.datetime.now().strftime("%Y/%m/%d %H:%M:%S")
automaton += "\n" + "------------------------------------------------------------"

# Need to read the first line to get the dimension, i.e., number of variables
with open(word_file_name, 'r') as word:
	first_line = word.readline()
	
	# Get dimension: nb of values, minus 1 for the timestamp
	values = first_line.split()
	dimension = len(values) - 1
	
	#Example: {{{ contr_var: t, ltlast; }}}
	automaton += "\n" + "contr_var: t, tlast; -- t measures the absolute time, tlast measures the time since the last sample"
	#Example: {{{ contr_var: x0, x1, x2, x3, x4; }}}
	automaton += "\n" + "input_var: " + (", ".join([variable_prefix + str(n) for n in range(dimension)])) + ";"


	# Sync labs
	automaton += "\n" + "synclabs: sample;"
	

with open(word_file_name, 'r') as word:

	for sample in word:
		values = sample.split()
		# Get dimension: nb of values, minus 1 for the timestamp
		dimension = len(values) - 1
		
		# Timestamp
		timestamp = values[dimension]
		
		# Variable values: all but the last dimension
		del values[-1]
		
		# Location name
		automaton += "\n" + "\nloc " + location_prefix + str(location) + ": "
		
		# Invariant
		automaton += "\n" + "\twhile t <= " + str(timestamp) + " wait {t' == 1 & tlast' == 1};"
		
		# Guard
		fix_values = " & ".join([variable_prefix + str(index) + " == " + str(value) for index,value in enumerate(values)])
		automaton += "\n" + "\twhen t == " + str(timestamp) + " & " + fix_values + " sync sample do {t' == t & tlast' == 0} goto " + location_prefix + str(location + 1) + ";"
		
		# Increase the location index
		location += 1

# Last location:
# Location name
automaton += "\n" + "\nloc " + location_prefix + str(location) + ": "
# Invariant
automaton += "\n" + "\twhile true wait {t' == 1 & tlast' == 1};"

# Initially
automaton += "\n" + "\ninitially: " + location_prefix + str(0) + " & t == 0 & tlast == 0;"

# Footer
automaton += "\n" + "\nend -- automaton word"

# Print
#print automaton


#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-
# Writing word automaton
#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-
with open(model_file_name, 'r') as model:
	with open(converted_model_file_name, 'w') as output_file:
		
		print "Writing to file '" + converted_model_file_name + "'…"
		
		for line in model:
			# Write the line in any case
			output_file.write(line)

			# Look for special delimiter
			if SPECIAL_COMMENT in line:
				#print line
				# Write the content of the log
				output_file.write(automaton)


##-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-
## Writing property ("configuration file")
##-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-

#configuration_content = "forbidden = system.{ $~" + str(location) + "& true };"

#configuration_content += """
#echo "";
#echo "Computing reachable states:";

#reach = system.reachable;

#res = reach;
#res.intersection_assign(forbidden);

#echo "";
#echo "Reachable forbidden states empty?";
#res.is_empty;
#echo "";

#echo "";
#echo "Reachable forbidden states:";
#res.print;
#echo "";
#"""

## Write the property/configuration to file
#with open(property_file_name, 'w') as property_file:	
	#print "Writing to file '" + property_file_name + "'…"
	#property_file.write(configuration_content)


#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-
# Bye bye!
#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-

print script_name + " successfully terminated."

sys.exit(0)
