#!/bin/sh

############################################################
# run translation from dot + log to PHAVerLite
#
# Version 0.1
# Author       : Étienne André
# Created      : 2020/01/21
# Last modified: 2020/01/22
############################################################


# Checking the number of arguments
if [ "$#" -ne 2 ]; then
	echo "Invalid call syntax. Syntax: $0 [model] [log]" >&2
	exit 1
fi

# Get file names
model=$1
log=$2

# Run
cd "$(dirname "$0")" || exit 1

./graph2mc/Graph2MC.byte "$1" \
&& echo "------------------------------------------------------------" \
&& python2 ./word2phaver/word2phaver.py "$2" "$1-converted.pha" \
&& echo "------------------------------------------------------------" \
&& echo "Now running: './phaverlite-0.2.1_static $1-converted.pha-withword.pha $1-converted.cfg'…" \
&& echo "------------------------------------------------------------" \
&& ./phaverlite-0.2.1_static "$1-converted.pha-withword.pha" "$1-converted.cfg"
