(*****************************************************************
 *
 *                       Graph2MC
 *
 * Université de Lorraine, CNRS, Inria, LORIA, Nancy, France
 *
 * File contributors : Étienne André
 * Created           : 2020/01/20
 * Last modified     : 2020/01/20
 *
 ****************************************************************)


(****************************************************************)
(** Names *)
(****************************************************************)

type automaton_name	= string
type location_name	= string
type variable_name	= string


(****************************************************************)
(** Operators *)
(****************************************************************)

(** Boolean operators *)

type parsed_relop = PARSED_OP_L | PARSED_OP_LEQ | PARSED_OP_EQ | PARSED_OP_GEQ | PARSED_OP_G



(****************************************************************)
(** Inequalities *)
(****************************************************************)



(** Linear expressions *)

type parsed_linear_term =
	| Parsed_integer of int
	| Parsed_variable of int * variable_name


type parsed_linear_expression =
	| Parsed_linear_term of parsed_linear_term
	| Parsed_linear_plus_expression of parsed_linear_expression * parsed_linear_term
	| Parsed_linear_minus_expression of parsed_linear_expression * parsed_linear_term


type parsed_inequality = parsed_linear_expression * parsed_relop * parsed_linear_expression


type parsed_inequalities = parsed_inequality list

(****************************************************************)
(** Zones *)
(****************************************************************)

type parsed_zone =
	| Parsed_inequalities of parsed_inequalities
	| Parsed_false_zone
	| Parsed_true_zone


(****************************************************************)
(** Automata *)
(****************************************************************)


type parsed_location = {
	(* Name *)
	name        : location_name;
	(* Accepting or not? *)
	accepting    : bool;
	(* Invariant *)
	invariant   : parsed_zone;
	(* Flow *)
	flow        : parsed_zone;
	(* Init zone *)
	init_zone   : parsed_zone;
}

type parsed_transition = {
	(* Source location *)
	source       : location_name;
	(* Target location *)
	target       : location_name;
	(* Guard *)
	guard        : parsed_zone;
	(* Updated vars *)
	updated_vars : variable_name list;
	(* Updated zone *)
	updated_zone : parsed_zone;
}


(****************************************************************)
(** Input graph *)
(****************************************************************)

type parsed_graph = {
	name			: automaton_name;
	nb_dimensions	: int;
	locations		: parsed_location list;
	transitions		: parsed_transition list;
}
