(************************************************************
 *
 *                       Graph2MC
 *
 * Université de Lorraine, CNRS, Inria, LORIA, Nancy, France
 *
 * Module description: Useful OCaml functions
 *
 * File contributors : Étienne André
 * Created           : 2020/01/20
 * Last modified     : 2020/01/23
 *
 ************************************************************)

 

(************************************************************)
(** Useful functions on lists *)
(************************************************************)

(** list_of_interval a b Create a fresh new list filled with elements [a, a+1, ..., b-1, b] *)
val list_of_interval : int -> int -> int list

(** Difference of 2 lists *)
val list_diff : 'a list	 -> 'a list-> 'a list


(************************************************************)
(** Useful functions on string *)
(************************************************************)

(* Convert an array of string into a string with separators *)
val string_of_array_of_string_with_sep : string -> string array -> string

(** Convert a list of string into a string with separators (uses an internal conversion to array) *)
val string_of_list_of_string_with_sep : string -> string list -> string


(************************************************************)
(** Date functions *)
(************************************************************)

(** Print the current date and time under the form of a string *)
val now : unit -> string



(**************************************************)
(** System functions *)
(**************************************************)

(** `write_to_file file_name file_content` will create a file `file_name` with content `file_content` *)
val write_to_file : string -> string -> unit



(************************************************************)
(* General useful functions *)
(************************************************************)

val program_name : string

val print_error : string -> unit

val print_message : string -> unit

(* Abort program *)
val abort_program : unit -> unit


(* Terminate program *)
val terminate_program : unit -> unit



	
(************************************************************)
(** Parse into a parsing structure *)
(************************************************************)
val parse_graph : string -> ParsingStructure.parsed_graph
