(************************************************************
 *
 *                       Graph2MC
 *
 * Université de Lorraine, CNRS, Inria, LORIA, Nancy, France
 *
 * Module description: Main file
 *
 * File contributors : Étienne André
 * Created           : 2020/01/20
 * Last modified     : 2020/01/22
 *
 ************************************************************)



(************************************************************)
(************************************************************)
(* Internal modules *)
(************************************************************)
(************************************************************)

open Exceptions
open ParsingStructure
open OCamlUtilities







(************************************************************)
(************************************************************)
(* STARTING PROGRAM *)
(************************************************************)
(************************************************************)
;;

print_message ("************************************************************");
print_message ("* " ^ program_name);
print_message ("************************************************************");
print_message ("Hello…! This is " ^ program_name);
print_newline();

(************************************************************)
(* Parse input graph *)
(************************************************************)

(* Get file name *)

if (Array.length Sys.argv) <> 2 then(
	print_error ("Syntax: " ^ program_name ^ " file_name");
	abort_program()
);

let file_name = Sys.argv.(1) in
let output_model_file_name = file_name ^ "-converted.pha" in
let output_property_file_name = file_name ^ "-converted.cfg" in

print_message ("Opening file " ^ file_name ^ "…");


(* Parse *)
let parsed_graph = parse_graph file_name in


(************************************************************)
(* Convert the model *)
(************************************************************)

let converted_graph = PhaverLITEPrinter.string_of_graph parsed_graph in

(* print_message converted_graph; *)

(* Write to file *)
write_to_file output_model_file_name converted_graph;

print_message ("Converted model successfully written to " ^ output_model_file_name);


(************************************************************)
(* Convert the property *)
(************************************************************)

let converted_property = PhaverLITEPrinter.string_of_property parsed_graph in

(* print_message converted_property; *)

(* Write to file *)
write_to_file output_property_file_name converted_property;

print_message ("Converted property successfully written to " ^ output_property_file_name);

(************************************************************)
(* Bye bye! *)
(************************************************************)

terminate_program()
