# The Open Khipu Repository

This open-source digital repository stores the most up-to-date data and metadata on extant Inka-style khipus from archaeological sites in the Andes, as well as museums around the world. Inka khipus were unique pre-Columbian, Andean recording devices that used three-dimensional signs -- primarily knots, cords, and colors -- as symbols functionally akin to those of early writing systems in other cultures. Spanish chronicles, as well as contemporary khipu studies indicate that the Inka used khipus to record everything from accounting records to historical narratives. The khipu recording system remains undeciphered, however. The purpose of this repository is to enable computational khipu research and Inka khipu decipherment efforts. 

Currently, data is stored in a serverless SQLite relational database (khipu.db) that contains all known khipu data recorded and published by major Inka khipu scholars: Robert and Marcia Ascher, Hugo Pereyra, Harvard's Khipu Database Project (Carrie Brezine and Gary Urton), and Jon Clindaniel.

This repository is currently being developed and maintained as a part of the Open Khipu Research Laboratory under the direction of Jon Clindaniel (jclindaniel@uchicago.edu). The data in the repository will be updated as more khipus become available for study.
