/*
 * Copyright © 2017-2021 CESSDA ERIC (support@cessda.eu)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package eu.cessda.pasc.oci.exception;

/**
 * Exception for problems that prevent proper harvesting.
 *
 * @author moses AT doraventures DOT com
 */
public class HarvesterException extends Exception {

    private static final long serialVersionUID = -1848837478104997356L;

    /**
     * Constructs a new {@link HarvesterException} with the specified detail message.
     * The cause is not initialized, and may subsequently be initialized by a call to initCause.
     * @param message the detail message. The detail message is saved for later retrieval by the
     * {@link HarvesterException#getMessage} method.
     */
    public HarvesterException(String message) {
        super(message);
    }

    public HarvesterException(String message, Throwable cause) {
        super(message, cause);
    }

    public HarvesterException(Throwable cause) {
        super(cause);
    }
}
