function out = spec_gen_nd_flow
out{1} = @init;
out{2} = @fun_eval;
out{3} = @jacobian;
out{4} = @jacobianp;
out{5} = @hessians;
out{6} = @hessiansp;
out{7} = @der3;
out{8} = @der4;
out{9} = [];
out{10}= @y_plus_z;
out{11}= @y0_plus_z0;

% --------------------------------------------------------------------------
function dydt = fun_eval(t,kmrgd,a,alpha0,m,g,gamma0,n,nu0,k,zetam,zeta0)
dydt=[kmrgd(1)*(1-kmrgd(1)) - a*kmrgd(1)*kmrgd(4) - alpha0*kmrgd(1)*kmrgd(5),;
a*kmrgd(1)*kmrgd(4) + m*kmrgd(3)-g*kmrgd(2),;
alpha0*kmrgd(1)*kmrgd(5)-m*kmrgd(3)-gamma0*kmrgd(3),;
g*kmrgd(2)-n*a*kmrgd(1)*kmrgd(4)-zetam*kmrgd(4),;
k*gamma0*kmrgd(3)-nu0*alpha0*kmrgd(1)*kmrgd(5)-zeta0*kmrgd(5);];

% --------------------------------------------------------------------------
function [tspan,y0,options] = init
y0=[0,0,0,0,0];
options = odeset('Jacobian',handles(3),'JacobianP',handles(4),'Hessians',handles(5),'HessiansP',handles(6));
handles = feval(spec_gen_nd_flow);
tspan = [0 10];

% --------------------------------------------------------------------------
function jac = jacobian(t,kmrgd,a,alpha0,m,g,gamma0,n,nu0,k,zetam,zeta0)
jac=[ 1 - a*kmrgd(4) - alpha0*kmrgd(5) - 2*kmrgd(1) , 0 , 0 , -a*kmrgd(1) , -alpha0*kmrgd(1) ; a*kmrgd(4) , -g , m , a*kmrgd(1) , 0 ; alpha0*kmrgd(5) , 0 , - gamma0 - m , 0 , alpha0*kmrgd(1) ; -a*n*kmrgd(4) , g , 0 , - zetam - a*n*kmrgd(1) , 0 ; -alpha0*nu0*kmrgd(5) , 0 , gamma0*k , 0 , - zeta0 - alpha0*nu0*kmrgd(1) ];
% --------------------------------------------------------------------------
function jacp = jacobianp(t,kmrgd,a,alpha0,m,g,gamma0,n,nu0,k,zetam,zeta0)
jacp=[ -kmrgd(1)*kmrgd(4) , -kmrgd(1)*kmrgd(5) , 0 , 0 , 0 , 0 , 0 , 0 , 0 , 0 ; kmrgd(1)*kmrgd(4) , 0 , kmrgd(3) , -kmrgd(2) , 0 , 0 , 0 , 0 , 0 , 0 ; 0 , kmrgd(1)*kmrgd(5) , -kmrgd(3) , 0 , -kmrgd(3) , 0 , 0 , 0 , 0 , 0 ; -n*kmrgd(1)*kmrgd(4) , 0 , 0 , kmrgd(2) , 0 , -a*kmrgd(1)*kmrgd(4) , 0 , 0 , -kmrgd(4) , 0 ; 0 , -nu0*kmrgd(1)*kmrgd(5) , 0 , 0 , k*kmrgd(3) , 0 , -alpha0*kmrgd(1)*kmrgd(5) , gamma0*kmrgd(3) , 0 , -kmrgd(5) ];
% --------------------------------------------------------------------------
function hess = hessians(t,kmrgd,a,alpha0,m,g,gamma0,n,nu0,k,zetam,zeta0)
hess1=[ -2 , 0 , 0 , -a , -alpha0 ; 0 , 0 , 0 , a , 0 ; 0 , 0 , 0 , 0 , alpha0 ; 0 , 0 , 0 , -a*n , 0 ; 0 , 0 , 0 , 0 , -alpha0*nu0 ];
hess2=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
hess3=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
hess4=[ -a , 0 , 0 , 0 , 0 ; a , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; -a*n , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
hess5=[ -alpha0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; alpha0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; -alpha0*nu0 , 0 , 0 , 0 , 0 ];
hess(:,:,1) =hess1;
hess(:,:,2) =hess2;
hess(:,:,3) =hess3;
hess(:,:,4) =hess4;
hess(:,:,5) =hess5;
% --------------------------------------------------------------------------
function hessp = hessiansp(t,kmrgd,a,alpha0,m,g,gamma0,n,nu0,k,zetam,zeta0)
hessp1=[ -kmrgd(4) , 0 , 0 , -kmrgd(1) , 0 ; kmrgd(4) , 0 , 0 , kmrgd(1) , 0 ; 0 , 0 , 0 , 0 , 0 ; -n*kmrgd(4) , 0 , 0 , -n*kmrgd(1) , 0 ; 0 , 0 , 0 , 0 , 0 ];
hessp2=[ -kmrgd(5) , 0 , 0 , 0 , -kmrgd(1) ; 0 , 0 , 0 , 0 , 0 ; kmrgd(5) , 0 , 0 , 0 , kmrgd(1) ; 0 , 0 , 0 , 0 , 0 ; -nu0*kmrgd(5) , 0 , 0 , 0 , -nu0*kmrgd(1) ];
hessp3=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 1 , 0 , 0 ; 0 , 0 , -1 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
hessp4=[ 0 , 0 , 0 , 0 , 0 ; 0 , -1 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 1 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
hessp5=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , -1 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , k , 0 , 0 ];
hessp6=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; -a*kmrgd(4) , 0 , 0 , -a*kmrgd(1) , 0 ; 0 , 0 , 0 , 0 , 0 ];
hessp7=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; -alpha0*kmrgd(5) , 0 , 0 , 0 , -alpha0*kmrgd(1) ];
hessp8=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , gamma0 , 0 , 0 ];
hessp9=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , -1 , 0 ; 0 , 0 , 0 , 0 , 0 ];
hessp10=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , -1 ];
hessp(:,:,1) =hessp1;
hessp(:,:,2) =hessp2;
hessp(:,:,3) =hessp3;
hessp(:,:,4) =hessp4;
hessp(:,:,5) =hessp5;
hessp(:,:,6) =hessp6;
hessp(:,:,7) =hessp7;
hessp(:,:,8) =hessp8;
hessp(:,:,9) =hessp9;
hessp(:,:,10) =hessp10;
%---------------------------------------------------------------------------
function tens3  = der3(t,kmrgd,a,alpha0,m,g,gamma0,n,nu0,k,zetam,zeta0)
tens31=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens32=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens33=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens34=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens35=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens36=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens37=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens38=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens39=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens310=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens311=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens312=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens313=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens314=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens315=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens316=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens317=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens318=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens319=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens320=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens321=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens322=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens323=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens324=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens325=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens3(:,:,1,1) =tens31;
tens3(:,:,1,2) =tens32;
tens3(:,:,1,3) =tens33;
tens3(:,:,1,4) =tens34;
tens3(:,:,1,5) =tens35;
tens3(:,:,2,1) =tens36;
tens3(:,:,2,2) =tens37;
tens3(:,:,2,3) =tens38;
tens3(:,:,2,4) =tens39;
tens3(:,:,2,5) =tens310;
tens3(:,:,3,1) =tens311;
tens3(:,:,3,2) =tens312;
tens3(:,:,3,3) =tens313;
tens3(:,:,3,4) =tens314;
tens3(:,:,3,5) =tens315;
tens3(:,:,4,1) =tens316;
tens3(:,:,4,2) =tens317;
tens3(:,:,4,3) =tens318;
tens3(:,:,4,4) =tens319;
tens3(:,:,4,5) =tens320;
tens3(:,:,5,1) =tens321;
tens3(:,:,5,2) =tens322;
tens3(:,:,5,3) =tens323;
tens3(:,:,5,4) =tens324;
tens3(:,:,5,5) =tens325;
%---------------------------------------------------------------------------
function tens4  = der4(t,kmrgd,a,alpha0,m,g,gamma0,n,nu0,k,zetam,zeta0)
tens41=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens42=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens43=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens44=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens45=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens46=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens47=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens48=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens49=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens410=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens411=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens412=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens413=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens414=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens415=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens416=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens417=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens418=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens419=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens420=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens421=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens422=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens423=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens424=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens425=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens426=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens427=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens428=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens429=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens430=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens431=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens432=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens433=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens434=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens435=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens436=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens437=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens438=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens439=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens440=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens441=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens442=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens443=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens444=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens445=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens446=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens447=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens448=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens449=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens450=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens451=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens452=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens453=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens454=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens455=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens456=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens457=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens458=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens459=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens460=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens461=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens462=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens463=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens464=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens465=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens466=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens467=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens468=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens469=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens470=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens471=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens472=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens473=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens474=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens475=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens476=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens477=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens478=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens479=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens480=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens481=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens482=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens483=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens484=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens485=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens486=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens487=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens488=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens489=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens490=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens491=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens492=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens493=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens494=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens495=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens496=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens497=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens498=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens499=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens4100=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens4101=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens4102=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens4103=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens4104=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens4105=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens4106=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens4107=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens4108=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens4109=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens4110=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens4111=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens4112=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens4113=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens4114=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens4115=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens4116=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens4117=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens4118=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens4119=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens4120=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens4121=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens4122=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens4123=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens4124=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens4125=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens4(:,:,1,1,1) =tens41;
tens4(:,:,1,1,2) =tens42;
tens4(:,:,1,1,3) =tens43;
tens4(:,:,1,1,4) =tens44;
tens4(:,:,1,1,5) =tens45;
tens4(:,:,1,2,1) =tens46;
tens4(:,:,1,2,2) =tens47;
tens4(:,:,1,2,3) =tens48;
tens4(:,:,1,2,4) =tens49;
tens4(:,:,1,2,5) =tens410;
tens4(:,:,1,3,1) =tens411;
tens4(:,:,1,3,2) =tens412;
tens4(:,:,1,3,3) =tens413;
tens4(:,:,1,3,4) =tens414;
tens4(:,:,1,3,5) =tens415;
tens4(:,:,1,4,1) =tens416;
tens4(:,:,1,4,2) =tens417;
tens4(:,:,1,4,3) =tens418;
tens4(:,:,1,4,4) =tens419;
tens4(:,:,1,4,5) =tens420;
tens4(:,:,1,5,1) =tens421;
tens4(:,:,1,5,2) =tens422;
tens4(:,:,1,5,3) =tens423;
tens4(:,:,1,5,4) =tens424;
tens4(:,:,1,5,5) =tens425;
tens4(:,:,2,1,1) =tens426;
tens4(:,:,2,1,2) =tens427;
tens4(:,:,2,1,3) =tens428;
tens4(:,:,2,1,4) =tens429;
tens4(:,:,2,1,5) =tens430;
tens4(:,:,2,2,1) =tens431;
tens4(:,:,2,2,2) =tens432;
tens4(:,:,2,2,3) =tens433;
tens4(:,:,2,2,4) =tens434;
tens4(:,:,2,2,5) =tens435;
tens4(:,:,2,3,1) =tens436;
tens4(:,:,2,3,2) =tens437;
tens4(:,:,2,3,3) =tens438;
tens4(:,:,2,3,4) =tens439;
tens4(:,:,2,3,5) =tens440;
tens4(:,:,2,4,1) =tens441;
tens4(:,:,2,4,2) =tens442;
tens4(:,:,2,4,3) =tens443;
tens4(:,:,2,4,4) =tens444;
tens4(:,:,2,4,5) =tens445;
tens4(:,:,2,5,1) =tens446;
tens4(:,:,2,5,2) =tens447;
tens4(:,:,2,5,3) =tens448;
tens4(:,:,2,5,4) =tens449;
tens4(:,:,2,5,5) =tens450;
tens4(:,:,3,1,1) =tens451;
tens4(:,:,3,1,2) =tens452;
tens4(:,:,3,1,3) =tens453;
tens4(:,:,3,1,4) =tens454;
tens4(:,:,3,1,5) =tens455;
tens4(:,:,3,2,1) =tens456;
tens4(:,:,3,2,2) =tens457;
tens4(:,:,3,2,3) =tens458;
tens4(:,:,3,2,4) =tens459;
tens4(:,:,3,2,5) =tens460;
tens4(:,:,3,3,1) =tens461;
tens4(:,:,3,3,2) =tens462;
tens4(:,:,3,3,3) =tens463;
tens4(:,:,3,3,4) =tens464;
tens4(:,:,3,3,5) =tens465;
tens4(:,:,3,4,1) =tens466;
tens4(:,:,3,4,2) =tens467;
tens4(:,:,3,4,3) =tens468;
tens4(:,:,3,4,4) =tens469;
tens4(:,:,3,4,5) =tens470;
tens4(:,:,3,5,1) =tens471;
tens4(:,:,3,5,2) =tens472;
tens4(:,:,3,5,3) =tens473;
tens4(:,:,3,5,4) =tens474;
tens4(:,:,3,5,5) =tens475;
tens4(:,:,4,1,1) =tens476;
tens4(:,:,4,1,2) =tens477;
tens4(:,:,4,1,3) =tens478;
tens4(:,:,4,1,4) =tens479;
tens4(:,:,4,1,5) =tens480;
tens4(:,:,4,2,1) =tens481;
tens4(:,:,4,2,2) =tens482;
tens4(:,:,4,2,3) =tens483;
tens4(:,:,4,2,4) =tens484;
tens4(:,:,4,2,5) =tens485;
tens4(:,:,4,3,1) =tens486;
tens4(:,:,4,3,2) =tens487;
tens4(:,:,4,3,3) =tens488;
tens4(:,:,4,3,4) =tens489;
tens4(:,:,4,3,5) =tens490;
tens4(:,:,4,4,1) =tens491;
tens4(:,:,4,4,2) =tens492;
tens4(:,:,4,4,3) =tens493;
tens4(:,:,4,4,4) =tens494;
tens4(:,:,4,4,5) =tens495;
tens4(:,:,4,5,1) =tens496;
tens4(:,:,4,5,2) =tens497;
tens4(:,:,4,5,3) =tens498;
tens4(:,:,4,5,4) =tens499;
tens4(:,:,4,5,5) =tens4100;
tens4(:,:,5,1,1) =tens4101;
tens4(:,:,5,1,2) =tens4102;
tens4(:,:,5,1,3) =tens4103;
tens4(:,:,5,1,4) =tens4104;
tens4(:,:,5,1,5) =tens4105;
tens4(:,:,5,2,1) =tens4106;
tens4(:,:,5,2,2) =tens4107;
tens4(:,:,5,2,3) =tens4108;
tens4(:,:,5,2,4) =tens4109;
tens4(:,:,5,2,5) =tens4110;
tens4(:,:,5,3,1) =tens4111;
tens4(:,:,5,3,2) =tens4112;
tens4(:,:,5,3,3) =tens4113;
tens4(:,:,5,3,4) =tens4114;
tens4(:,:,5,3,5) =tens4115;
tens4(:,:,5,4,1) =tens4116;
tens4(:,:,5,4,2) =tens4117;
tens4(:,:,5,4,3) =tens4118;
tens4(:,:,5,4,4) =tens4119;
tens4(:,:,5,4,5) =tens4120;
tens4(:,:,5,5,1) =tens4121;
tens4(:,:,5,5,2) =tens4122;
tens4(:,:,5,5,3) =tens4123;
tens4(:,:,5,5,4) =tens4124;
tens4(:,:,5,5,5) =tens4125;
%---------------------------------------------------------------------------
function tens5  = der5(t,kmrgd,a,alpha0,m,g,gamma0,n,nu0,k,zetam,zeta0)
tens51=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens52=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens53=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens54=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens55=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens56=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens57=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens58=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens59=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens510=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens511=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens512=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens513=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens514=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens515=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens516=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens517=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens518=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens519=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens520=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens521=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens522=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens523=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens524=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens525=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens526=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens527=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens528=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens529=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens530=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens531=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens532=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens533=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens534=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens535=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens536=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens537=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens538=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens539=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens540=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens541=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens542=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens543=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens544=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens545=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens546=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens547=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens548=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens549=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens550=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens551=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens552=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens553=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens554=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens555=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens556=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens557=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens558=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens559=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens560=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens561=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens562=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens563=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens564=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens565=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens566=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens567=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens568=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens569=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens570=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens571=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens572=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens573=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens574=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens575=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens576=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens577=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens578=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens579=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens580=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens581=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens582=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens583=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens584=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens585=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens586=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens587=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens588=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens589=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens590=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens591=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens592=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens593=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens594=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens595=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens596=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens597=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens598=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens599=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5100=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5101=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5102=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5103=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5104=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5105=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5106=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5107=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5108=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5109=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5110=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5111=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5112=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5113=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5114=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5115=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5116=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5117=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5118=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5119=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5120=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5121=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5122=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5123=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5124=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5125=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5126=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5127=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5128=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5129=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5130=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5131=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5132=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5133=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5134=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5135=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5136=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5137=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5138=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5139=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5140=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5141=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5142=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5143=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5144=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5145=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5146=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5147=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5148=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5149=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5150=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5151=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5152=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5153=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5154=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5155=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5156=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5157=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5158=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5159=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5160=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5161=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5162=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5163=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5164=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5165=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5166=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5167=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5168=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5169=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5170=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5171=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5172=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5173=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5174=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5175=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5176=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5177=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5178=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5179=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5180=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5181=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5182=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5183=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5184=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5185=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5186=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5187=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5188=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5189=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5190=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5191=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5192=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5193=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5194=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5195=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5196=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5197=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5198=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5199=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5200=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5201=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5202=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5203=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5204=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5205=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5206=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5207=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5208=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5209=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5210=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5211=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5212=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5213=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5214=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5215=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5216=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5217=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5218=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5219=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5220=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5221=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5222=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5223=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5224=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5225=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5226=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5227=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5228=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5229=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5230=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5231=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5232=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5233=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5234=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5235=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5236=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5237=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5238=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5239=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5240=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5241=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5242=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5243=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5244=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5245=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5246=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5247=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5248=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5249=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5250=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5251=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5252=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5253=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5254=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5255=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5256=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5257=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5258=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5259=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5260=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5261=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5262=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5263=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5264=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5265=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5266=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5267=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5268=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5269=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5270=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5271=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5272=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5273=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5274=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5275=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5276=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5277=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5278=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5279=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5280=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5281=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5282=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5283=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5284=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5285=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5286=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5287=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5288=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5289=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5290=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5291=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5292=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5293=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5294=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5295=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5296=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5297=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5298=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5299=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5300=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5301=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5302=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5303=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5304=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5305=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5306=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5307=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5308=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5309=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5310=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5311=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5312=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5313=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5314=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5315=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5316=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5317=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5318=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5319=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5320=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5321=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5322=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5323=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5324=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5325=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5326=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5327=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5328=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5329=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5330=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5331=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5332=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5333=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5334=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5335=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5336=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5337=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5338=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5339=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5340=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5341=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5342=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5343=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5344=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5345=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5346=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5347=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5348=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5349=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5350=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5351=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5352=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5353=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5354=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5355=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5356=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5357=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5358=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5359=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5360=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5361=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5362=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5363=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5364=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5365=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5366=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5367=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5368=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5369=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5370=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5371=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5372=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5373=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5374=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5375=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5376=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5377=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5378=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5379=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5380=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5381=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5382=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5383=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5384=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5385=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5386=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5387=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5388=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5389=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5390=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5391=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5392=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5393=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5394=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5395=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5396=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5397=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5398=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5399=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5400=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5401=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5402=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5403=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5404=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5405=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5406=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5407=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5408=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5409=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5410=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5411=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5412=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5413=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5414=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5415=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5416=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5417=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5418=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5419=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5420=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5421=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5422=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5423=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5424=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5425=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5426=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5427=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5428=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5429=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5430=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5431=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5432=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5433=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5434=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5435=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5436=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5437=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5438=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5439=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5440=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5441=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5442=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5443=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5444=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5445=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5446=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5447=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5448=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5449=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5450=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5451=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5452=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5453=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5454=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5455=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5456=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5457=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5458=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5459=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5460=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5461=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5462=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5463=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5464=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5465=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5466=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5467=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5468=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5469=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5470=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5471=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5472=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5473=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5474=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5475=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5476=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5477=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5478=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5479=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5480=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5481=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5482=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5483=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5484=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5485=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5486=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5487=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5488=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5489=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5490=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5491=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5492=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5493=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5494=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5495=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5496=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5497=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5498=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5499=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5500=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5501=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5502=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5503=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5504=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5505=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5506=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5507=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5508=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5509=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5510=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5511=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5512=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5513=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5514=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5515=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5516=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5517=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5518=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5519=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5520=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5521=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5522=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5523=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5524=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5525=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5526=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5527=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5528=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5529=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5530=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5531=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5532=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5533=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5534=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5535=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5536=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5537=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5538=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5539=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5540=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5541=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5542=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5543=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5544=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5545=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5546=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5547=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5548=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5549=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5550=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5551=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5552=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5553=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5554=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5555=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5556=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5557=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5558=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5559=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5560=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5561=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5562=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5563=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5564=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5565=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5566=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5567=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5568=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5569=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5570=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5571=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5572=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5573=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5574=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5575=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5576=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5577=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5578=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5579=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5580=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5581=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5582=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5583=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5584=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5585=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5586=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5587=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5588=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5589=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5590=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5591=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5592=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5593=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5594=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5595=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5596=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5597=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5598=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5599=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5600=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5601=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5602=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5603=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5604=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5605=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5606=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5607=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5608=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5609=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5610=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5611=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5612=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5613=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5614=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5615=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5616=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5617=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5618=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5619=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5620=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5621=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5622=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5623=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5624=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5625=[ 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ; 0 , 0 , 0 , 0 , 0 ];
tens5(:,:,1,1,1,1) =tens51;
tens5(:,:,1,1,1,2) =tens52;
tens5(:,:,1,1,1,3) =tens53;
tens5(:,:,1,1,1,4) =tens54;
tens5(:,:,1,1,1,5) =tens55;
tens5(:,:,1,1,2,1) =tens56;
tens5(:,:,1,1,2,2) =tens57;
tens5(:,:,1,1,2,3) =tens58;
tens5(:,:,1,1,2,4) =tens59;
tens5(:,:,1,1,2,5) =tens510;
tens5(:,:,1,1,3,1) =tens511;
tens5(:,:,1,1,3,2) =tens512;
tens5(:,:,1,1,3,3) =tens513;
tens5(:,:,1,1,3,4) =tens514;
tens5(:,:,1,1,3,5) =tens515;
tens5(:,:,1,1,4,1) =tens516;
tens5(:,:,1,1,4,2) =tens517;
tens5(:,:,1,1,4,3) =tens518;
tens5(:,:,1,1,4,4) =tens519;
tens5(:,:,1,1,4,5) =tens520;
tens5(:,:,1,1,5,1) =tens521;
tens5(:,:,1,1,5,2) =tens522;
tens5(:,:,1,1,5,3) =tens523;
tens5(:,:,1,1,5,4) =tens524;
tens5(:,:,1,1,5,5) =tens525;
tens5(:,:,1,2,1,1) =tens526;
tens5(:,:,1,2,1,2) =tens527;
tens5(:,:,1,2,1,3) =tens528;
tens5(:,:,1,2,1,4) =tens529;
tens5(:,:,1,2,1,5) =tens530;
tens5(:,:,1,2,2,1) =tens531;
tens5(:,:,1,2,2,2) =tens532;
tens5(:,:,1,2,2,3) =tens533;
tens5(:,:,1,2,2,4) =tens534;
tens5(:,:,1,2,2,5) =tens535;
tens5(:,:,1,2,3,1) =tens536;
tens5(:,:,1,2,3,2) =tens537;
tens5(:,:,1,2,3,3) =tens538;
tens5(:,:,1,2,3,4) =tens539;
tens5(:,:,1,2,3,5) =tens540;
tens5(:,:,1,2,4,1) =tens541;
tens5(:,:,1,2,4,2) =tens542;
tens5(:,:,1,2,4,3) =tens543;
tens5(:,:,1,2,4,4) =tens544;
tens5(:,:,1,2,4,5) =tens545;
tens5(:,:,1,2,5,1) =tens546;
tens5(:,:,1,2,5,2) =tens547;
tens5(:,:,1,2,5,3) =tens548;
tens5(:,:,1,2,5,4) =tens549;
tens5(:,:,1,2,5,5) =tens550;
tens5(:,:,1,3,1,1) =tens551;
tens5(:,:,1,3,1,2) =tens552;
tens5(:,:,1,3,1,3) =tens553;
tens5(:,:,1,3,1,4) =tens554;
tens5(:,:,1,3,1,5) =tens555;
tens5(:,:,1,3,2,1) =tens556;
tens5(:,:,1,3,2,2) =tens557;
tens5(:,:,1,3,2,3) =tens558;
tens5(:,:,1,3,2,4) =tens559;
tens5(:,:,1,3,2,5) =tens560;
tens5(:,:,1,3,3,1) =tens561;
tens5(:,:,1,3,3,2) =tens562;
tens5(:,:,1,3,3,3) =tens563;
tens5(:,:,1,3,3,4) =tens564;
tens5(:,:,1,3,3,5) =tens565;
tens5(:,:,1,3,4,1) =tens566;
tens5(:,:,1,3,4,2) =tens567;
tens5(:,:,1,3,4,3) =tens568;
tens5(:,:,1,3,4,4) =tens569;
tens5(:,:,1,3,4,5) =tens570;
tens5(:,:,1,3,5,1) =tens571;
tens5(:,:,1,3,5,2) =tens572;
tens5(:,:,1,3,5,3) =tens573;
tens5(:,:,1,3,5,4) =tens574;
tens5(:,:,1,3,5,5) =tens575;
tens5(:,:,1,4,1,1) =tens576;
tens5(:,:,1,4,1,2) =tens577;
tens5(:,:,1,4,1,3) =tens578;
tens5(:,:,1,4,1,4) =tens579;
tens5(:,:,1,4,1,5) =tens580;
tens5(:,:,1,4,2,1) =tens581;
tens5(:,:,1,4,2,2) =tens582;
tens5(:,:,1,4,2,3) =tens583;
tens5(:,:,1,4,2,4) =tens584;
tens5(:,:,1,4,2,5) =tens585;
tens5(:,:,1,4,3,1) =tens586;
tens5(:,:,1,4,3,2) =tens587;
tens5(:,:,1,4,3,3) =tens588;
tens5(:,:,1,4,3,4) =tens589;
tens5(:,:,1,4,3,5) =tens590;
tens5(:,:,1,4,4,1) =tens591;
tens5(:,:,1,4,4,2) =tens592;
tens5(:,:,1,4,4,3) =tens593;
tens5(:,:,1,4,4,4) =tens594;
tens5(:,:,1,4,4,5) =tens595;
tens5(:,:,1,4,5,1) =tens596;
tens5(:,:,1,4,5,2) =tens597;
tens5(:,:,1,4,5,3) =tens598;
tens5(:,:,1,4,5,4) =tens599;
tens5(:,:,1,4,5,5) =tens5100;
tens5(:,:,1,5,1,1) =tens5101;
tens5(:,:,1,5,1,2) =tens5102;
tens5(:,:,1,5,1,3) =tens5103;
tens5(:,:,1,5,1,4) =tens5104;
tens5(:,:,1,5,1,5) =tens5105;
tens5(:,:,1,5,2,1) =tens5106;
tens5(:,:,1,5,2,2) =tens5107;
tens5(:,:,1,5,2,3) =tens5108;
tens5(:,:,1,5,2,4) =tens5109;
tens5(:,:,1,5,2,5) =tens5110;
tens5(:,:,1,5,3,1) =tens5111;
tens5(:,:,1,5,3,2) =tens5112;
tens5(:,:,1,5,3,3) =tens5113;
tens5(:,:,1,5,3,4) =tens5114;
tens5(:,:,1,5,3,5) =tens5115;
tens5(:,:,1,5,4,1) =tens5116;
tens5(:,:,1,5,4,2) =tens5117;
tens5(:,:,1,5,4,3) =tens5118;
tens5(:,:,1,5,4,4) =tens5119;
tens5(:,:,1,5,4,5) =tens5120;
tens5(:,:,1,5,5,1) =tens5121;
tens5(:,:,1,5,5,2) =tens5122;
tens5(:,:,1,5,5,3) =tens5123;
tens5(:,:,1,5,5,4) =tens5124;
tens5(:,:,1,5,5,5) =tens5125;
tens5(:,:,2,1,1,1) =tens5126;
tens5(:,:,2,1,1,2) =tens5127;
tens5(:,:,2,1,1,3) =tens5128;
tens5(:,:,2,1,1,4) =tens5129;
tens5(:,:,2,1,1,5) =tens5130;
tens5(:,:,2,1,2,1) =tens5131;
tens5(:,:,2,1,2,2) =tens5132;
tens5(:,:,2,1,2,3) =tens5133;
tens5(:,:,2,1,2,4) =tens5134;
tens5(:,:,2,1,2,5) =tens5135;
tens5(:,:,2,1,3,1) =tens5136;
tens5(:,:,2,1,3,2) =tens5137;
tens5(:,:,2,1,3,3) =tens5138;
tens5(:,:,2,1,3,4) =tens5139;
tens5(:,:,2,1,3,5) =tens5140;
tens5(:,:,2,1,4,1) =tens5141;
tens5(:,:,2,1,4,2) =tens5142;
tens5(:,:,2,1,4,3) =tens5143;
tens5(:,:,2,1,4,4) =tens5144;
tens5(:,:,2,1,4,5) =tens5145;
tens5(:,:,2,1,5,1) =tens5146;
tens5(:,:,2,1,5,2) =tens5147;
tens5(:,:,2,1,5,3) =tens5148;
tens5(:,:,2,1,5,4) =tens5149;
tens5(:,:,2,1,5,5) =tens5150;
tens5(:,:,2,2,1,1) =tens5151;
tens5(:,:,2,2,1,2) =tens5152;
tens5(:,:,2,2,1,3) =tens5153;
tens5(:,:,2,2,1,4) =tens5154;
tens5(:,:,2,2,1,5) =tens5155;
tens5(:,:,2,2,2,1) =tens5156;
tens5(:,:,2,2,2,2) =tens5157;
tens5(:,:,2,2,2,3) =tens5158;
tens5(:,:,2,2,2,4) =tens5159;
tens5(:,:,2,2,2,5) =tens5160;
tens5(:,:,2,2,3,1) =tens5161;
tens5(:,:,2,2,3,2) =tens5162;
tens5(:,:,2,2,3,3) =tens5163;
tens5(:,:,2,2,3,4) =tens5164;
tens5(:,:,2,2,3,5) =tens5165;
tens5(:,:,2,2,4,1) =tens5166;
tens5(:,:,2,2,4,2) =tens5167;
tens5(:,:,2,2,4,3) =tens5168;
tens5(:,:,2,2,4,4) =tens5169;
tens5(:,:,2,2,4,5) =tens5170;
tens5(:,:,2,2,5,1) =tens5171;
tens5(:,:,2,2,5,2) =tens5172;
tens5(:,:,2,2,5,3) =tens5173;
tens5(:,:,2,2,5,4) =tens5174;
tens5(:,:,2,2,5,5) =tens5175;
tens5(:,:,2,3,1,1) =tens5176;
tens5(:,:,2,3,1,2) =tens5177;
tens5(:,:,2,3,1,3) =tens5178;
tens5(:,:,2,3,1,4) =tens5179;
tens5(:,:,2,3,1,5) =tens5180;
tens5(:,:,2,3,2,1) =tens5181;
tens5(:,:,2,3,2,2) =tens5182;
tens5(:,:,2,3,2,3) =tens5183;
tens5(:,:,2,3,2,4) =tens5184;
tens5(:,:,2,3,2,5) =tens5185;
tens5(:,:,2,3,3,1) =tens5186;
tens5(:,:,2,3,3,2) =tens5187;
tens5(:,:,2,3,3,3) =tens5188;
tens5(:,:,2,3,3,4) =tens5189;
tens5(:,:,2,3,3,5) =tens5190;
tens5(:,:,2,3,4,1) =tens5191;
tens5(:,:,2,3,4,2) =tens5192;
tens5(:,:,2,3,4,3) =tens5193;
tens5(:,:,2,3,4,4) =tens5194;
tens5(:,:,2,3,4,5) =tens5195;
tens5(:,:,2,3,5,1) =tens5196;
tens5(:,:,2,3,5,2) =tens5197;
tens5(:,:,2,3,5,3) =tens5198;
tens5(:,:,2,3,5,4) =tens5199;
tens5(:,:,2,3,5,5) =tens5200;
tens5(:,:,2,4,1,1) =tens5201;
tens5(:,:,2,4,1,2) =tens5202;
tens5(:,:,2,4,1,3) =tens5203;
tens5(:,:,2,4,1,4) =tens5204;
tens5(:,:,2,4,1,5) =tens5205;
tens5(:,:,2,4,2,1) =tens5206;
tens5(:,:,2,4,2,2) =tens5207;
tens5(:,:,2,4,2,3) =tens5208;
tens5(:,:,2,4,2,4) =tens5209;
tens5(:,:,2,4,2,5) =tens5210;
tens5(:,:,2,4,3,1) =tens5211;
tens5(:,:,2,4,3,2) =tens5212;
tens5(:,:,2,4,3,3) =tens5213;
tens5(:,:,2,4,3,4) =tens5214;
tens5(:,:,2,4,3,5) =tens5215;
tens5(:,:,2,4,4,1) =tens5216;
tens5(:,:,2,4,4,2) =tens5217;
tens5(:,:,2,4,4,3) =tens5218;
tens5(:,:,2,4,4,4) =tens5219;
tens5(:,:,2,4,4,5) =tens5220;
tens5(:,:,2,4,5,1) =tens5221;
tens5(:,:,2,4,5,2) =tens5222;
tens5(:,:,2,4,5,3) =tens5223;
tens5(:,:,2,4,5,4) =tens5224;
tens5(:,:,2,4,5,5) =tens5225;
tens5(:,:,2,5,1,1) =tens5226;
tens5(:,:,2,5,1,2) =tens5227;
tens5(:,:,2,5,1,3) =tens5228;
tens5(:,:,2,5,1,4) =tens5229;
tens5(:,:,2,5,1,5) =tens5230;
tens5(:,:,2,5,2,1) =tens5231;
tens5(:,:,2,5,2,2) =tens5232;
tens5(:,:,2,5,2,3) =tens5233;
tens5(:,:,2,5,2,4) =tens5234;
tens5(:,:,2,5,2,5) =tens5235;
tens5(:,:,2,5,3,1) =tens5236;
tens5(:,:,2,5,3,2) =tens5237;
tens5(:,:,2,5,3,3) =tens5238;
tens5(:,:,2,5,3,4) =tens5239;
tens5(:,:,2,5,3,5) =tens5240;
tens5(:,:,2,5,4,1) =tens5241;
tens5(:,:,2,5,4,2) =tens5242;
tens5(:,:,2,5,4,3) =tens5243;
tens5(:,:,2,5,4,4) =tens5244;
tens5(:,:,2,5,4,5) =tens5245;
tens5(:,:,2,5,5,1) =tens5246;
tens5(:,:,2,5,5,2) =tens5247;
tens5(:,:,2,5,5,3) =tens5248;
tens5(:,:,2,5,5,4) =tens5249;
tens5(:,:,2,5,5,5) =tens5250;
tens5(:,:,3,1,1,1) =tens5251;
tens5(:,:,3,1,1,2) =tens5252;
tens5(:,:,3,1,1,3) =tens5253;
tens5(:,:,3,1,1,4) =tens5254;
tens5(:,:,3,1,1,5) =tens5255;
tens5(:,:,3,1,2,1) =tens5256;
tens5(:,:,3,1,2,2) =tens5257;
tens5(:,:,3,1,2,3) =tens5258;
tens5(:,:,3,1,2,4) =tens5259;
tens5(:,:,3,1,2,5) =tens5260;
tens5(:,:,3,1,3,1) =tens5261;
tens5(:,:,3,1,3,2) =tens5262;
tens5(:,:,3,1,3,3) =tens5263;
tens5(:,:,3,1,3,4) =tens5264;
tens5(:,:,3,1,3,5) =tens5265;
tens5(:,:,3,1,4,1) =tens5266;
tens5(:,:,3,1,4,2) =tens5267;
tens5(:,:,3,1,4,3) =tens5268;
tens5(:,:,3,1,4,4) =tens5269;
tens5(:,:,3,1,4,5) =tens5270;
tens5(:,:,3,1,5,1) =tens5271;
tens5(:,:,3,1,5,2) =tens5272;
tens5(:,:,3,1,5,3) =tens5273;
tens5(:,:,3,1,5,4) =tens5274;
tens5(:,:,3,1,5,5) =tens5275;
tens5(:,:,3,2,1,1) =tens5276;
tens5(:,:,3,2,1,2) =tens5277;
tens5(:,:,3,2,1,3) =tens5278;
tens5(:,:,3,2,1,4) =tens5279;
tens5(:,:,3,2,1,5) =tens5280;
tens5(:,:,3,2,2,1) =tens5281;
tens5(:,:,3,2,2,2) =tens5282;
tens5(:,:,3,2,2,3) =tens5283;
tens5(:,:,3,2,2,4) =tens5284;
tens5(:,:,3,2,2,5) =tens5285;
tens5(:,:,3,2,3,1) =tens5286;
tens5(:,:,3,2,3,2) =tens5287;
tens5(:,:,3,2,3,3) =tens5288;
tens5(:,:,3,2,3,4) =tens5289;
tens5(:,:,3,2,3,5) =tens5290;
tens5(:,:,3,2,4,1) =tens5291;
tens5(:,:,3,2,4,2) =tens5292;
tens5(:,:,3,2,4,3) =tens5293;
tens5(:,:,3,2,4,4) =tens5294;
tens5(:,:,3,2,4,5) =tens5295;
tens5(:,:,3,2,5,1) =tens5296;
tens5(:,:,3,2,5,2) =tens5297;
tens5(:,:,3,2,5,3) =tens5298;
tens5(:,:,3,2,5,4) =tens5299;
tens5(:,:,3,2,5,5) =tens5300;
tens5(:,:,3,3,1,1) =tens5301;
tens5(:,:,3,3,1,2) =tens5302;
tens5(:,:,3,3,1,3) =tens5303;
tens5(:,:,3,3,1,4) =tens5304;
tens5(:,:,3,3,1,5) =tens5305;
tens5(:,:,3,3,2,1) =tens5306;
tens5(:,:,3,3,2,2) =tens5307;
tens5(:,:,3,3,2,3) =tens5308;
tens5(:,:,3,3,2,4) =tens5309;
tens5(:,:,3,3,2,5) =tens5310;
tens5(:,:,3,3,3,1) =tens5311;
tens5(:,:,3,3,3,2) =tens5312;
tens5(:,:,3,3,3,3) =tens5313;
tens5(:,:,3,3,3,4) =tens5314;
tens5(:,:,3,3,3,5) =tens5315;
tens5(:,:,3,3,4,1) =tens5316;
tens5(:,:,3,3,4,2) =tens5317;
tens5(:,:,3,3,4,3) =tens5318;
tens5(:,:,3,3,4,4) =tens5319;
tens5(:,:,3,3,4,5) =tens5320;
tens5(:,:,3,3,5,1) =tens5321;
tens5(:,:,3,3,5,2) =tens5322;
tens5(:,:,3,3,5,3) =tens5323;
tens5(:,:,3,3,5,4) =tens5324;
tens5(:,:,3,3,5,5) =tens5325;
tens5(:,:,3,4,1,1) =tens5326;
tens5(:,:,3,4,1,2) =tens5327;
tens5(:,:,3,4,1,3) =tens5328;
tens5(:,:,3,4,1,4) =tens5329;
tens5(:,:,3,4,1,5) =tens5330;
tens5(:,:,3,4,2,1) =tens5331;
tens5(:,:,3,4,2,2) =tens5332;
tens5(:,:,3,4,2,3) =tens5333;
tens5(:,:,3,4,2,4) =tens5334;
tens5(:,:,3,4,2,5) =tens5335;
tens5(:,:,3,4,3,1) =tens5336;
tens5(:,:,3,4,3,2) =tens5337;
tens5(:,:,3,4,3,3) =tens5338;
tens5(:,:,3,4,3,4) =tens5339;
tens5(:,:,3,4,3,5) =tens5340;
tens5(:,:,3,4,4,1) =tens5341;
tens5(:,:,3,4,4,2) =tens5342;
tens5(:,:,3,4,4,3) =tens5343;
tens5(:,:,3,4,4,4) =tens5344;
tens5(:,:,3,4,4,5) =tens5345;
tens5(:,:,3,4,5,1) =tens5346;
tens5(:,:,3,4,5,2) =tens5347;
tens5(:,:,3,4,5,3) =tens5348;
tens5(:,:,3,4,5,4) =tens5349;
tens5(:,:,3,4,5,5) =tens5350;
tens5(:,:,3,5,1,1) =tens5351;
tens5(:,:,3,5,1,2) =tens5352;
tens5(:,:,3,5,1,3) =tens5353;
tens5(:,:,3,5,1,4) =tens5354;
tens5(:,:,3,5,1,5) =tens5355;
tens5(:,:,3,5,2,1) =tens5356;
tens5(:,:,3,5,2,2) =tens5357;
tens5(:,:,3,5,2,3) =tens5358;
tens5(:,:,3,5,2,4) =tens5359;
tens5(:,:,3,5,2,5) =tens5360;
tens5(:,:,3,5,3,1) =tens5361;
tens5(:,:,3,5,3,2) =tens5362;
tens5(:,:,3,5,3,3) =tens5363;
tens5(:,:,3,5,3,4) =tens5364;
tens5(:,:,3,5,3,5) =tens5365;
tens5(:,:,3,5,4,1) =tens5366;
tens5(:,:,3,5,4,2) =tens5367;
tens5(:,:,3,5,4,3) =tens5368;
tens5(:,:,3,5,4,4) =tens5369;
tens5(:,:,3,5,4,5) =tens5370;
tens5(:,:,3,5,5,1) =tens5371;
tens5(:,:,3,5,5,2) =tens5372;
tens5(:,:,3,5,5,3) =tens5373;
tens5(:,:,3,5,5,4) =tens5374;
tens5(:,:,3,5,5,5) =tens5375;
tens5(:,:,4,1,1,1) =tens5376;
tens5(:,:,4,1,1,2) =tens5377;
tens5(:,:,4,1,1,3) =tens5378;
tens5(:,:,4,1,1,4) =tens5379;
tens5(:,:,4,1,1,5) =tens5380;
tens5(:,:,4,1,2,1) =tens5381;
tens5(:,:,4,1,2,2) =tens5382;
tens5(:,:,4,1,2,3) =tens5383;
tens5(:,:,4,1,2,4) =tens5384;
tens5(:,:,4,1,2,5) =tens5385;
tens5(:,:,4,1,3,1) =tens5386;
tens5(:,:,4,1,3,2) =tens5387;
tens5(:,:,4,1,3,3) =tens5388;
tens5(:,:,4,1,3,4) =tens5389;
tens5(:,:,4,1,3,5) =tens5390;
tens5(:,:,4,1,4,1) =tens5391;
tens5(:,:,4,1,4,2) =tens5392;
tens5(:,:,4,1,4,3) =tens5393;
tens5(:,:,4,1,4,4) =tens5394;
tens5(:,:,4,1,4,5) =tens5395;
tens5(:,:,4,1,5,1) =tens5396;
tens5(:,:,4,1,5,2) =tens5397;
tens5(:,:,4,1,5,3) =tens5398;
tens5(:,:,4,1,5,4) =tens5399;
tens5(:,:,4,1,5,5) =tens5400;
tens5(:,:,4,2,1,1) =tens5401;
tens5(:,:,4,2,1,2) =tens5402;
tens5(:,:,4,2,1,3) =tens5403;
tens5(:,:,4,2,1,4) =tens5404;
tens5(:,:,4,2,1,5) =tens5405;
tens5(:,:,4,2,2,1) =tens5406;
tens5(:,:,4,2,2,2) =tens5407;
tens5(:,:,4,2,2,3) =tens5408;
tens5(:,:,4,2,2,4) =tens5409;
tens5(:,:,4,2,2,5) =tens5410;
tens5(:,:,4,2,3,1) =tens5411;
tens5(:,:,4,2,3,2) =tens5412;
tens5(:,:,4,2,3,3) =tens5413;
tens5(:,:,4,2,3,4) =tens5414;
tens5(:,:,4,2,3,5) =tens5415;
tens5(:,:,4,2,4,1) =tens5416;
tens5(:,:,4,2,4,2) =tens5417;
tens5(:,:,4,2,4,3) =tens5418;
tens5(:,:,4,2,4,4) =tens5419;
tens5(:,:,4,2,4,5) =tens5420;
tens5(:,:,4,2,5,1) =tens5421;
tens5(:,:,4,2,5,2) =tens5422;
tens5(:,:,4,2,5,3) =tens5423;
tens5(:,:,4,2,5,4) =tens5424;
tens5(:,:,4,2,5,5) =tens5425;
tens5(:,:,4,3,1,1) =tens5426;
tens5(:,:,4,3,1,2) =tens5427;
tens5(:,:,4,3,1,3) =tens5428;
tens5(:,:,4,3,1,4) =tens5429;
tens5(:,:,4,3,1,5) =tens5430;
tens5(:,:,4,3,2,1) =tens5431;
tens5(:,:,4,3,2,2) =tens5432;
tens5(:,:,4,3,2,3) =tens5433;
tens5(:,:,4,3,2,4) =tens5434;
tens5(:,:,4,3,2,5) =tens5435;
tens5(:,:,4,3,3,1) =tens5436;
tens5(:,:,4,3,3,2) =tens5437;
tens5(:,:,4,3,3,3) =tens5438;
tens5(:,:,4,3,3,4) =tens5439;
tens5(:,:,4,3,3,5) =tens5440;
tens5(:,:,4,3,4,1) =tens5441;
tens5(:,:,4,3,4,2) =tens5442;
tens5(:,:,4,3,4,3) =tens5443;
tens5(:,:,4,3,4,4) =tens5444;
tens5(:,:,4,3,4,5) =tens5445;
tens5(:,:,4,3,5,1) =tens5446;
tens5(:,:,4,3,5,2) =tens5447;
tens5(:,:,4,3,5,3) =tens5448;
tens5(:,:,4,3,5,4) =tens5449;
tens5(:,:,4,3,5,5) =tens5450;
tens5(:,:,4,4,1,1) =tens5451;
tens5(:,:,4,4,1,2) =tens5452;
tens5(:,:,4,4,1,3) =tens5453;
tens5(:,:,4,4,1,4) =tens5454;
tens5(:,:,4,4,1,5) =tens5455;
tens5(:,:,4,4,2,1) =tens5456;
tens5(:,:,4,4,2,2) =tens5457;
tens5(:,:,4,4,2,3) =tens5458;
tens5(:,:,4,4,2,4) =tens5459;
tens5(:,:,4,4,2,5) =tens5460;
tens5(:,:,4,4,3,1) =tens5461;
tens5(:,:,4,4,3,2) =tens5462;
tens5(:,:,4,4,3,3) =tens5463;
tens5(:,:,4,4,3,4) =tens5464;
tens5(:,:,4,4,3,5) =tens5465;
tens5(:,:,4,4,4,1) =tens5466;
tens5(:,:,4,4,4,2) =tens5467;
tens5(:,:,4,4,4,3) =tens5468;
tens5(:,:,4,4,4,4) =tens5469;
tens5(:,:,4,4,4,5) =tens5470;
tens5(:,:,4,4,5,1) =tens5471;
tens5(:,:,4,4,5,2) =tens5472;
tens5(:,:,4,4,5,3) =tens5473;
tens5(:,:,4,4,5,4) =tens5474;
tens5(:,:,4,4,5,5) =tens5475;
tens5(:,:,4,5,1,1) =tens5476;
tens5(:,:,4,5,1,2) =tens5477;
tens5(:,:,4,5,1,3) =tens5478;
tens5(:,:,4,5,1,4) =tens5479;
tens5(:,:,4,5,1,5) =tens5480;
tens5(:,:,4,5,2,1) =tens5481;
tens5(:,:,4,5,2,2) =tens5482;
tens5(:,:,4,5,2,3) =tens5483;
tens5(:,:,4,5,2,4) =tens5484;
tens5(:,:,4,5,2,5) =tens5485;
tens5(:,:,4,5,3,1) =tens5486;
tens5(:,:,4,5,3,2) =tens5487;
tens5(:,:,4,5,3,3) =tens5488;
tens5(:,:,4,5,3,4) =tens5489;
tens5(:,:,4,5,3,5) =tens5490;
tens5(:,:,4,5,4,1) =tens5491;
tens5(:,:,4,5,4,2) =tens5492;
tens5(:,:,4,5,4,3) =tens5493;
tens5(:,:,4,5,4,4) =tens5494;
tens5(:,:,4,5,4,5) =tens5495;
tens5(:,:,4,5,5,1) =tens5496;
tens5(:,:,4,5,5,2) =tens5497;
tens5(:,:,4,5,5,3) =tens5498;
tens5(:,:,4,5,5,4) =tens5499;
tens5(:,:,4,5,5,5) =tens5500;
tens5(:,:,5,1,1,1) =tens5501;
tens5(:,:,5,1,1,2) =tens5502;
tens5(:,:,5,1,1,3) =tens5503;
tens5(:,:,5,1,1,4) =tens5504;
tens5(:,:,5,1,1,5) =tens5505;
tens5(:,:,5,1,2,1) =tens5506;
tens5(:,:,5,1,2,2) =tens5507;
tens5(:,:,5,1,2,3) =tens5508;
tens5(:,:,5,1,2,4) =tens5509;
tens5(:,:,5,1,2,5) =tens5510;
tens5(:,:,5,1,3,1) =tens5511;
tens5(:,:,5,1,3,2) =tens5512;
tens5(:,:,5,1,3,3) =tens5513;
tens5(:,:,5,1,3,4) =tens5514;
tens5(:,:,5,1,3,5) =tens5515;
tens5(:,:,5,1,4,1) =tens5516;
tens5(:,:,5,1,4,2) =tens5517;
tens5(:,:,5,1,4,3) =tens5518;
tens5(:,:,5,1,4,4) =tens5519;
tens5(:,:,5,1,4,5) =tens5520;
tens5(:,:,5,1,5,1) =tens5521;
tens5(:,:,5,1,5,2) =tens5522;
tens5(:,:,5,1,5,3) =tens5523;
tens5(:,:,5,1,5,4) =tens5524;
tens5(:,:,5,1,5,5) =tens5525;
tens5(:,:,5,2,1,1) =tens5526;
tens5(:,:,5,2,1,2) =tens5527;
tens5(:,:,5,2,1,3) =tens5528;
tens5(:,:,5,2,1,4) =tens5529;
tens5(:,:,5,2,1,5) =tens5530;
tens5(:,:,5,2,2,1) =tens5531;
tens5(:,:,5,2,2,2) =tens5532;
tens5(:,:,5,2,2,3) =tens5533;
tens5(:,:,5,2,2,4) =tens5534;
tens5(:,:,5,2,2,5) =tens5535;
tens5(:,:,5,2,3,1) =tens5536;
tens5(:,:,5,2,3,2) =tens5537;
tens5(:,:,5,2,3,3) =tens5538;
tens5(:,:,5,2,3,4) =tens5539;
tens5(:,:,5,2,3,5) =tens5540;
tens5(:,:,5,2,4,1) =tens5541;
tens5(:,:,5,2,4,2) =tens5542;
tens5(:,:,5,2,4,3) =tens5543;
tens5(:,:,5,2,4,4) =tens5544;
tens5(:,:,5,2,4,5) =tens5545;
tens5(:,:,5,2,5,1) =tens5546;
tens5(:,:,5,2,5,2) =tens5547;
tens5(:,:,5,2,5,3) =tens5548;
tens5(:,:,5,2,5,4) =tens5549;
tens5(:,:,5,2,5,5) =tens5550;
tens5(:,:,5,3,1,1) =tens5551;
tens5(:,:,5,3,1,2) =tens5552;
tens5(:,:,5,3,1,3) =tens5553;
tens5(:,:,5,3,1,4) =tens5554;
tens5(:,:,5,3,1,5) =tens5555;
tens5(:,:,5,3,2,1) =tens5556;
tens5(:,:,5,3,2,2) =tens5557;
tens5(:,:,5,3,2,3) =tens5558;
tens5(:,:,5,3,2,4) =tens5559;
tens5(:,:,5,3,2,5) =tens5560;
tens5(:,:,5,3,3,1) =tens5561;
tens5(:,:,5,3,3,2) =tens5562;
tens5(:,:,5,3,3,3) =tens5563;
tens5(:,:,5,3,3,4) =tens5564;
tens5(:,:,5,3,3,5) =tens5565;
tens5(:,:,5,3,4,1) =tens5566;
tens5(:,:,5,3,4,2) =tens5567;
tens5(:,:,5,3,4,3) =tens5568;
tens5(:,:,5,3,4,4) =tens5569;
tens5(:,:,5,3,4,5) =tens5570;
tens5(:,:,5,3,5,1) =tens5571;
tens5(:,:,5,3,5,2) =tens5572;
tens5(:,:,5,3,5,3) =tens5573;
tens5(:,:,5,3,5,4) =tens5574;
tens5(:,:,5,3,5,5) =tens5575;
tens5(:,:,5,4,1,1) =tens5576;
tens5(:,:,5,4,1,2) =tens5577;
tens5(:,:,5,4,1,3) =tens5578;
tens5(:,:,5,4,1,4) =tens5579;
tens5(:,:,5,4,1,5) =tens5580;
tens5(:,:,5,4,2,1) =tens5581;
tens5(:,:,5,4,2,2) =tens5582;
tens5(:,:,5,4,2,3) =tens5583;
tens5(:,:,5,4,2,4) =tens5584;
tens5(:,:,5,4,2,5) =tens5585;
tens5(:,:,5,4,3,1) =tens5586;
tens5(:,:,5,4,3,2) =tens5587;
tens5(:,:,5,4,3,3) =tens5588;
tens5(:,:,5,4,3,4) =tens5589;
tens5(:,:,5,4,3,5) =tens5590;
tens5(:,:,5,4,4,1) =tens5591;
tens5(:,:,5,4,4,2) =tens5592;
tens5(:,:,5,4,4,3) =tens5593;
tens5(:,:,5,4,4,4) =tens5594;
tens5(:,:,5,4,4,5) =tens5595;
tens5(:,:,5,4,5,1) =tens5596;
tens5(:,:,5,4,5,2) =tens5597;
tens5(:,:,5,4,5,3) =tens5598;
tens5(:,:,5,4,5,4) =tens5599;
tens5(:,:,5,4,5,5) =tens5600;
tens5(:,:,5,5,1,1) =tens5601;
tens5(:,:,5,5,1,2) =tens5602;
tens5(:,:,5,5,1,3) =tens5603;
tens5(:,:,5,5,1,4) =tens5604;
tens5(:,:,5,5,1,5) =tens5605;
tens5(:,:,5,5,2,1) =tens5606;
tens5(:,:,5,5,2,2) =tens5607;
tens5(:,:,5,5,2,3) =tens5608;
tens5(:,:,5,5,2,4) =tens5609;
tens5(:,:,5,5,2,5) =tens5610;
tens5(:,:,5,5,3,1) =tens5611;
tens5(:,:,5,5,3,2) =tens5612;
tens5(:,:,5,5,3,3) =tens5613;
tens5(:,:,5,5,3,4) =tens5614;
tens5(:,:,5,5,3,5) =tens5615;
tens5(:,:,5,5,4,1) =tens5616;
tens5(:,:,5,5,4,2) =tens5617;
tens5(:,:,5,5,4,3) =tens5618;
tens5(:,:,5,5,4,4) =tens5619;
tens5(:,:,5,5,4,5) =tens5620;
tens5(:,:,5,5,5,1) =tens5621;
tens5(:,:,5,5,5,2) =tens5622;
tens5(:,:,5,5,5,3) =tens5623;
tens5(:,:,5,5,5,4) =tens5624;
tens5(:,:,5,5,5,5) =tens5625;
function userfun1=y_plus_z(t,kmrgd,a,alpha0,m,g,gamma0,n,nu0,k,zetam,zeta0)
	userfun1=kmrgd(2)+kmrgd(4);
function userfun2=y0_plus_z0(t,kmrgd,a,alpha0,m,g,gamma0,n,nu0,k,zetam,zeta0)
	userfun2=kmrgd(3)+kmrgd(5);
