function fig_6c_2d_bif_maker
vec_cr = [-10,10];
dir = 'data/';
close all
figure; 
hold on; box on; %grid on; 
xlimmin = 0;
xlimmax = 2;
ylimmin = 0;
ylimmax = 4;
xlim([xlimmin,xlimmax]);
ylim([ylimmin,ylimmax]);
colours = get(gca,'ColorOrder');

% font size
fs = 16;
% linewidth
lw = 1.5;
% markersize
ms = 7;

% find files
lpc_files = ls(sprintf('%sLPC*',dir));
h_files = ls(sprintf('%sH*',dir));
bp_files = ls(sprintf('%sBP*',dir));
zh_files = ls(sprintf('%sZH*',dir));

% number of files
n_lpc = size(lpc_files,1);
n_h = size(h_files,1);
n_bp = size(bp_files,1);
n_zh = size(zh_files,1);

for i = 1:n_zh
    
    fname = sprintf('%s%s',dir,zh_files(i,:));
    load(fname);
    
    [x_nonbio, x_bio, par1_nonbio, par1_bio, par2_nonbio, par2_bio] = biol_rel_zh(x);
    
    spacing = vec_cr(2);
    plot(par1_nonbio(1:spacing:end), par2_nonbio(1:spacing:end), '-*', 'linewidth', lw, 'color', colours(2,:));
    plot(par1_bio(1:spacing:end), par2_bio(1:spacing:end), '-*', 'linewidth', lw, 'color', colours(1,:));
    st = struct2dataset(s);
    num_labels = size(st.label,1);
    for j = 2:num_labels-1
        add_label(st.label(j),fs);
    end    
end

for i = 1:n_lpc
    
    fname = sprintf('%s%s',dir,lpc_files(i,:));
    load(fname);
    
    [x_nonbio, x_bio, par1_nonbio, par1_bio, par2_nonbio, par2_bio] = biol_rel_lpc(x);
    
    spacing = vec_cr(2);
    plot(par1_nonbio(1:spacing:end), par2_nonbio(1:spacing:end), '-*', 'linewidth', lw, 'color', colours(2,:));
    plot(par1_bio(1:spacing:end), par2_bio(1:spacing:end), '-*', 'linewidth', lw, 'color', colours(1,:));
%     st = struct2dataset(s);
%     num_labels = size(st.label,1);
%     for j = 2:num_labels-1
%         add_label(st.label(j),fs);
%     end    
end 

for i = 1:n_h
    
    fname = sprintf('%s%s',dir,h_files(i,:));
    load(fname);
    
    [x_nonbio, x_bio, par1_nonbio, par1_bio, par2_nonbio, par2_bio] = biol_rel_h(x);
   
    plot(par1_nonbio,par2_nonbio,  '-', 'linewidth', lw, 'color', colours(2,:));
    plot(par1_bio,par2_bio,  '-', 'linewidth', lw, 'color', colours(1,:));
%     st = struct2dataset(s);
%     num_labels = size(st.label,1);
%     for j = 2:num_labels-1
%         add_label(st.label(j),fs);
%     end    
end    
for i = 1:n_bp
    
    fname = sprintf('%s%s',dir,bp_files(i,:));
    load(fname);
    
    [x_nonbio, x_bio, par1_nonbio, par1_bio, par2_nonbio, par2_bio] = biol_rel_bp(x);
   
    plot(par1_nonbio, par2_nonbio, '--', 'linewidth', lw, 'color', colours(2,:));
    plot(par1_bio, par2_bio, '--', 'linewidth', lw, 'color', colours(1,:));
%     st = struct2dataset(s);
%     num_labels = size(st.label,1);
%     for j = 2:num_labels-1
%         add_label(st.label(j),fs);
%     end   

end 
% Analytically found transcritical bifurcations

% [alpha0_tr,alpha_tr] = plot_tr;
% plot([xlimmin,alpha0_tr],[alpha_tr,alpha_tr],'--', 'linewidth', lw, 'color', colours(1,:));
% plot([alpha0_tr,alpha0_tr], [ylimmin,alpha_tr],'--', 'linewidth', lw, 'color', colours(1,:));

% plot_param1 = 0:0.1:2;
% plot_param2 = 2.5:0.1:10;
% alpha_bif1 = plot_bif(plot_param1);
% alpha_bif2 = plot_bif(plot_param2);
% plot(plot_param1,alpha_bif1,'-.', 'linewidth', lw, 'color', colours(1,:));
% plot(plot_param2,alpha_bif2,'-.', 'linewidth', lw, 'color', colours(1,:));

% alphas invariance when C = 0
% param = xlimmin:0.01:xlimmax;
% alpha_inv = c_is_zero(param);
% plot(param,alpha_inv,':', 'linewidth', lw-0.5, 'color', 'k');

% mu vs Parameter transcritical curve found analytically
% param = xlimmin:0.01:xlimmax;
% mu_bif = mu_bif(param);
% plot(param,mu_bif,'-.', 'linewidth', lw+1, 'color', colours(1,:));

% kappa vs alpha0 transcritical curve found analytically
% param = xlimmin:0.01:xlimmax;
% kappa_bif = kappa_bif(param);
% plot(param, kappa_bif,':', 'linewidth', lw+2, 'color', colours(1,:));

% [g_13, g_23] = value_gamma_bif;
% plot([g_13,g_13], [0,30], '--', 'linewidth', lw, 'color', colours(1,:));
%plot([g_23,g_23], [0,30], '-.', 'linewidth', lw+1, 'color',
%colours(1,:));

% Create regions
% annotation('textbox',...
%     [0.201785714285714 0.131857146853493 0.127910325085682 0.0847619007655551],...
%     'String','I',...
%     'LineStyle','none',...
%     'Interpreter','latex',...
%     'FontSize',fs,...
%     'FitBoxToText','off');

% Adding cross section 
if vec_cr(1)>0
    plot([vec_cr(1),vec_cr(1)], [0,10], ':', 'linewidth', lw*0.7, 'color', 'k');
    plot([0,10], [vec_cr(2),vec_cr(2)], ':', 'linewidth', lw*0.7, 'color', 'k');
    % Create text for cross section
    text('Rotation',90,'String','  \gamma_w',...
        'Position',[4.31491712707182 3.93398533007335 0]);
    text('Rotation',90,'String', vec_cr(1),...
        'Position',[4.33379373848987 3.46577017114914 0]);
    text('Rotation',0,'String','  \gamma_m = ',...
        'Position',[3.15469613259668 2.50061124694376 0]);
    annotation('rectangle',...
        [0.644928571428569 0.543333333333341 0.0102648809523836 0.0143589743589667]);
    text('Rotation',0,'String', vec_cr(2),...
        'Position',[3.4866482504604 2.50672371638141 0]);
end

set(gca,'fontsize', fs);
set(gca, 'TickLabelInterpreter', 'latex');
% ylabel('$\alpha_m$', 'interpreter', 'latex');
% xlabel('$\alpha_w$', 'interpreter', 'latex');
% annotation('rectangle',...
%      [0.0306428571428564 0.55952380952381 0.0115000000000008 0.0167619047619089]);


function add_label(str, fs)

if strcmp(str, 'NE ')
    return
end

annotation('textbox',...
    [0.3175 0.554714289710635 0.127910325085682 0.0847619007655551],...
    'String',str,...
    'LineStyle','none',...
    'Interpreter','latex',...
    'FontSize',fs);

function [x_nonbio, x_bio, par1_nonbio, par1_bio, par2_nonbio, par2_bio] = biol_rel_zh(x) 

nonbio = any(x(1:end-2,:)<-1e-10);
bio = all(x(1:end-2,:)>-1e-10);

x_nonbio = x(:,nonbio);
x_bio = x(:,bio);

par1_nonbio = x_nonbio(end,:);
par1_bio = x_bio(end,:);
par2_nonbio = x_nonbio(end-1,:);
par2_bio = x_bio(end-1,:);

function [x_nonbio, x_bio, par1_nonbio, par1_bio, par2_nonbio, par2_bio] = biol_rel_lpc(x) 

nonbio = any(x(1:end-2,:)<-1e-7);
bio = all(x(1:end-2,:)>-1e-7);

x_nonbio = x(:,nonbio);
x_bio = x(:,bio);

par1_nonbio = x_nonbio(end,:);
par1_bio = x_bio(end,:);
par2_nonbio = x_nonbio(end-1,:);
par2_bio = x_bio(end-1,:);

function [x_nonbio, x_bio, par1_nonbio, par1_bio, par2_nonbio, par2_bio] = biol_rel_h(x) 

nonbio = any(x(1:end-2,:)<-1e-10);
bio = all(x(1:end-2,:)>-1e-10);

x_nonbio = x(:,nonbio);
x_bio = x(:,bio);

par1_nonbio = x_nonbio(end-1,:);
par1_bio = x_bio(end-1,:);
par2_nonbio = x_nonbio(end-2,:);
par2_bio = x_bio(end-2,:);

function [x_nonbio, x_bio, par1_nonbio, par1_bio, par2_nonbio, par2_bio] = biol_rel_bp(x) 

nonbio = any(x(1:end-2,:)<-1e-7);
bio = all(x(1:end-2,:)>-1e-7);

x_nonbio = x(:,nonbio);
x_bio = x(:,bio);

par1_nonbio = x_nonbio(end,:);
par1_bio = x_bio(end,:);
par2_nonbio = x_nonbio(end-1,:);
par2_bio = x_bio(end-1,:);

function p = parameters

p.alpha0 = 3;
p.alpha = 1;
% p.mu = 0.1;
% p.gamma = 0.25;
% p.gamma0 = 0.225;
% p.nu = 0.5;
% p.nu0 = 0.45;
% p.kappa = 0.9;
% p.zeta = 0.2222;
% p.zeta0 = 0.2;
p.mu = 0.1;
p.gamma = 0.25;
p.gamma0 = 0.25;
p.nu = 0.5;
p.nu0 = 0.5;
p.kappa = 1.0;
p.zeta = 0.2222;
p.zeta0 = 0.2222;

function [alpha0_tr, alpha_tr] = plot_tr()

p = parameters;
alpha0_tr = p.zeta0./(p.kappa * (1./(1 + p.mu * (1./p.gamma0))) - p.nu0); %(p.gamma0*p.zeta0+p.mu*p.zeta0)/(p.gamma0*(p.kappa-p.nu0)-p.mu*p.nu0);
alpha_tr = p.zeta./(1-p.nu);


function alpha_bif = plot_bif(param)

p = parameters;
alpha0 = param;
alpha_bif = -p.zeta * ((p.gamma0 * p.gamma * p.kappa - p.gamma0 * p.gamma * p.nu0 + p.gamma0 * p.kappa * p.mu - p.gamma0 * p.mu * p.nu0 - p.gamma * p.mu * p.nu0) * alpha0 - p.gamma0 * p.gamma * p.zeta0 - p.gamma0 * p.mu * p.zeta0 - p.mu * p.gamma * p.zeta0) ./ ((p.gamma0 * p.gamma * p.kappa * p.nu - p.gamma0 * p.gamma * p.nu * p.nu0 + p.gamma0 * p.kappa * p.mu * p.nu - p.gamma0 * p.mu * p.nu * p.nu0 - p.gamma * p.mu * p.nu * p.nu0 - p.gamma0 * p.gamma * p.kappa + p.gamma0 * p.gamma * p.nu0 + p.gamma * p.mu * p.nu0) * alpha0 - p.gamma0 * p.gamma * p.nu * p.zeta0 - p.gamma0 * p.mu * p.nu * p.zeta0 - p.gamma * p.mu * p.nu * p.zeta0 + p.gamma0 * p.gamma * p.zeta0 + p.mu * p.gamma * p.zeta0);

function [g_13, g_23] = value_gamma_bif

p = parameters;
g_13 = p.mu * (p.alpha0 * p.nu0 + p.zeta0) ./ (p.alpha0 * p.kappa - (p.alpha0 * p.nu0 + p.zeta0));
g_23 = p.mu ./ ((p.kappa ./ (p.alpha ./ p.alpha0) * (p.zeta0 ./ p.zeta) * (1-p.nu) + p.nu0)-1);

function mu_bif = mu_bif(param)

p = parameters;
p.alpha0 = param;
mu_bif = p.gamma0* (p.alpha0 * (p.kappa - p.nu0) - p.zeta0) ./ (p.zeta + p.alpha0 * p.nu0);

function kappa_bif = kappa_bif(param)

p = parameters;
p.alpha0 = param;
kappa_bif = (p.mu + p.gamma0) * (p.alpha0 * p.nu0 + p.zeta0) ./ (p.alpha0 * p.gamma0);

function alphas_when_C_is_zero = c_is_zero(param)

p = parameters;
p.alpha0 = param;
alphas_when_C_is_zero = p.alpha0 * ((p.zeta * (p.gamma0 * (p.kappa - p.nu0) - p.mu * p.nu0)) ./ (p.zeta0 * (p.gamma0 * (1-p.nu) - p.mu * p.nu)));