function fig_5b_1d_bif_maker
spacing_vec = [10,1,1];
dir = 'data/';
close all 
figure; 
hold on; box on; grid on; 
xlimmax = 5;
xlimmin = 0;
ylimmax = 1.1;
ylimmin = -0.1;
xlim([xlimmin,xlimmax]);
ylim([ylimmin,ylimmax]);
colours = get(gca,'ColorOrder');

num_vars = 5;%size(h, 1);
var_no = 1; %plotting variable

% font size
fs = 16;
% linewidth
lw = 1.5;
% markersize
ms = 4; % 3 is used for slim plots, 7 for old plots

% find files
lc_files = ls(sprintf('%sH*',dir));
eq_files = ls(sprintf('%sEP*',dir));
bp_files = ls(sprintf('%sBP*',dir));

% % number of files
n_lc = size(lc_files,1);
n_eq = size(eq_files,1);
n_bp = size(bp_files,1);

for i = 1:n_eq
    
    fname = sprintf('%s%s',dir,eq_files(i,:));
    load(fname);

    [x_nonbio, x_bio, f_nonbio, f_bio, par_nonbio, par_bio] = biol_rel(x,f); 
    [nonbio_st_x, nonbio_unst_x, nonbio_st_par, nonbio_unst_par] = stab_eq(x_nonbio, f_nonbio, par_nonbio);
    [bio_st_x, bio_unst_x, bio_st_par, bio_unst_par] = stab_eq(x_bio, f_bio, par_bio);

%     loglog(nonbio_st_par, nonbio_st_x(1,:), '-', 'linewidth', lw, 'color', colours(2,:));
%     loglog(nonbio_unst_par, nonbio_unst_x(1,:), '--', 'linewidth', lw, 'color', colours(2,:));
%     loglog(bio_st_par, bio_st_x(1,:), '-', 'linewidth', lw, 'color', colours(1,:));
%     loglog(bio_unst_par, bio_unst_x(1,:), '--', 'linewidth', lw, 'color', colours(1,:));
    plot(nonbio_st_par, nonbio_st_x(var_no,:), '-', 'linewidth', lw, 'color', colours(2,:));
    plot(nonbio_unst_par, nonbio_unst_x(var_no,:), '--', 'linewidth', lw, 'color', colours(2,:));
    plot(bio_st_par, bio_st_x(var_no,:), '-', 'linewidth', lw, 'color', colours(1,:));
    plot(bio_unst_par, bio_unst_x(var_no,:), '--', 'linewidth', lw, 'color', colours(1,:));
%     st = struct2dataset(s);
%     num_labels = size(st.label,1);
%     for j = 2:num_labels-1
%         add_label(st.label(j),fs);
%     end    
%     
end

for i = 1:n_bp
    
    fname = sprintf('%s%s',dir,bp_files(i,:));
    load(fname);
    
    [x_nonbio, x_bio, f_nonbio, f_bio, par_nonbio, par_bio] = biol_rel(x,f); 
    [nonbio_st_x, nonbio_unst_x, nonbio_st_par, nonbio_unst_par] = stab_eq(x_nonbio, f_nonbio, par_nonbio);
    [bio_st_x, bio_unst_x, bio_st_par, bio_unst_par] = stab_eq(x_bio, f_bio, par_bio);
%     loglog(nonbio_st_par, nonbio_st_x(1,:), '-', 'linewidth', lw, 'color', colours(2,:));
%     loglog(nonbio_unst_par, nonbio_unst_x(1,:), '--', 'linewidth', lw, 'color', colours(2,:));
%     loglog(bio_st_par, bio_st_x(1,:), '-', 'linewidth', lw, 'color', colours(1,:));
%     loglog(bio_unst_par, bio_unst_x(1,:), '--', 'linewidth', lw, 'color', colours(1,:));

    plot(nonbio_st_par, nonbio_st_x(var_no,:), '-', 'linewidth', lw, 'color', colours(2,:));
    plot(nonbio_unst_par, nonbio_unst_x(var_no,:), '--', 'linewidth', lw, 'color', colours(2,:));
    plot(bio_st_par, bio_st_x(var_no,:), '-', 'linewidth', lw, 'color', colours(1,:));
    plot(bio_unst_par, bio_unst_x(var_no,:), '--', 'linewidth', lw, 'color', colours(1,:));

%     st = struct2dataset(s);
%     num_labels = size(st.label,1);
%     for j = 2:num_labels-1
%     %    add_label(st.label(j),fs);
%     end
end

for i = 1:n_lc
    
    fname = sprintf('%s%s',dir,lc_files(i,:));
    load(fname);
    
    par = x(end,1:end);
    period = x(end-1,1:end);
    m = size(x,1)-2;
    
    [x_nonbio, x_bio, f_nonbio, f_bio, par_nonbio, par_bio] = biol_rel_cyc(x,f);
    [nonbio_st_x, nonbio_unst_x, nonbio_st_par, nonbio_unst_par] = stab_cyc(x_nonbio, f_nonbio, par_nonbio, num_vars);
    [bio_st_x, bio_unst_x, bio_st_par, bio_unst_par] = stab_cyc(x_bio, f_bio, par_bio, num_vars);
           
    max_nonbio_st_cl = max(nonbio_st_x(var_no:num_vars:m,:));
    max_nonbio_unst_cl = max(nonbio_unst_x(var_no:num_vars:m,:));
    max_bio_st_cl = max(bio_st_x(var_no:num_vars:m,:));
    max_bio_unst_cl = max(bio_unst_x(var_no:num_vars:m,:));
    
    min_nonbio_st_cl = min(nonbio_st_x(var_no:num_vars:m,:));
    min_nonbio_unst_cl = min(nonbio_unst_x(var_no:num_vars:m,:));
    min_bio_st_cl = min(bio_st_x(var_no:num_vars:m,:));
    min_bio_unst_cl = min(bio_unst_x(var_no:num_vars:m,:));

    spacing = spacing_vec(i);
%     loglog(nonbio_st_par(1:spacing:end), max_nonbio_st_cl(1:spacing:end), 'o', 'linewidth', 1, 'markersize', ms, 'MarkerEdgeColor', colours(2,:), 'markerfacecolor', colours(2,:));
%     loglog(nonbio_unst_par(1:spacing:end), max_nonbio_unst_cl(1:spacing:end), 'o', 'linewidth', 1, 'markersize', ms, 'MarkerEdgeColor', colours(2,:), 'markerfacecolor', 'w');
%     loglog(bio_st_par(1:spacing:end), max_bio_st_cl(1:spacing:end), 'o', 'linewidth', 1, 'markersize', ms, 'MarkerEdgeColor', colours(1,:), 'markerfacecolor', colours(1,:));
%     loglog(bio_unst_par(1:spacing:end), max_bio_unst_cl(1:spacing:end), 'o', 'linewidth', 1, 'markersize', ms, 'MarkerEdgeColor', colours(1,:), 'markerfacecolor', 'w');
%     
%     loglog(nonbio_st_par(1:spacing:end), min_nonbio_st_cl(1:spacing:end), 'o', 'linewidth', 1, 'markersize', ms, 'MarkerEdgeColor', colours(2,:), 'markerfacecolor', colours(2,:));
%     loglog(nonbio_unst_par(1:spacing:end), min_nonbio_unst_cl(1:spacing:end), 'o', 'linewidth', 1, 'markersize', ms, 'MarkerEdgeColor', colours(2,:), 'markerfacecolor', 'w');
%     loglog(bio_st_par(1:spacing:end), min_bio_st_cl(1:spacing:end), 'o', 'linewidth', 1, 'markersize', ms, 'MarkerEdgeColor', colours(1,:), 'markerfacecolor', colours(1,:));
%     loglog(bio_unst_par(1:spacing:end), min_bio_unst_cl(1:spacing:end), 'o', 'linewidth', 1, 'markersize', ms, 'MarkerEdgeColor', colours(1,:), 'markerfacecolor', 'w');
    
    plot(nonbio_st_par(1:spacing:end), max_nonbio_st_cl(1:spacing:end), 'o', 'linewidth', 1, 'markersize', ms, 'MarkerEdgeColor', colours(2,:), 'markerfacecolor', colours(2,:));
    plot(nonbio_unst_par(1:spacing:end), max_nonbio_unst_cl(1:spacing:end), 'o', 'linewidth', 1, 'markersize', ms, 'MarkerEdgeColor', colours(2,:), 'markerfacecolor', 'w');
    plot(bio_st_par(1:spacing:end), max_bio_st_cl(1:spacing:end), 'o', 'linewidth', 1, 'markersize', ms, 'MarkerEdgeColor', colours(1,:), 'markerfacecolor', colours(1,:));
    plot(bio_unst_par(1:spacing:end), max_bio_unst_cl(1:spacing:end), 'o', 'linewidth', 1, 'markersize', ms, 'MarkerEdgeColor', colours(1,:), 'markerfacecolor', 'w');
    
    plot(nonbio_st_par(1:spacing:end), min_nonbio_st_cl(1:spacing:end), 'o', 'linewidth', 1, 'markersize', ms, 'MarkerEdgeColor', colours(2,:), 'markerfacecolor', colours(2,:));
    plot(nonbio_unst_par(1:spacing:end), min_nonbio_unst_cl(1:spacing:end), 'o', 'linewidth', 1, 'markersize', ms, 'MarkerEdgeColor', colours(2,:), 'markerfacecolor', 'w');
    plot(bio_st_par(1:spacing:end), min_bio_st_cl(1:spacing:end), 'o', 'linewidth', 1, 'markersize', ms, 'MarkerEdgeColor', colours(1,:), 'markerfacecolor', colours(1,:));
    plot(bio_unst_par(1:spacing:end), min_bio_unst_cl(1:spacing:end), 'o', 'linewidth', 1, 'markersize', ms, 'MarkerEdgeColor', colours(1,:), 'markerfacecolor', 'w');
     
    %text info
%     st = struct2dataset(s);
%     text_info = st.label(1);
end

set(gca,'fontsize', fs);
set(gca, 'TickLabelInterpreter', 'latex');
plot([xlimmin,xlimmax],[0,0],'--', 'linewidth', lw, 'color', colours(1,:));
% ylabel('$x$', 'interpreter', 'latex');
% xlabel('$\alpha_w$', 'interpreter', 'latex');
% annotation('rectangle',...
%     [0.529928571428571 0.0504761904761923 0.0175714285714295 0.0229523809523792]);


function add_label(str, fs)

if strcmp(str, 'NE ')
    return
end

annotation('textbox',...
    [0.3175 0.554714289710635 0.127910325085682 0.0847619007655551],...
    'String',str,...
    'LineStyle','none',...
    'Interpreter','latex',...
    'FontSize',fs);

function [x_nonbio, x_bio, f_nonbio, f_bio, par_nonbio, par_bio] = biol_rel(x,f) 

nonbio = any(x(1:end-1,:)<-1e-7);
bio = all(x(1:end-1,:)>-1e-7);

x_nonbio = x(:,nonbio);
x_bio = x(:,bio);

f_nonbio = f(:,nonbio);
f_bio = f(:,bio);

par_nonbio = x_nonbio(end,:);
par_bio = x_bio(end,:);


function [st_x, unst_x, st_par, unst_par] = stab_eq(x, f, par)

 st_f = all(real(f) < 1e-7);
 unst_f = any(real(f) > 1e-7);
 
 st_x = x(:,st_f);
 unst_x = x(:,unst_f);
 
 st_par = par(st_f);
 unst_par = par(unst_f);

% nonbio_st_idx = all(real(f_nonbio) < 0.0000001);
% nonbio_unst_idx = any(real(f_nonbio) > 0.0000001);
% 
% bio_st_idx = all(real(f_bio) < 0.0000001);
% bio_unst_idx = any(real(f_bio) > 0.0000001);

function [x_nonbio, x_bio, f_nonbio, f_bio, par_nonbio, par_bio] = biol_rel_cyc(x,f) 

nonbio = any(x(1:end-2,:)<-1e-7);
bio = all(x(1:end-2,:)>-1e-7);

x_nonbio = x(:,nonbio);
x_bio = x(:,bio);

f_nonbio = f(:,nonbio);
f_bio = f(:,bio);

par_nonbio = x_nonbio(end,:);
par_bio = x_bio(end,:);

function [st_x, unst_x, st_par, unst_par] = stab_cyc(x, f, par, num_vars)

%Floquet multipliers 
FM = zeros(num_vars,size(f,2));
for j = 1:size(f,2)
    [M,I] = min(abs(abs(f(end-num_vars+1:end,j))-1));
    for i = 1:num_vars
        if i ~= I
            FM(i,j)=f(i+size(f,1)-num_vars,j);
        end
    end
end

% Stability check
st_ind = all(abs(FM) < (1-1e-7));
unst_ind = any(abs(FM) > (1-1e-7));

st_x = x(:,st_ind);
unst_x = x(:,unst_ind);

st_par = par(st_ind);
unst_par = par(unst_ind);
% keyboard
 
% function [nonbio_st_idx, nonbio_unst_idx, bio_st_idx, bio_unst_idx] = biol_rel_cyc(x,f) 
% 
% nonbio = any(x(1:end-2,:)<-1e-15);
% bio = all(x(1:end-2,:)>-1e-15);
%   
% %Floquet multipliers 
% FM = zeros(5,size(f,2));
% for j = 1:size(f,2)
%     [M,I] = min(abs(abs(f(end-4:end,j))-1));
%     for i = 1:5
%         if i == I
%             break;
%         else
%         FM(i,j)=f(i+size(f,1)-5,j);
%         end
%     end
% end
% nonbio_st_idx = all(abs(FM(1:end,nonbio)) < (1-1e-10));
% nonbio_unst_idx = any(abs(FM(1:end,nonbio)) > (1-1e-10));
% 
% bio_st_idx = all(abs(FM(1:end,bio)) < (1-1e-10));
% bio_unst_idx = any(abs(FM(1:end,bio)) > (1-1e-10));
