C
C **********************************************************
C
C        P R O G R A M    V A R I O G R A M
C
C   FUNCTION - READS X,Y,Z DATA FROM AN ACTIVE MAP,REWRITES
C              THIS INFORMATION IN STATPAC FORMAT, PASSES
C              CONTROL TO A SON PROCESS TO CREATE A VARIOGRAM
C              USER HAS OPTION OF SAVING THE VARIOGRAM ON
C              PERMANENT DISK FILE.
C
C  LOGICAL CHANNEL NUMBERS
C
C      IOIN  = LOGICAL UNIT TERMINAL INPUT
C      NPRNT = LOGICAL UNIT TERMINAL OUTPUT
C      IUNIT = LOGICAL UNIT GRAPHICS INPUT/OUTPUT
C      ICHAN1= LOGICAL UNIT FOR INPUT POINT SAMPLE MAP
C      ICHAT= LOGICAL UNIT FOR .AT FILE
C      ICHSTP  = LOGICAL UNIT FOR STATPAC FILE OUTPUT
C      ICHVRG  = LOGICAL UNIT FOR VARIOGRAM FILE INPUT
C      ICHERR  = LOGICAL UNIT FOR INTERPROCESS COMMUNICATION
C                TO RETURN A COMPLETION CODE FROM SWAPPED
C                PROCESS.  SEE COMMENTS IN "PROCES.FR".
C *********************************************************
C
$INCLUDE: 'DBCHAN.INC'
       COMMON /MFAST/  IFBUFF(259)
       COMMON /IO/     NPRNT,IOIN
       COMMON /FLS/    IUNIT,IFILE(5)
       COMMON /WORK/   IBUFF(128),MAP(25),ICOM(10),JCOM(10)
       COMMON /TYPE/   IDATYP(40),NACTS
       COMMON /STRNG/  ICARD(80),ICARDP,LENICD
       COMMON /WHMAP/  ISTRCT(300),NSTRCT
       COMMON /ATTFET/ KAT(86),LBAT
       COMMON /GWINDO/ INBAND(1024)
       COMMON /WINDOW/ WIND(4)
C       COMMON /DNAMES/ MAST(8),IWORK(8)
       COMMON /DNAMES/ MAST(25),IWORK(25),IDIR(8),JNAMES(3,12),LENDIR
       COMMON /UNIT/   ICHAT,ATRBTE,POLYGON,ADRESS
C       COMMON /DSBUF/  MLEN,IDATA(8448)
C
       INTEGER*2 IHEAD(256),DESCB(25),IBLNK,FTEMP(8),mapname(25)
       CHARACTER*1 IANS
       LOGICAL MCOMP,FOUND,iexist
C       IBLNK = Z '2020'
       IBLNK = 8224
C       mlen=8193
C
C  STATEMENT FUNCTIONS
C
C      LCHAR(I) = I/256
C      IRCHAR(I) = MOD(I,256)
C
C  ASSIGN CHANNEL NUMBERS
C
       IER = 0
       ICHAN1=11
       ICHAT =26
       ICHERR=13
       ICHSTP=28
       ICHVRG=33
C
       LINES = 1
       IPRMT = 0
C
C
C  LOAD COMMON
C
      call initl(IER)
      IF(IER .NE. 0) GO TO 90080
C
C  OPEN CHANNEL TO POINTER FILE
C
C        call openf(icdcfa,idesfa,1,512,2,IER)
C
C  GET THE WINDOW
C
      CALL WHWND(WIND(1),WIND(3),WIND(2),WIND(4))
      IF(WIND(2)-WIND(1).EQ.0.OR.WIND(4)-WIND(3).EQ.0) GO TO 90100
C
C  GET ACTIVE DATA SET TO VARIOGRAM
C
      CALL DAGET(ICARD,ICARDP,MAP,25,MACTS)
      IF(MACTS.NE.0) GO TO 10
C
C  PROMPT FOR ACTIVE DATA SET
C
      IPRMT=1
      WRITE(NPRNT,1000)
 1000 FORMAT(' ENTER ACTIVE MAP ID FOR THE VARIOGRAM'\)
      call readin(ICARD, 80, ICARDP, LENICD)
      CALL DAGET(ICARD,ICARDP,MAP,25,MACTS)
C
C  RETRIEVE MAPID
C
 10   CONTINUE
      MAPID=MAP(1)
      IDTYPE = IDATYP(MAPID/7+1)
      IF (IDTYPE .NE. 1   .AND.  IDTYPE .NE. 5   .AND. IDTYPE .NE. 11
     +    .AND. IDTYPE .NE. 12  .AND.  IDTYPE .NE. 13) GO TO 90200
C
C  OPEN INPUT CHANNEL TO DATA MAP AND READ HEADER RECORDS
C
C      call gtnam(MAPID,0,IBLNK,MAP,IER)
      CALL GTMAP(MAP,MAPID)
      call adddir(map,mapname)
      CALL openf(ICHAN1,MAPname,1,256,2,IER)
      IF (IER .NE. 0) GO TO 90300
      CALL rdblk(ICHAN1,1,IHEAD(1),1,IER)
      IF (IER .NE. 0) GO TO 90400
      CALL rdblk(ICHAN1,2,IHEAD(129),1,IER)
      IF (IER .NE. 0) GO TO 90400
C
C  CHECK FOR CORRECT MAP TYPE  1 OR 5,11,12,13
C
      IDTYPE=IHEAD(62)
      IF (IDTYPE .NE. 1   .AND.  IDTYPE .NE. 5   .AND. IDTYPE .NE. 11
     +    .AND. IDTYPE .NE. 12  .AND.  IDTYPE .NE. 13) GO TO 90200
C
C  CHECK FOR USING MULTIPLE ATTRIBUTE FILE FOR INPUT
C
      IATYP1 = IHEAD(76)
      IATYP = 0
      IF (IATYP1 .NE. 1) GO TO 45
      IATYP=KAT((MAPID/7)*2+1)
      MWORDS = ABS(IATYP)
      LOCATE=KAT((MAPID/7)*2+2)
      IF(IATYP.EQ.0) GO TO 45
C
C  YUP.. OPEN .AT FILE
C
      call gtnam(MAPID,4,IBLNK,MAP,IER)
      call openf(ICHAT,MAP,1,256,2,IER)
      IF(IER.NE.0) GO TO 90500
      IF(IATYP.LT.4) GO TO 45
C  FROM BSEARCH...PROMPT FOR FIELD
  42    call initial
        CALL RETRVL(FOUND,IBUFF)
        IF(.NOT.FOUND) GO TO 42
        IATYP=IBUFF(84)
        MWORDS=IBUFF(85)
        LOCATE=IBUFF(86)
   45  CONTINUE
C
C  GET VARIOGRAM PARAMETERS FROM USER
C
       CALL ss2dvctl(ichko,ier)
       IF (IER.NE.0) GO TO 90600
C
C  ASK USER IF THIS IS A RESTART
C  CHECK TO SEE IF RESTART FILE EXISTS BY ATTEMPTING TO RECREATE IT
C  ERROR 25 = FILE ALREADY EXISTS
C
c       WRITE (NPRNT,100)
c  100  FORMAT (' IS THIS A RESTART? [N] ',/,' ?'\)
c       READ (IOIN,110) IANS
c  110  FORMAT (A1)
cC       IANS = IANS/256
c       IF ((IANS.NE.'y').AND.(IANS.NE.'Y')) GO TO 150
        go to 150
       INQUIRE(file='tempkrig.upr',exist=iexist)
       IF (IExist) GO TO 200
       WRITE (NPRNT,120)
  120  FORMAT (' Sorted statpac file TEMPKRIG.UPR not found',
     +        /' .......attempting restart from unsorted statpac file ')
       INQUIRE(file='tempkrig.stp',exist=iexist)
       IF (Iexist) GO TO 180
        WRITE (NPRNT,130)
  130   FORMAT (' Unsorted statpac file TEMPKRIG.STP not found',
     +         /' .........restart option ignored')
C
C  WRITE X,Y AND ELEVATION DATA TO STATPAC FILE
C
  150  CONTINUE
       SCAL = 1.0
        CALL KRGIN2 (NPRNT,MAPID,IDTYPE,IATYP,LOCATE,WIND,SCAL,
     1               AWIND,ICHAN1,ICHAT,ICHSTP,DSNAM,
     2               NPTS,IER)
C
       IF (IER.NE.0) GO TO 90700
C  SORT STATPAC DATA IN ASCENDING ORDER BY Y-COORDINATE
C
  180  CONTINUE
C       CALL PROCES ('SS2DPREP.PR',ICHERR,IER)
       CALL ss2dprep(ichstp,ichupr,ier)
       IF (IER.NE.0) GO TO 90800
C
C  CALCULATE VARIOGRAM
C
  200  CONTINUE
C       CALL PROCES ('SS2DGAMH.PR',ICHERR,IER)
       CALL ss2dgamh(ichko,ichupr,ICHFRG,ier)
       IF (IER.NE.0) GO TO 90900
C
C  DISPLAY VARIOGRAM AND ASK USER IF THEY WANT TO KEEP IT
C
      CALL VARGOUT(NPRNT,IOIN,ICHFRG,IER)
      IF( IER .NE. 0) GO TO 91000
C
C  NORMAL RETURN
C
      go to 90000

C  ERROR RETURNS
C
90080 WRITE(NPRNT,90008)IER
90008 FORMAT (1X,'**VARIOGRAM** ERROR FROM Qinitl  ERROR ',I5)
      GO TO 90000
90100 WRITE (NPRNT,90105)
90105 FORMAT (1X,'**VARIOGRAM** WINDOW HAS NOT BEEN SET')
      GO TO 90000
90200 WRITE (NPRNT,90205)
90205 FORMAT (1X,'**VARIOGRAM** INPUT MAP DOES NOT HAVE PROPER DATA ',
     +           'TYPE')
      GO TO 90000
90300 WRITE (NPRNT,90305)
90305 FORMAT (1X,'**VARIOGRAM** ERROR ON OPEN OF CHANNEL TO INPUT MAP')
      GO TO 90000
90400 WRITE (NPRNT,90405)
90405 FORMAT (1X,'**VARIOGRAM** ERROR ON ATTEMPT TO READ MAP HEADER')
      GO TO 90000
90500 WRITE (NPRNT,90505)
90505 FORMAT (1X,'**VARIOGRAM** ERROR FROM ATTEMPT TO OPEN .AT FILE')
      GO TO 90000
90600 WRITE (NPRNT,90605) IER
90605 FORMAT (1X,'**VARIOGRAM** ABNORMAL RETURN FROM SS2DVCTL,  IER = ',
     +        I3)
      GO TO 90000
90700 WRITE (NPRNT,90705)IER
90705 FORMAT (1X,'**VARIOGRAM** ABNORMAL RETURN FROM VARGIN   ERROR',I5)
      GO TO 90000
90800 WRITE (NPRNT,90805)
90805 FORMAT (1X,'**VARIOGRAM** ABNORMAL RETURN FROM SS2DPREP ')
      GO TO 90000
90900 WRITE (NPRNT,90905)IER
90905 FORMAT (1X,'**VARIOGRAM** ABNORMAL RETURN FROM SS2DGAMH,IER = ',
     +        I5)
      GO TO 90000
91000 WRITE (NPRNT,91005)IER
91005 FORMAT (1X,'**VARIOGRAM** ABNORMAL RETURN FROM VARGOUT   ERROR',
     +        I5)
90000 continue
      END
