      SUBROUTINE SS2DGAMH(ipt,ki,ICHFRG,ier)
C***  PROGRAM TO COMPUTE SEMIVARIOGRAMS (GAMMA(H))
C***  THIS PROGRAM WAS WRITTEN BY H.P. KNUDSEN OF THE UNIVERSITY OF
C***  ARIZONA TO COMPUTE SEMIVARIOGRAMS.  DOCUMENTATION IS GIVEN IN
C***  Knudsen, H.P., and Kim, Y.C., 1977, A short course on geostatist-
C***      ical ore reserve estimation: College of mines, University of
C***      Arizona, Tucson, Arizona, 202 pages and appendices.
C***  THE PROGRAM WAS MODIFIED BY W. D. GRUNDY, U.S. GEOLOGICAL SUR-
C***  VEY, TO REDUCE RUNNING TIME ON LARGE DATA SETS AND TO ACCEPT
C***  DATA FROM AN UNFORMATTED (STATPAC) INPUT FILE.
C***
C**********************************************************************
C***
C***  THE PROGRAM COMPUTES THE FOLLOWING FORMULAS AND WRITES THEM TO
C***  A CHARACTER OUTPUT FILE IN TABULAR AND GRAPHIC FORM:
C***
C***  GAMMA(H)=(CUM.DIFFERENCE SQUARED)/(2*(NO. OF SAMPLES))
C***
C***  AS AN ALTERNATIVE ESTIMATE OF GAMMA(H) (MOMENT CENTER) :
C***  GAMMA(H)=(CUM (DISTANCE*DIFF.SQUARED))/(2*(CUM. DISTANCE))
C***
C***  AS AN OPTIONAL COMPUTATION :
C***  RELATIVE GAMMA(H)=GAMMA(H)/(SAMPLE MEAN SQUARED)
C***
C***  AVERAGE DISTANCE=(CUM. DISTANCE)/(NO. OF SAMPLES)
C***
C***  DRIFT=(CUM.DIFFERENCE)/(NO. OF SAMPLES)
C***
C***  SEE COMMENTS BELOW FOR FORTRAN VARIABLE NAMES ASSIGNED TO THE
C***  TERMS IN THE ABOVE FORMULAS.
C***  AS AN OPTION, THE PROGRAM WRITES OUT A CHARACTER DISK FILE OF
C***  THE ABOVE VALUES WHICH CAN BE USED FOR SCREEN PLOTTING.
C***
C**********************************************************************
C***
C***  PROGRAM COMPUTES VARIOGRAMS IN ONE TO FIVE DIRECTIONS.  VALUES
C***  ARE COMPUTED FOR UP TO 20 DISTANCE CLASS INTERVALS.  THE USER
C***  SPECIFIES THE SIZE OF THESE INTERVALS IN A PROGRAM CONTROL FILE.
C***  THE USER ALSO SPECIFIES THE ALLOWABLE SPREAD IN DEGREES FROM
C***  THE DIRECTION IN WHICH THE VARIOGRAM IS COMPUTED FOR DATA TO
C***  BE INCLUDED IN THE COMPUTATIONS. TO COMPUTE THE AVERAGE VARIOGRAM
C***  IN ALL DIRECTIONS, AN ANGULAR TOLERANCE (WINDOW) OF 90 DEGREES
C***  MUST BE SPECIFIED.
C***
C**********************************************************************
C***
C***                      REQUIRED INPUT FILES
C***
C***  THIS PROGRAM REQUIRES A PREPROCESSED STATPAC INPUT FILE WHICH
C***  CONTAINS CARTESIAN X- AND Y-COORDINATES TOGETHER WITH THE
C***  OBSERVED VALUES OF THE REGIONALIZED VARIABLE.  PREPROCESSING
C***  IS DONE BY PROGRAM SS2DPREP, WHICH SORTS AN INPUT STATPAC FILE
C***  IN ASCENDING ORDER OF X- AND Y-COORDINATES, AND IF NO DUPLICATED
C***  COORDINATE PAIRS ARE FOUND, WRITES THE SORTED DATA TO THE
C***  PREPROCESSED STATPAC FILE.
C***
C***  THIS PROGRAM ALSO REQUIRES AN ASCII CONTROL FILE ON DISK WHICH
C***  CONTAINS USER-SPECIFICATIONS FOR THE VARIOGRAM RUN.  THIS ASCII
C***  CONTROL FILE IS CREATED BY PROGRAM SS2DVCTL.  FOR DESCRIPTION OF
C***  THE CONTROL FILE, SEE COMMENTS IN SS2DVCTL.FOR.
C***
C***  NOTE: THIS PROGRAM REJECTS QUALIFIED DATA VALUES, SO ONLY
C***  UNQUALIFIED DATA ARE ACTUALLY PROCESSED.
C***
C***  LINKS REQUIRED: ATTACH,CHEKER,CKSAFE,CONCAT,DATE,IOS,MDYHMS,RDN,
C***  SOUND,TICKER,VAROUT
C***
C**********************************************************************
C***
C***   FILE NAME REQUIREMENTS
C***        THE STATPAC INPUT FILE MUST HAVE THE EXTENSION .UPR
C***        THE VARIOGRAM CONTROL FILE MUST HAVE THE EXTENSION .FVC
C***        THE CHARACTER OUTPUT FILE FOR PRINTER DISPLAY IS
C***        AUTOMATICALLY GIVEN THE EXTENSION .FGA (Formatted GAmh).
C***        THE OPTIONAL CHARACTER FILE FOR PLOTTING IS AUTOMATICALLY
C***        GIVEN THE EXTENSION .FGP (Formatted Gamh Plot).
C***
C***  MAJOR VARIABLES USED IN PROGRAM SS2DGAMH
C***     MAXN         MAXIMUM NO OF DATA POINTS ALLOWED.
C***                  IT IS CURRENTLY SET TO 5000.
C***     XE(MAXN)     ARRAY OF X-COORDINATES (EASTINGS)
C***     YN(MAXN)     ARRAY OF Y-COORDINATES (NORTHINGS)
C***     GD(MAXN)     ARRAY OF SAMPLE VALUES (ASSAY VALUES)
C***     IDATA(MAXN)  INDICATOR VARIABLE WHICH FLAGS THE SAMPLE POINTS
C***                  USED IN COMPUTING THE VARIOGRAM(S)
C***     XDIF         DIFFERENCE IN EAST COORDINATES BETWEEN TWO POINTS
C***     YDIF         DIFFERENCE IN NORTH COORDINATES   "     "    "
C***     Q            DIFFERENCE IN SAMPLE VALUES       "     "     "
C***     QSQR         Q SQUARED
C***     DIS          DISTANCE BETWEEN TWO SAMPLES
C***     DISQ         DIS TIMES Q SQUARED
C***                  NEXT NINE ARRAYS ARE DIMENSIONED (5,20)
C***     DISCUM(I,J)               CUMULATIVE DISTANCE FOR I-TH
C***                               DIRECTION, J-TH CLASS INTERVAL
C***     DIFCUM(I,J)               CUMULATIVE Q
C***     QSQCUM(I,J)               CUMULATIVE QSQR
C***     DDFCUM(I,J)               CUMULATIVE DISQ
C***     NUMCUM(I,J)               CUMULATIVE NUMBER OF SAMPLES
C***     AVGDIS(I,J)               AVERAGE DISTANCE BETWEEN SAMPLE
C***                               POINTS, I-TH DIRECTION, J-TH CLASS
C***                               INTERVAL.
C***     DRIFT (I,J)               "DRIFT" MEASURE
C***     GAMMAH(I,J)               GAMMA(H)
C***     CTRMNT(I,J)               MOMENT CENTER ESTIMATE OF GAMMA(H)
C***     GDBAR        MEAN VALUE OF SAMPLES
C***     VARI         VARIANCE OF SAMPLES
C***     IPT          DISK UNIT CONTAINING VARIOGRAM CONTROL FILE
C***     KI           DISK UNIT CONTAINING SAMPLE LOCATIONS AND ASSAYS
C***     IOUT         DISK UNIT FOR PRINTED OUTPUT OF VARIOGRAMS
C***     IPCH         DISK UNIT FOR GRAPHIC PLOTTING DATA
C**********************************************************************
C*** THE FOLLOWING STATEMENT IS INCLUDED TO REDUCE PROGRAM SIZE AND
C*** DECREASE EXECUTION TIME.  INTEGERS READ FROM PARAMETER FILE
C*** MUST BE INTEGER*2.
      INTEGER*4 NUMCUM
      LOGICAL FLAG
      CHARACTER*32 UNIT08,UNIT10,UNIT20,UNIT21
      CHARACTER*4 EXT,HEAD(20),IDSTP
      DOUBLE PRECISION SUM,SUM2
      COMMON /CHAR/ HEAD, IDSTP(4)
      common /dvctl/rang(5),rspr(5),logg,iipc,ill,iscali,inrel,indir,
     + cclas,ttmax,iisel,yymin,yymax,xxmin,xxmax
      COMMON /xsxs/XE(5000),YN(5000),GD(5000),
     1       NUMCUM(5,20),LOG,CLAS,DLIM,ANG(5),GDBAR,VARI,
     3       STD,N,IPC,LL,SPR(5),ISCAL,TMAX,NREL,IOUT,
     4       IPCH,MAXN,NDIR,ISEL,XMIN,XMAX,YMIN,YMAX,
     5       avgdis(5,20),gammah(5,20),ctrmnt(5,20),drift(5,20),
     +       idata(5000)
      DIMENSION dang(5),dspr(5),CST(5),SIT(5),CSPR(5)
      Dimension DISCUM(5,20),DIFCUM(5,20),QSQCUM(5,20),DDFCUM(5,20)
      EQUIVALENCE(GAMMAH(1,1),QSQCUM(1,1)),(CTRMNT(1,1),DDFCUM(1,1)),
     1           (AVGDIS(1,1),DISCUM(1,1))
      DATA EXT/'.FGP'/
      DATA IOK,IBAD/0,-1/
C***
C**********************************************************************
C
      MAXN=5000

C      rewind(ipt)
      rewind(ki)
      IOUT=25
      ICHFRG=IOUT
      IPCH=8
      DO 10 I=1,MAXN
      IDATA(I)=0
   10 CONTINUE
      DO 20 J=1,20
      DO 20 I=1,5
      DISCUM(I,J)=0.
      DIFCUM(I,J)=0.
      QSQCUM(I,J)=0.
      DDFCUM(I,J)=0.
      NUMCUM(I,J)=0
   20 CONTINUE
C***  OPEN INPUT AND OUTPUT FILES
      CALL ATTACH(KI,IPT,IOUT,UNIT10,UNIT20,UNIT21)
C***
C***  READ IDENTIFIER FOR VARIOGRAM RUN FROM CONTROL FILE
C      READ(IPT)HEAD
   30 FORMAT(19A4,A3)
C***  READ SELECTION OPTIONS FROM CONTROL FILE
       log=logg
       ipc=iipc
       ll=ill
       iscal=iscali
       nrel=inrel
       ndir=indir
       clas=cclas
       tmax=ttmax
C      READ(IPT)logg,IPC,LL,ISCAL,NREL,NDIR,CLAS,TMAX
   40 FORMAT (6(I1,1X),F12.3,1X,F15.5)
C***  READ DIRECTION AND ANGULAR DEVIATION RECORD(S) FROM CONTROL FILE.
C***  THERE MAY BE AS MANY AS FIVE OF THESE RECORDS.
   70 DO 90 I=1,NDIR
C      READ(IPT)ANG(I),SPR(I)
      ang(i)=rang(i)
      spr(i)=rspr(i)
   80 FORMAT(F6.2,5X,F6.2)
      DANG(I)=ANG(I)*1.7453292D-02
      CST(I)=COS(DANG(I))
      SIT(I)=SIN(DANG(I))
      DSPR(I)=SPR(I)*1.7453292D-02
      CSPR(I)=COS(DSPR(I))
   90 CONTINUE
      DLIM=20.*CLAS
      DLIM2=DLIM*DLIM
C***  READ COORDINATE SELECTION OPTION FROM CONTROL FILE.
C      READ(IPT)ISEL,YMIN,YMAX,XMIN,XMAX
       isel=iisel
       ymin=yymin
       ymax=yymax
       xmin=xxmin
       xmax=xxmax
  100 FORMAT(I1,1X,4(F12.3,1X))
C***  READ IN ASSAY DATA FROM STATPAC FILE.
      CALL RDN(ki,ier)
      write(*,*)
      IF (logg.NE.1) GO TO 130
      WRITE(*,110)
  110 FORMAT('       NOW TRANSFORMING ASSAY VALUES TO LOGARITHMS')
      DO 120 I=1,N
      GD(I)=ALOG(GD(I))
  120 CONTINUE
C***  CHECK TO SEE IF STATPAC INPUT FILE WAS PREPROCESSED.  IF IT
C***  WAS NOT PREPROCESSED, STOP EXECUTION OF PROGRAM.
  130 DO 140 I=2,N
      IF(YN(I).LT.YN(I-1)) THEN
      WRITE(*,*) 'INPUT FILE WAS NOT PREPROCESSED'
      ier=1
      return
      ENDIF
  140 CONTINUE
C***  BEGIN COMPUTATION OF VARIOGRAMS
C      WRITE(*,150)
  150 FORMAT('         NOW COMPUTING VARIOGRAM(S)')
      NM1=N-1
      DO 200 I=1,NM1
      Y1=YN(I)
      X1=XE(I)
      IP1=I+1
      DO 170 J=IP1,N
      Y2=YN(J)
      X2=XE(J)
      YDIF=Y1-Y2
      IF(ABS(YDIF).GT.DLIM) GO TO 180
      XDIF=X1-X2
      IF(ABS(XDIF).GT.DLIM) GO TO 170
      DIS2=YDIF*YDIF+XDIF*XDIF
      IF(DIS2.GT.DLIM2) GO TO 170
      DIS=SQRT(DIS2)
      IF(DIS.EQ.0.) GO TO 310
      Q=GD(I)-GD(J)
      QSQR=Q*Q
C***  COMPARE DIRECTION WITH ACCEPTABLE DIRECTIONS
      DO 160 L=1,NDIR
      DOT=(XDIF*CST(L)+YDIF*SIT(L))/DIS
      ADOT=ABS(DOT)
      IF(ADOT.LT.CSPR(L))GO TO 160
      K=DIS/CLAS+1
C***  KEEP TRACK OF DATA POINTS USED IN COMPUTING VARIOGRAMS
      IDATA(I)=1
      IDATA(J)=1
      Q=SIGN(Q,DOT)
      DISQ=DIS*QSQR
      DISCUM(L,K)=DISCUM(L,K)+DIS
      DIFCUM(L,K)=DIFCUM(L,K)+Q
      QSQCUM(L,K)=QSQCUM(L,K)+QSQR
      DDFCUM(L,K)=DDFCUM(L,K)+DISQ
      NUMCUM(L,K)=NUMCUM(L,K)+1
  160 CONTINUE
  170 CONTINUE
  180 WRITE(*,190) I
  190 FORMAT('+',' Computing Variogram(s) ',I4)
  200 CONTINUE
      WRITE(*,190) N
C      WRITE(*,210)
  210 FORMAT(/,'         NOW COMPUTING MEAN AND STANDARD DEVIATION')
C***  COMPUTE MEAN AND STANDARD DEVIATION OF SAMPLES.
      SUM=0.0
      SUM2=0.0
      IN=0
      DO 220 I=1,N
      IF(IDATA(I).NE.1)GO TO 220
      IN=IN+1
      SUM=SUM+GD(I)
      SUM2=SUM2+GD(I)*GD(I)
  220 CONTINUE
      N=IN
      GDBAR=SUM/FLOAT(N)
      IF (GDBAR.GE.1E+10) THEN
        WRITE (*,225) GDBAR
        GO TO 227
        ENDIF
  225 FORMAT (' ***Warning***',/,' Average z-value in this set is ',
     1         E10.3,/,' This is too large a value for meaningful ',
     2        ' computation of the standard deviation. ')
      VARI=(FLOAT(N)*SUM2-SUM*SUM)/(FLOAT(N)*FLOAT(N-1))
      STD=SQRT(VARI)
  227 REL=1./(GDBAR*GDBAR)
      DO 250 I=1,20
      DO 240 L=1,NDIR
      AN=FLOAT(NUMCUM(L,I))
      IF(AN.EQ.0.)GO TO 240
      DRIFT(L,I)=DIFCUM(L,I)/AN
C***  AS AN OPTION, COMPUTE RELATIVE VARIOGRMS
      IF(NREL.EQ.0)GO TO 230
      QSQCUM(L,I)=QSQCUM(L,I)*REL
      DDFCUM(L,I)=DDFCUM(L,I)*REL
  230 GAMMAH(L,I)=QSQCUM(L,I)/(2.*AN)
      IF(DDFCUM(L,I).EQ.0.) GO TO 240
      CTRMNT(L,I)=DDFCUM(L,I)/(DISCUM(L,I)*2.0)
      AVGDIS(L,I)=DISCUM(L,I)/AN
  240 CONTINUE
  250 CONTINUE
C***  WRITE OUT RESULTS OF VARIOGRAM TO DISK FILE
C      WRITE(*,260)
  260 FORMAT(9X,'NOW WRITING RESULTS ON OUTPUT FILE(S)')
      IF(LL.EQ.0) CALL VAROUT(GAMMAH)
      IF(LL.EQ.1) CALL VAROUT(CTRMNT)
C
C     WRITE 'NORMAL COMPLETION' CODE TO IPC FILE
C
      ier=0
      return
C
  310 WRITE(*,320) I,J
  320 FORMAT(' DUPLICATED LOCATIONS WERE DETECTED AT STATPAC ROWS ',I4,'
     1 AND ',I4,/,' THERE MAY BE OTHER DUPLICATES.  SEARCH FOR ALL DUPLI
     2CATES USING ',/,' PROGRAM PREPROC.  EXECUTION IS HALTED.')
      WRITE(*,*) 'ABNORMAL END OF PROGRAM'
      ier=1
      return
      END
