       SUBROUTINE  IDSFFT(MD,NCP,NDP,XD,YD,ZD,NXI,NYI,IWK,WK,
     1                   IER)
C
C THIS SUBROUTINE PERFORMS SMOOTH SURFACE FITTING WHEN THE PRO-
C JECTIONS OF THE DATA POINTS IN THE X-Y PLANE ARE IRREGULARLY
C DISTRIBUTED IN THE PLANE.
C THE INPUT PARAMETERS ARE
C     MD  = MODE OF COMPUTATION (MUST BE 1, 2, OR 3),
C         = 1 FOR NEW NCP AND/OR NEW XD-YD,
C         = 2 FOR OLD NCP, OLD XD-YD, NEW XI-YI,
C         = 3 FOR OLD NCP, OLD XD-YD, OLD XI-YI,
C     NCP = NUMBER OF ADDITIONAL DATA POINTS USED FOR ESTI-
C           MATING PARTIAL DERIVATIVES AT EACH DATA POINT
C           (MUST BE 2 OR GREATER, BUT SMALLER THAN NDP),
C     NDP = NUMBER OF DATA POINTS (MUST BE 4 OR GREATER),
C     XD  = ARRAY OF DIMENSION NDP CONTAINING THE X
C           COORDINATES OF THE DATA POINTS,
C     YD  = ARRAY OF DIMENSION NDP CONTAINING THE Y
C           COORDINATES OF THE DATA POINTS,
C     ZD  = ARRAY OF DIMENSION NDP CONTAINING THE Z
C           COORDINATES OF THE DATA POINTS,
C     NXI = NUMBER OF OUTPUT GRID POINTS IN THE X COORDINATE
C           (MUST BE 1 OR GREATER),
C     NYI = NUMBER OF OUTPUT GRID POINTS IN THE Y COORDINATE
C           (MUST BE 1 OR GREATER),
C     XI  = ARRAY OF DIMENSION NXI CONTAINING THE X
C           COORDINATES OF THE OUTPUT GRID POINTS,
C     YI  = ARRAY OF DIMENSION NYI CONTAINING THE Y
C           COORDINATES OF THE OUTPUT GRID POINTS.
C   (modification by GWH,10/25/85,eliminated XI and YI arrays; grid
C    point locations are calculated by calls to functions XI and YI)
C THE OUTPUT PARAMETER IS
C     ZI  = DOUBLY-DIMENSIONED ARRAY OF DIMENSION (NXI,NYI),
C           WHERE THE INTERPOLATED Z VALUES AT THE OUTPUT
C           GRID POINTS ARE TO BE STORED.
C  (modification by GWH, 11/13/85, eliminated this array; output data
C   is stored on disk file connected to unit IZFIL).
C THE OTHER PARAMETERS ARE
C     IWK = INTEGER ARRAY OF DIMENSION
C              MAX0(31,27+NCP)*NDP+NXI*NYI
C           USED INTERNALLY AS A WORK AREA,
C  (modification by GWH, 11/13/85, reduced this dimension by NXI*NYI;
C  this data is stored on disk file connected to unit ICHIGP)
C     WK  = ARRAY OF DIMENSION 5*NDP USED INTERNALLY AS A
C           WORK AREA.
C THE VERY FIRST CALL TO THIS SUBROUTINE AND THE CALL WITH A NEW
C NCP VALUE, A NEW NDP VALUE, AND/OR NEW CONTENTS OF THE XD AND
C YD ARRAYS MUST BE MADE WITH MD=1.  THE CALL WITH MD=2 MUST BE
C PRECEDED BY ANOTHER CALL WITH THE SAME NCP AND NDP VALUES AND
C WITH THE SAME CONTENTS OF THE XD AND YD ARRAYS.  THE CALL WITH
C MD=3 MUST BE PRECEDED BY ANOTHER CALL WITH THE SAME NCP, NDP,
C NXI, AND NYI VALUES AND WITH THE SAME CONTENTS OF THE XD, YD,
C XI, AND YI ARRAYS.  BETWEEN THE CALL WITH MD=2 OR MD=3 AND ITS
C PRECEDING CALL, THE IWK AND WK ARRAYS MUST NOT BE DISTURBED.
C USE OF A VALUE BETWEEN 3 AND 5 (INCLUSIVE) FOR NCP IS RECOM-
C MENDED UNLESS THERE ARE EVIDENCES THAT DICTATE OTHERWISE.
C THE LUN CONSTANT IN THE DATA INITIALIZATION STATEMENT IS THE
C LOGICAL UNIT NUMBER OF THE STANDARD OUTPUT UNIT AND IS,
C THEREFORE, SYSTEM DEPENDENT.
C Modification by GWH on 11/26/85 used system dependent type
C INTEGER*2 to reduce storage space required for array IWK.
C THIS SUBROUTINE CALLS THE IDCLDP, IDGRID, IDPDRV, IDPTIP, AND
C IDTANG SUBROUTINES.
C DECLARATION STATEMENTS
C
C   The following line is included to make this code
C   immune to the /INTEGER= compiler switch on DG
      IMPLICIT INTEGER*4 (I-N)
C.........original code by Akima:.......
C     DIMENSION   XD(100),YD(100),ZD(100),XI(101),YI(101),
C    1            ZI(10201),IWK(13301),WK(500)
C.........modification by GWH, 10/21/85 and 11/13/85

$large 
      REAL      XD(500),YD(500),ZD(500),WK(2500)
      INTEGER*2   IWK(18500)
      COMMON/VARRAY/IZFIL,ICHIGP
      COMMON/GRIDPTS/XMIN,XSIDE,YMAX,YSIDE
C.........end modification..............
C
C.........Akima's revision to bring program to ANSI standard
      COMMON/IDPI/ITPV,X0,Y0,AP,BP,CP,DP,
     1           P00,P10,P20,P30,P40,P50,P01,P11,P21,P31,P41,
     2           P02,P12,P22,P32,P03,P13,P23,P04,P14,P05
C.........end revision.......................................
C
C SETTING OF SOME INPUT PARAMETERS TO LOCAL VARIABLES.
C (FOR MD=1,2,3)
      ier=1
   10 MD0=MD
      NCP0=NCP
      NDP0=NDP
      NXI0=NXI
      NYI0=NYI
C ERROR CHECK.  (FOR MD=1,2,3)
   20 IF(MD0.LT.1.OR.MD0.GT.3)           GO TO 90
      IF(NCP0.LT.2.OR.NCP0.GE.NDP0)      GO TO 90
      IF(NDP0.LT.4)                      GO TO 90
      IF(NXI0.LT.1.OR.NYI0.LT.1)         GO TO 90
      IF(MD0.GE.2)        GO TO 21
      IWK(1)=NCP0
      IWK(2)=NDP0
      GO TO 22
   21 NCPPV=IWK(1)
      NDPPV=IWK(2)
      IF(NCP0.NE.NCPPV)   GO TO 90
      IF(NDP0.NE.NDPPV)   GO TO 90
   22 IF(MD0.GE.3)        GO TO 23
      IWK(3)=NXI0
      IWK(4)=NYI0
      GO TO 30
   23 NXIPV=IWK(3)
      NYIPV=IWK(4)
      IF(NXI0.NE.NXIPV)   GO TO 90
      IF(NYI0.NE.NYIPV)   GO TO 90
C ALLOCATION OF STORAGE AREAS IN THE IWK ARRAY.  (FOR MD=1,2,3)
   30 JWIPT=16
      JWIWL=6*NDP0+1
      JWNGP0=JWIWL-1
      JWIPL=24*NDP0+1
      JWIWP=30*NDP0+1
      JWIPC=27*NDP0+1
C.........original code by Akima:.......
      JWIGP0=MAX0(31,27+NCP0)*NDP0
C.........modification by GWH, 11/13/85:
      JWIGP0=0
C.........end modification..............
C
C TRIANGULATES THE X-Y PLANE.  (FOR MD=1)
   40 IF(MD0.GT.1)   GO TO 50
      CALL IDTANG(NDP0,XD,YD,NT,IWK(JWIPT),NL,IWK(JWIPL),
     1            IWK(JWIWL),IWK(JWIWP),WK)
      IF(NT.EQ.0)    RETURN
      IWK(5)=NT
      IWK(6)=NL
C DETERMINES NCP POINTS CLOSEST TO EACH DATA POINT.  (FOR MD=1)
   50 IF(MD0.GT.1)   GO TO 60
      CALL IDCLDP(NDP0,XD,YD,NCP0,IWK(JWIPC))
      IF(IWK(JWIPC).EQ.0)      RETURN
C SORTS OUTPUT GRID POINTS IN ASCENDING ORDER OF THE TRIANGLE
C NUMBER AND THE BORDER LINE SEGMENT NUMBER.  (FOR MD=1,2)
   60 IF(MD0.EQ.3)   GO TO 70
C.........original code by Akima:.......
C     CALL IDGRID(XD,YD,NT,IWK(JWIPT),NL,IWK(JWIPL),NXI0,NYI0,
C    1            XI,YI,IWK(JWNGP0+1),IWK(JWIGP0+1))
C.........modification by GWH, 10/21/85 and 11/13/85:
      WRITE (*,69)
   69 FORMAT (7X,'SORTING GRID CELLS BY TRIANGLE')
      CALL IDGRID(XD,YD,NT,IWK(JWIPT),NL,IWK(JWIPL),NXI0,NYI0,
     1                  IWK(JWNGP0+1))
C.........end modification..............
C
C ESTIMATES PARTIAL DERIVATIVES AT ALL DATA POINTS.
C (FOR MD=1,2,3)
   70 CALL IDPDRV(NDP0,XD,YD,ZD,NCP0,IWK(JWIPC),WK)
C INTERPOLATES THE ZI VALUES.  (FOR MD=1,2,3)
   80 ITPV=0
      JIG0MX=0
      JIG1MN=NXI0*NYI0+1
      NNGP=NT+2*NL
      KOUNT=0
      DO 89  JNGP=1,NNGP
        ITI=JNGP
        IF(JNGP.LE.NT)    GO TO 81
        IL1=(JNGP-NT+1)/2
        IL2=(JNGP-NT+2)/2
        IF(IL2.GT.NL)     IL2=1
        ITI=JFIX(IL1*(NT+NL)+IL2)
   81   JWNGP=JWNGP0+JNGP
        NGP0=IWK(JWNGP)
        IF(NGP0.EQ.0)     GO TO 86
        JIG0MN=JIG0MX+1
        JIG0MX=JIG0MX+NGP0
        DO 82  JIGP=JIG0MN,JIG0MX
          JWIGP=JWIGP0+JIGP
C.........original code by Akima:.......
C         IZI=IWK(JWIGP)
C.........modification by GWH, 11/13/85:
          READ (ICHIGP,REC=JWIGP) IZI
CWRITE(*,*) ' IDSFFT:  IZI',IZI
C.........end modification..............
C
          IYI=(IZI-1)/NXI0+1
          IXI=IZI-NXI0*(IYI-1)
CWRITE(*,*) ' IDSFFT:  IXI,IYI',XI(IXI),YI(IYI)
C.....Original code by Akima:
C         CALL IDPTIP(XD,YD,ZD,NT,IWK(JWIPT),NL,IWK(JWIPL),WK,
C    1                ITI,XI(IXI),YI(IYI),ZI(IZI))
C.....Modification by GWH, 10/24/85:
          CALL IDPTIP(XD,YD,ZD,NT,IWK(JWIPT),NL,IWK(JWIPL),WK,
     1                ITI,XI(IXI),YI(IYI),ZII)
          KOUNT = KOUNT + 1
          IF ((KOUNT/10)*10.EQ.KOUNT) WRITE (*,83) KOUNT,ZII
   83     FORMAT ('+',I5, ' NOW CALCULATING GRID CELL VALUES ',F15.2)
          WRITE (IZFIL,REC=IZI) ZII
C.....end modification..............
C
   82   CONTINUE
   86   JWNGP=JWNGP0+2*NNGP+1-JNGP
        NGP1=IWK(JWNGP)
        IF(NGP1.EQ.0)     GO TO 89
        JIG1MX=JIG1MN-1
        JIG1MN=JIG1MN-NGP1
        DO 87  JIGP=JIG1MN,JIG1MX
          JWIGP=JWIGP0+JIGP
C.........original code by Akima:.......
C         IZI=IWK(JWIGP)
C.........modification by GWH, 11/13/85:
          READ (ICHIGP,REC=JWIGP) IZI
C.........end modification..............
C
          IYI=(IZI-1)/NXI0+1
          IXI=IZI-NXI0*(IYI-1)
C.........original code by Akima:.......
C         CALL IDPTIP(XD,YD,ZD,NT,IWK(JWIPT),NL,IWK(JWIPL),WK,
C    1                ITI,XI(IXI),YI(IYI),ZI(IZI))
C.........modification by GWH, 10/21/85:
          CALL IDPTIP(XD,YD,ZD,NT,IWK(JWIPT),NL,IWK(JWIPL),WK,
     1                ITI,XI(IXI),YI(IYI),ZII)
          KOUNT = KOUNT + 1
          IF ((KOUNT/10)*10.EQ.KOUNT) WRITE (*,83) KOUNT
          WRITE (IZFIL,REC=IZI) ZII
C.........end modification..............
C
   87   CONTINUE
   89 CONTINUE
      WRITE (*,83) KOUNT
      WRITE (*,'(1X)')
      IER = 0
      RETURN
C ERROR EXIT
   90 WRITE (*,2090) MD0,NCP0,NDP0,NXI0,NYI0
      RETURN
C FORMAT STATEMENT FOR ERROR MESSAGE
 2090 FORMAT(1X/41H ***   IMPROPER INPUT PARAMETER VALUE(S)./
     1   7H   MD =,I4,10X,5HNCP =,I6,10X,5HNDP =,I6,
     2   10X,5HNXI =,I6,10X,5HNYI =,I6/
     3   35H ERROR DETECTED IN ROUTINE   IDSFFT/)
      END
