C******************************************************************************
C
C     NAME:         SUBROUTINE HSYMB
C
C     FUNCTION:     PRODUCES VECTOR REPRESENTATIONS OF CHARACTERS FROM
C                   DIFFERENT FONTS AT ANY ANGLE AND IN ANY SIZE.
C                   REPRESENTATIONS CAN BE PRODUCED ON ANY DEVICE IF
C                   THE USER PROVIDES THE APPROPRIATE DEVICE SPECIFIC
C                   MOVE AND DRAW ROUTINES IN THE ROUTINE - PLOTDV.
C
C                   FONTS AVAILABLE:
C                     01 - CARTOGRAPHIC SIMPLEX       15 - ROMAN DUPLEX SANS-SERIF
C                     02 - SPECIAL SIMPLEX            16 - ROMAN TRIPLEX SERIF
C                     03 - SPECIAL SIMPLEX            23 - ITALIC COMPLEX
C                     04 - SPECIAL COMPLEX            24 - ITALIC SMALL COMPLEX
C                     05 - SPECIAL COMPLEX            26 - ITALIC TRIPLEX
C                     06 - SPECIAL SMALL COMPLEX      32 - SCRIPT SIMPLEX
C                     11 - CARTOGRAPHIC SIMPLEX SANS  33 - SCRIPT COMPLEX
C                     12 - ROMAN SIMPLEX SANS-SERIF   51 - GOTHIC GERMAN
C                     13 - ROMAN COMPLEX SERIF        52 - GOTHIC ENGLISH
C                     14 - ROMAN SMALL COMPLEX SERIF  53 - GOTHIC ITALIAN
C
C                   THERE ARE THREE TYPES OF CALLS FOR THE ROUTINE:
C                   1.INITIALIZATION - OPEN THE FONT FILE...NFONT IS NEGATIVE
C                       OPEN A CHANNEL TO THE FONT FILE NAMED IN ARRAY ITEXT.
C                       THE CHANNEL NUMBER USED IS THE ABSOLUTE VAULE OF NFONT.
C                       THE VALUE OF IDVC IS THE OUTPUT FILE FOR ERROR MESSAGES
C                   2.PLOTTING - PLOT CHARACTER(S)...NFONT IS POSITIVE
C                       PLOT THE CHARACTER(S) USING FONT NUMBER 'NFONT'
C                       THERE ARE TWO HSYMB CALL FORMATS:
C                        1) THE 'STANDARD' CALL FOR TITLES,LEGENDS,CAPTIONS,ETC
C                        2) THE 'SPECIAL' CALL FOR CENTERED SYMBOLS(NCHAR<= -1).
C                       BOTH FORMS OF THE SYMBOL CALL HAVE TEN ARGUMENTS.
C                       THE CHARACTER REPRESENTATIONS THAT CAN BE PRODUCED ARE
C                       PRIMARILY THOSE DIGITIZED BY DR. A. V. HERSHEY.
C                   3.TERMINATION - CLOSE THE FONT FILE...NFONT EQUALS -999
C                       CLOSE THE CHANNEL TO THE FONT FILE
C
C     PARAMETERS:
C                   IDVC      I*2      INPUT
C                   THE DEVICE CODE THAT IS SENT TO ROUTINE PLOTDV
C                   WHEN INITIALIZING IDVC IS THE ERROR MESSAGE OUTPUT CHANNEL
C
C                   NFONT     I*2      INPUT
C                   THE FONT NUMBER TO SELECT AND THE INITIALIZATION & STOP.
C                   (SEE THE THREE TYPES OF CALLS DESCRIBED ABOVE.)
C
C                   XLOC      R*4      INPUT
C                   THE X(ORDINATE) LOCATION TO BEGIN PLOTTING.
C                   FOR THE 'SPECIAL' CALL THE X CENTER OF THE SYMBOL.
C                   IF XLOC = 999. THEN PLOTTING CONTINUES FROM LAST Y LOCATION
C
C                   YLOC      R*4      INPUT
C                   THE Y(ABSISSA)  LOCATION TO BEGIN PLOTTING.
C                   FOR THE 'SPECIAL' CALL THE Y CENTER OF THE SYMBOL.
C                   IF YLOC = 999. THEN PLOTTING CONTINUES FROM LAST Y LOCATION
C
C                   XHGT      R*4      INPUT
C                   THE X HEIGHT OF THE CHARACTER(S)
C
C                   YHGT      R*4      INPUT
C                   THE Y HEIGHT OF THE CHARACTER(S)
C
C                   ITEXT     I*2      INPUT
C                   THE TEXT IN PACKED FORMAT(MAX # OF CHARS A WORD) TO BE PLOTTED.
C                   IF THE CALL IS THE SPECIAL CALL TEXT(1) IS THE INTEGER
C                   EQUIVALENT OF THE DESIRED SYMBOL(0-127)
C
C                   ANG       R*4      INPUT
C                   ANGLE IN DEGREES FROM THE X-AXIS AT WHICH THE CHARACTER
C                   STRING IS TO BE PLOTTED.  IF ANG = 0.0  THE STRING IS
C                   PLOTTED RIGHT SIDE UP AND PARRELLEL TO THE X-AXIS.
C
C                   EXP       R*4      INPUT
C                   EXPANSION FACTOR (SPACE INBETWEEN CHARACTERS).
C
C                   ROTATE    R*4      INPUT
C                   ANGLE IN DEGREES FROM THE X-AXIS AT WHICH THE INDIVIDUAL
C                   CHARACTER(S) ARE TO BE PLOTTED.
C
C                   IALIG     I*2      INPUT
C                   ALIGMENT CODE. ALIGMENT CODE RANGE IS 0 - 8.
C                   0-LOWER LEFT    3-CENTER LEFT      6-UPPER LEFT
C                   1-LOWER CENTER  4-CENTER CENTER    7-UPPER CENTER
C                   2-LOWER RIGHT   5-CENTER RIGHT     8-UPPER RIGHT
C
C                   NCHAR     I*2      INPUT
C                   NUMBER OF CHARACTERS TO BE PLOTTED.
C                   NCHAR >0  PACKED TEXT  NUMBER OF CHARACTERS TO PLOT
C                   NCHAR =0  PLOT SINGLE CHARACTER RIGHT JUSTIFIED IN ITEXT(1)
C                   NCHAR =-1  MOVE TO XL,YL WITH TOOL UP TO
C                              PLOT CENTERED SYMBOL # ITEXT(1)
C                   NCHAR <-1  MOVE TO XL,YL WITH TOOL DOWN TO
C                              PLOT CENTERED SYMBOL # ITEXT(1)
C
C                   IER       I*2      OUTPUT
C                   THE RETURNED ERROR PARAMETER SET TO ONE NO ERRORS
C                   IER = -50  ILLEGAL OPEN
C                   IER = -56  ILLEGAL FONT
C
C
C     PROGRAMMER:   RANDY FROSH (USFWS WELUT) 31-JAN-81
C
C     REQUIRED:     COMMONS:  HHEAD,HFONT,HCUR
C                   ROUTINES: BYTE,PLOTDV,OPENF,RDBLK,CLOSEF,HSYPOS
C                   FILES:    A FONT FILE WITH LENGTH 'KLEN'
C
C     REFERENCES:   A CONTRIBUTION TO COMPUTER TYPESETTING TECHNIQUES:
C                   TABLES OF COORDINATES FOR HERSHEY'S REPERTORY OF
C                   OCCIDENTAL TYPE FONTS AD GRAPHIC SYMBOLS,
C                   NORMAN M WOLCOTT & JOSEPH HILSENRATH,
C                   U.S. DEPARTMENT OF COMMERCE/NATIONAL BUREAU OF STANDARDS,
C     REVISIONS:
C
C*****************************************************************************
       SUBROUTINE HSYMB(IDVC,NFONT,XLOC,YLOC,XHGT,YHGT,ITEXT,ROTATE,
     +      EXP,ANG,IALIG,NCHAR,IER)
C
C**     MACHINE DEPENDENT FEATURES.  SET FOR 16 BIT 2 BYTE WORDS
C**     SET RECORD LENGTH,BYTES PER WORD,ARRAY DIMENSIONS
C**     KDIM NEEDS TO BE SET TO THE RECORD LENGTH DIVIDED BY THE BYTES PER WORD
C**     KFONTS IS THE MAX ALLOWABLE NUMBER OF FONTS & CHARACTERS IN EACH FONT
C
       PARAMETER (KLEN = 256, KBYTE = 2, KDIM = 128, KFONTS = 128)
C
       COMMON /HHEAD/ IHEAD(128)
       COMMON /HFONT/ IFONT(128),XFO,YFO,XFSCL,YFSCL,IFRST
       COMMON /HCURR/ ICHAN,IFNUM,IRCUR,ICBUF(128),XL,YL
C
       character ifontfil*25
       DIMENSION ITEXT(160),ITRAN(8),WIND(4),iwrk(25),ihold(2)
       EQUIVALENCE (ITRAN(1),XFO),(ifontfil,iwrk)
       logical iok
C       DATA IFNUM/-32767/, SMVAL / .00001 /
C
C**     DETERMINE IF IT'S A REGULAR CALL
C
       IF (NFONT .GE. 0) GO TO 1000
C
C**     IF IT'S THE FIRST CALL...OPEN THE CHANNEL TO THE FONT FILE
C
       IF (NFONT .EQ. -999) GO TO 400
C       IF(IFNUM .NE. -32767) GO TO 85000
       ICHAN = 55
       ifontfil='\gis\intrface\fonts.dt'
       CALL OPENF(ICHAN,iwrk,1,KLEN,2,IER)
       IF (IER .NE. 0) GO TO 85020
       IRCUR = 1
       CALL RDBLK(ICHAN,IRCUR,ICBUF,1,IER)
       IF (IER .NE. 0) GO TO 85040
C
C**     LOAD THE FONT FILE HEADER INDEX INTO COMMON
C**     FILL WITH RECORD POINTERS TO FONT HEADERS
C**     1 -     TOTAL # OF RECORDS      2 -    NUMBER OF HEADER RECORDS
C**     3 -     NUMBER OF FONTS LOADED  4-127  RESERVED
C**     128-256 POINTER TO RECORD OF FONT #...ZERO IF FONT NOT LOADED
C
         kkfonts=icbuf(3)
         DO 220 I = 1,121
           IHEAD(I) = ICBUF(I+3)
220      CONTINUE
       IFNUM = 0
       GO TO 90000
C
C**     FINAL CALL...CLOSE THE FILE & EXIT
C
400    CLOSE(ICHAN,iostat=IER)
       IFNUM = -32767
       GO TO 90000
C
C**     SAME FONT OR DIFFERENT ONE ?...IF DIFF READ HEADER & SET CURRENT FONT
C
1000   IF (NFONT.EQ.0) GO TO 1002
       IF (NFONT .EQ. IFNUM) GO TO 1200
       IF (NFONT .LT. 0  .OR.  NFONT .GT. 127) GO TO 85060
       IF (NFONT .NE. 0) GO TO 1001
C
C**     NFONT = 0 - USE HARDWARE CHARACTER SET
C
C1002   CALL SYMBOL(XLOC,YLOC,XHGT,ITEXT,ANG,NCHAR)
       GO TO 90000
C
1002   go to 90000
1001   CONTINUE
       IRCUR = IHEAD(NFONT)
       IF (IRCUR .EQ. 0) GO TO 85060
       CALL RDBLK(ICHAN,IRCUR,ICBUF,1,IER)
       IF (IER .NE. 0) GO TO 85040
       IFNUM = NFONT
C
C**     LOAD THE HEADER FOR THE NEWLY SELECTED FONT INTO COMMON
C**     1 -      RECORD # OF FIRST COORD REC          2 - 3  X OFFSET
C**     3 - 4    Y OFFSET   5 - 6      X MAPPED ON    7 - 8  Y MAPPED ON
C**     9 - 127  RESERVED   128 - 256  FIRST WORD OF CHAR...ZERO IF NOT THERE
C
         IFRST = ICBUF(1)
         DO 1020 I = 1,8
           ITRAN(I) = ICBUF(I+2)
1020     CONTINUE
C headr now has two records
C
         ircur=ircur+1
         call rdblk(ichan,ircur,icbuf,1,ier)
         if(ier.ne.0)go to 85040
         DO 1040 I = 1,KFONTS
           IFONT(I) = ICBUF(I)
1040     CONTINUE
C
C**     MOVE INPUT VALES TO PARAMETERS & SET UP TOOL UP
C
1200   IF ( ABS(XLOC-999.).GT.SMVAL ) XL = XLOC
       IF ( ABS(YLOC-999.).GT.SMVAL ) YL = YLOC
       IF ( ABS(XFSCL).LT.SMVAL ) THEN
          XH = 0.
       ELSE
          XH = XHGT / XFSCL
       END IF
       IF ( ABS(YFSCL).LT.SMVAL ) THEN
          YH = 0.
       ELSE
          YH = YHGT / YFSCL
       END IF
       COSA  = COS(ANG * .01745329)
       SINA  = SIN(ANG * .01745329)
       COSR = COS(ROTATE * .01745329)
       SINR = SIN(ROTATE * .01745329)
       IKNT  = NCHAR
       ITOOL = 3
       ICENT = 0
C
C**     CENTERED SYMBOL OR PACKED (KBYTES PER WORD) TEXT STRING ?
C
       IF (NCHAR .GT. -1) GO TO 1400
       IKNT  = 1
       ICENT = 1
       IF (NCHAR .LT. -1) ITOOL = 2
C       CALL BYTSET(ITEXT(1),1,BYTE(ITEXT(1),2))
       XEXP = 0.0
       YEXP = 0.0
       GO TO 2000
C
C**     TEXT STRING...SET XEXP AND YEXP...CALL HSYPOS IF IALIG IS NOT 0...
C**     IF SINGLE CHARACTER MAKE SURE IT'S LEFT JUSTIFIED
C
1400   XEXP = EXP * COSA
       YEXP = EXP * SINA
       IF(IALIG.EQ.0)GO TO 1450
       CALL HSYPOS(10,NFONT,XLOC,YLOC,XHGT,YHGT,ITEXT,ROTATE,
     +                          EXP,ANG,IALIG,NCHAR,XNEW,YNEW,WIND,IER)
       IF(IER.NE.0)GO TO 85080
       XL = XNEW
       YL = YNEW
1450   IF (IKNT .GT. 1) GO TO 2000
       IKNT = 1
C       IF (BYTE(ITEXT(1),1) .EQ. 0)
C     +     CALL BYTSET(ITEXT(1),1,BYTE(ITEXT(1),2))
C
C**     M A I N  L O O P
C**     PROCESSES FROM ONE TO NUMBER OF CHARACTERS...TOOL UP BETWEEN CHARACTERS
C
2000   if(iknt.gt.1)call unpack(itext,160)
       DO 8020 IK = 1,IKNT
         ICHAR9 = ITEXT(IK)
         ISTRT = IFONT(ICHAR9+1)
C
C**     CHARACTER SPECIFIED NOT IN THE FONT ?
C
         IF (ISTRT .NE. 0) GO TO 2200
         XL = XL + (XHGT * COSA)
         YL = YL + (YHGT * SINA)
         GO TO 8000
C
C**     DIFFERENT RECORD FOR COORDINATES OR THE SAME ONE ?
C
2200     IIRCUR = IABS(ISTRT)/KDIM + IFRST
         IF (IIRCUR .EQ. IRCUR) GO TO 2400
         IRCUR = IIRCUR
         CALL RDBLK(ICHAN,IRCUR,ICBUF,1,IER)
         IF (IER .NE. 0) GO TO 85040
C
C**     GET START & STOP FOR THIS CHARACTER
C
2400     ICBKNT = MOD(IABS(ISTRT),KDIM)
         if(icbknt.eq.0)icbknt=1
         NTPTS  = IABS(ICBUF(ICBKNT))
         IF ( NTPTS.LT.1 ) GO TO 85090
         ICBKNT = ICBKNT + 1
         call byteit(icbuf(icbknt),ihold)
         XPOS = ISIGN(ihold(1),ISTRT)
         YPOS = ISIGN(ihold(2),ICBUF(ICBKNT-1))
         IF (ICENT .NE. 1) XPOS = 0.0
         IF (ICENT .NE. 1) YPOS = 0.0
         NPTS = 0
C
C**     EXTRACT COORDINATES LOOP
C
3000       NPTS = NPTS + 1
           IF (NPTS .GT. NTPTS) GO TO 6000
           ICBKNT = ICBKNT + 1
           IF(ICBKNT .LE. 128) GO TO 3600
           ICBKNT = 1
           IRCUR = IRCUR + 1
           CALL RDBLK(ICHAN,IRCUR,ICBUF,1,IER)
           IF (IER .NE. 0) GO TO 85040
C
C**     GET COORDINATES THEN OFFSET,SCALE,PATH,ROTATE AND PUT TO DEVICE
C
3600         call byteit(icbuf(icbknt),ihold)
             IX = ihold(1)
             IY = ihold(2)
             IF (IX .EQ. 0  .AND.  IY .EQ. 0) ITOOL =  3
             IF (IX .EQ. 0  .AND.  IY .EQ. 0) GO TO 3000
C**  OFFSET,SCALE
               X = ( (IABS(IX) - XFO - XPOS) * XH)
               Y = ( (     IY  - YFO - YPOS) * YH)
C**  PATH
               XP = ( X * COSA - Y * SINA ) + XL
               YP = ( X * SINA + Y * COSA ) + YL
C**  ROTATE
               XP = XP - ( Y * SINR )
               IF ( ( ABS(ANG- 90.0).LT.SMVAL ) .OR.
     +              ( ABS(ANG-270.0).LT.SMVAL ) )
     +             YP = YP - ( Y * SINR )
C**  PLOT
             CALL PENDV(XP,YP,ITOOL,IDVC)
C**
             ITOOL = 2
           GO TO 3000
C
C**     MOVE TO BEGINNING OF NEXT CHARACTER
C
6000   CONTINUE
       XL = XL + (XP-XL) + XEXP
       YL = YL + (YP-YL) + YEXP
       X = XL
       Y = YL
8000   ITOOL = 3
8020   CONTINUE
       GO TO 90000
C
C**     ERROR RETURNS
C
85000  IER = -50
       WRITE(*,98500) NFONT,IER
98500  FORMAT(' *HSYMB*  ILLEGAL FONT OPEN PARAMTER',I5,' ERROR',I5)
       GO TO 90000
85020  CONTINUE
       WRITE(*,98502) (ITEXT(I),I=1,5),IER
98502  FORMAT(' *HSYMB*  ERROR ON OPEN OF ',5A2,' ERROR',I5)
       GO TO 90000
85040  CONTINUE
       WRITE(*,98504) IREC,IER
98504  FORMAT(' *HSYMB*  ERROR READING REC #',I6,' ERROR',I5)
       GO TO 90000
85060  IER = -56
       WRITE(*,98506) NFONT,IER
98506  FORMAT(' *HSYMB*  FONT NUMBER',I5,' ILLEGAL  ERROR',I5)
       GO TO 90000
85080  WRITE(*,98508)IER
98508  FORMAT(' *HSYMB*  ERROR FROM HSYPOS   ERROR ',I5)
       GO TO 90000
85090  WRITE(*,98509) NFONT, NTPTS, IRCUR
98509  FORMAT(' *HSYMB*  ERROR - FONT ',I3,' HAS ',I6,
     +        ' POINTS, REC = ',I6)
C
C**     JUMP OUT
C
90000  RETURN
       END
