C***************************************************************************
C
C        P R O G R A M    G R I D
C
C  FUNCTION - LOGICAL DRIVER FOR POINT (X,Y,Z) TO GRID
C             MATRIX(N,M) INTERPOLATION.
C
C  LOGICAL CHANNEL NUMBERS
C
C      IOIN   = LOGICAL UNIT TERMINAL INPUT
C      NPRNT  = LOGICAL UNIT TERMINAL OUTPUT
C      IUNIT  = LOGICAL UNIT GRAPHICS INPUT/OUTPUT
C      ICHAN1 = LOGICAL UNIT FOR INPUT POINT SAMPLE MAP
C      ICHAN5 = LOGICAL UNIT FOR .HD FILE FOR NEW MAP
C      ICHOUT = LOGICAL UNIT FOR .CL FILE FOR NEW MAP
C      ICHF   = LOGICAL UNIT FOR INPUT FAULT LINE MAP
C      ICHAT  = LOGICAL UNIT FOR .AT FILE
C      ICHRCZ = LOGICAL UNIT X,Y,ELEVATION DISK ARRAY
C
C******************************************************************************
C
C
$INCLUDE : 'DBCHAN.INC'
$include : 'dnames.inc'
       COMMON /MFAST/  IFBUFF(256),INCORE,IWRTN,IFCHAN
       COMMON /IO/     NPRNT,IOIN
       COMMON /FLS/    IUNIT,IFILE(5)
       COMMON /WORK/   IBUFF(128),MAP(25),ICOM(10),JCOM(10)
       COMMON /TYPE/   IDATYP(40),NACTS
       COMMON /STRNG/  ICARD(80),ICARDP,LENICD
       COMMON /WHMAP/  ISTRCT(300),NSTRCT
       COMMON /ATTFET/ KAT(86),LBAT
       COMMON /RELTN/  JELTN(50,4), NPOINT(64), NFLAG, NPTS1
       COMMON /GWINDO/ INBAND(300)
       COMMON /UNIT/   ICHAT,ATRBTE,POLYGON,ADRESS
       COMMON /DSBUF/  MLEN,IDATA(8192)
       COMMON /FLTDAT/ FMAPID,ICHF,ISTRT,ISTP,NTOT,IFDAT(2,64)
       COMMON /WINDOW/ WIND(4)
       common /varray/izfil,ichigp
       common /gridpts/ xmin,xside,ymax,yside
C
       integer*4 NNRC
       INTEGER*2   LABEL(16),IHEAD(256),mapname(25),
     +             ITNAM(4),IX,IY,ATRBTE,POLYGON,ADRESS,FMAPID,FIDTYPE,
     +             DESCB(6),IBLNK
       INTEGER*2   NPRNT,IOIN,ICHAN1,ICHAN2,ICHAN5,ICHAT,ICHERR,
     +          ICHPAR,ICHM,ICHOUT,IXFIL,IYFIL,IZFIL,MAPID,IDTYPE,
     +     IATYP,LOCATE,MWORDS,MTYP,MASKM(10),IBW,LEN,MAXR,MAXC
       REAL        AWIND(4)
       LOGICAL     MCOMP,FOUND
       EQUIVALENCE (IHEAD(68),AWIND(1)),(IHEAD(80),YYSIDE),
     +             (IHEAD(82),XXSIDE),(IHEAD(88),ZMIN),(IHEAD(90),ZMAX)
C     +             (IHEAD(185),NBITS),(INBAND(185),ITMP)
C      DATA ITNAM/2HTE,2HMP,0,0/
C
      IER = 0
c
      ITNAM(1)=2HTE
      ITNAM(2)=2HMP
      ITNAM(3)=0
      ITNAM(4)=0
c
c
      IX = 0
      IY = 0
      IX=1HX
      IY=1HY
      IBLNK= 8224
      LINES = 1
      IPRMT = 0
      ICHAN1 = 21
      ICHAN2 = 22
      ICHOUT = 24
      ICHAN5 = 25
      ICHERR = 13
      ICHRCZ = 14
      ICHPAR = 14
      ICHSTP = 14
      ICHKPR = 14
      IFchan = 15
      ICHM   = 16
      ICHF   = 19
      ICHAT  = 26
      IXFIL  = 58
      ICHOUT2= 59
      ICHV1  = 59
      IYFIL  = 59
      ICHV2  = 60
      IZFIL  = 60
C.....DSBUF ALLOCATION
C.......INITIALLY
C         4096->POINT FILE         : 4096->CELL,X,Y,Z FILE
C.......FINALLY, EITHER OF FOLLOWING:
C         6144->CELL,X,Y,Z FILE    : 1024->MASK FILE : 1024->NEWMAP.CC FILE
C.......OR
C         7168->CELL,X,Y,Z FILE    : 1024->NEWMAP.CC FILE
       MLEN = 8192
C
C.....LOAD COMMON
       CALL initl(IER)
       IF(IER .NE. 0) GO TO 9999
C
C.....OPEN CHANNEL TO POINTER FILE
c      CALL openf(icdcfa,idesfa,1,512,2,IER)
c      IF(IER .NE. 0) GO TO 85020
C
C.....GET THE WINDOW
      CALL WHWND(WIND(1),WIND(3),WIND(2),WIND(4))
      IF(WIND(2)-WIND(1).EQ.0.OR.WIND(4)-WIND(3).EQ.0) GO TO 907
C
C.....GET ACTIVE DATA SETS TO GRID
      CALL DAGET(ICARD,ICARDP,MAP,25,MACTS)
      IF(MACTS.NE.0) GO TO 10
C
C.......PROMPT FOR ACTIVE DATA SET
        IPRMT=1
        WRITE(NPRNT,1000)
 1000   FORMAT(' Enter active map ID to grid',\)
        CALL readin ( ICARD, 80, ICARDP, LENICD )
        CALL DAGET(ICARD,ICARDP,MAP,25,MACTS)
        LINES=LINES+3
C
C.....RETRIEVE MAPID AND VALIDATE TYPE
   10 CONTINUE
      MAPID=MAP(1)
      IDTYPE = IDATYP(MAPID/7+1)
      IF (IDTYPE .NE. 1   .AND.  IDTYPE .NE. 5   .AND. IDTYPE .NE. 11
     +   .AND. IDTYPE .NE. 12  .AND.  IDTYPE .NE. 13) GO TO 901
C
C.....OPEN INPUT CHANNEL TO DATA MAP AND READ HEADER RECORDS
c      CALL gtnam(MAPID,0,IBLNK,MAP,IER)
      CALL GTMAP(MAP,MAPID)
C.....GWF 2048 -> 4096 FEB 86
      call adddir(map,mapname)
      call openf(ichan1,mapname,1,256,2,ier)
      IF (IER .NE. 0) GO TO 85020
      call rdblk(ichan1,1,ihead(1),1,ier)
      IF (IER .NE. 0) GO TO 85040
C      CALL DSIN(ICHAN1,IHEAD(129),RECN,IER)
      call rdblk(ichan1,2,ihead(129),1,ier)
      IF (IER .NE. 0) GO TO 85040
      IATYP1 = IHEAD(76)
C
C.....CHECK FOR CORRECT MAP TYPE  1 OR 5,11,12,13
      IDTYPE=IHEAD(62)
      IF (IDTYPE .NE. 1   .AND.  IDTYPE .NE. 5   .AND. IDTYPE .NE. 11
     +   .AND. IDTYPE .NE. 12  .AND.  IDTYPE .NE. 13) GO TO 901
      IF ( IPRMT.EQ.1 ) GO TO 15
C
C.......GET NAME FOR WORKFILE
        CALL decip(ICARD,LABEL,ICARDP)
        IF ( LABEL(1).NE.0 ) GO TO 20
C
C.....PROMPT FOR FILENAME
   15 CONTINUE
      IPRMT=1
      CALL whtcal(LABEL,IIER)
C
C.....SEE IF THE NAME ALREADY EXISTS
   20 CONTINUE
      CALL mchek(LABEL,IFIL,I,ITYP,IER)
      IF ( IFIL.NE.0 ) WRITE(NPRNT,90020)
90020 FORMAT(' This Map Name already exists.  Please re-enter')
      IF (IFIL .NE. 0) GO TO 15
      IF(IPRMT.EQ.1) GO TO 25
C
C.......GET GRIDDING TYPE
        CALL decip(ICARD,ICOM,ICARDP)
        IF(ICOM(1).NE.0) GO TO 30
C
C.....PROMPT FOR GRIDDING TYPE
   25 CONTINUE
      WRITE(NPRNT,1001)
 1001 FORMAT(' Enter one of the following Gridding options:',
     1      /'   1. Exit from GRID',
     2      /'   2. For a 4 Point/Quadrant Weighted Average',
     3      /'   3. For an 8 Points Weighted Average',
     4      /'   4. For Simple or Universal Kriging',
     5      /'   5. For Quintic Spline Interpolation',\)
      CALL readin(ICARD,80,ICARDP,LENICD)
      CALL decip(ICARD,ICOM,ICARDP)
      IPRMT=1
C
   30 CONTINUE
C
C     CONVERT ASCII ICOM TO INTEGER IOPT
C
      IOPT=ICOM(1)+ICOM(2)-48
C
C.....CHECK FOR LEGAL GRIDDING TYPE
C
      IF(IOPT.LT.1.OR.IOPT.GT.5) GO TO 25
      IF(IOPT.EQ.1) GO TO 9999
      IOPT=IOPT-1
C
C.....IF OPTION 2 CHOSEN, SEE ABOUT FAULT MAP?
      NFLAG = 0
      ICNTR = 0
      IF ( IOPT.NE.2 ) GO TO 33
 1015   WRITE(NPRNT,1020)
 1020   FORMAT(' Enter Fault Line map ID [CR = NONE]',\)
        CALL readin ( ICARD, 80, ICARDP,LENICD )
        IF ( ICARD(1).EQ.0 ) GO TO 33
          CALL DAGET ( ICARD, ICARDP, MAP, 25, MACTS )
          LINES = LINES + 2
          FMAPID = MAP(1)
          FIDTYPE = IDATYP(FMAPID/7 + 1)
          IF ( FIDTYPE.NE.2 .AND. ICNTR.GT.4 ) GO TO 903
          IF ( FIDTYPE.NE.2 ) GO TO 1015
C
          NFLAG = 1
          CALL gtnam ( FMAPID, 0, IBLNK, MAP, IER )
          CALL openf ( ICHF, MAP, 2, 256, 2, IER )
          IF ( IER.NE.0 ) GO TO 85020
C
C.....CHECK FOR MASKING FILE
   33 IF ( NFLAG.EQ.0 ) ICHF = 0
      CALL CLEAR(MASKM,10)
      IF(IPRMT.EQ.1) GO TO 35
        CALL decip(ICARD,MASKM,ICARDP)
        IF(MASKM(1).NE.0) GO TO 36
C
C.....PROMPT FOR MASKING FILE IF NEEDED
   35 CONTINUE
      WRITE(NPRNT,1035)
 1035 FORMAT(' Enter Masking File name [CR=NONE]',\)
      CALL readin ( ICARD, 80, ICARDP, LENICD )
      CALL decip(ICARD,MASKM,ICARDP)
      IF (MASKM(1) .EQ. 0) ICHM = 0
      IF (ICHM .EQ. 0) GO TO 37
C
C.......OPEN MASK FILE TO GET ROWS, COLUMNS AND LENGTH
   36   CONTINUE
        CALL gtnam(-1,5,MASKM,MAP,IER)
        CALL DSOPN(ICHM,MAP,1,1,1,256,256,IER)
        IF(IER.NE.0) GO TO 85020
        RECN = 1
        CALL DSIN(ICHM,INBAND(1),RECN,IER)
        IF (IER .NE. 0) GO TO 85040
C        LEN = BYTE(INBAND(185),1)
        CALL GTB(LEN,INBAND(185), 1)
        IBW = 2
        IF (LEN .GE. 16) IBW = 1
        IF (IBW .EQ. 1) LEN = LEN/16
        MROW = INBAND(60)
        MCOL = INBAND(61)
        MTYP = INBAND(62)
        lenm=len
        CALL DSCLS(ICHM,IER)
C
C.....GET SCALE FACTOR VALUE FOR Z VALUE
   37 WRITE(NPRNT,1037)
 1037 FORMAT(' Enter Scaler Value for Z data [CR=1.0]',\)
      CALL readin ( ICARD, 80, ICARDP, LENICD )
      CALL FNUM(ICARD,80,SCALEZ,ICARDP)
      IF(SCALEZ.LE.0.0) SCALEZ=1.0
C
C.....BUILD MAP HEADER, ASSIGN TYPE, SET # OF SUBJECTS, SET BIT LENGTH
      CALL CHDBLD(WIND,IHEAD,0)
      IHEAD(62) = 8
      IHEAD(67) = 0
      ihead(185) = 288
      IHEAD(186) = 8
      IHEAD(191) = 0
      MAXR = IHEAD(60)
      MAXC = IHEAD(61)
      XMIN=AWIND(1)
      YMIN=AWIND(3)
      YMAX=AWIND(4)
      xside=xxside
      yside=yyside
C
C.....DISPLAY HEADER INFO AND GIVE USER A CHANCE TO RE-CONSIDER
      CALL HEADISP(IHEAD,IOPT,IFLAG)
      IF (IFLAG.EQ.1) GOTO 37
C
C.....MAKE SURE THE MASK FILE IS THE SAME SIZE AS THE CELL FILE
       IF (ICHM .NE. 0  .AND.
     +    (MAXR .NE. MROW  .OR.  MAXC .NE. MCOL) ) GO TO 86040
C
C.....CHECK FOR USING MULTIPLE ATTRIBUTE FILE FOR INPUT
      IATYP = 0
      IF (IATYP1 .NE. 1) GO TO 45
        IATYP=KAT((MAPID/7)*2+1)
        MWORDS = ABS(IATYP)
        LOCATE=KAT((MAPID/7)*2+2)
        IF(IATYP.EQ.0) GO TO 45

C
C.........YUP, OPEN -.AT FILE
          CALL gtnam(MAPID,4,IBLNK,MAP,IER)
          CALL openf(ICHAT,MAP,1,256,2,IER)
          IF(IER.NE.0) GO TO 85020
c          IF(IATYP.LT.4) GO TO 45
C...........FROM BSEARCH, PROMPT FOR FIELD
   42       CALL initial
            CALL RETRVL(FOUND,IBUFF)
            IF(.NOT.FOUND) GO TO 42
            IATYP=IBUFF(84)
            MWORDS=IBUFF(85)
            LOCATE=IBUFF(86)
   45 CONTINUE
C
C.....IF SPLINE INTERPOLATION SELECTED, BRANCH TO SPLINE PROGRAM AND FINISH
      IF (IOPT.NE.4) GOTO 47
        CALL CUBSPLIN(ICHAN1,ICHAN5,ICHAT,ICHM,ICHOUT,IXFIL,MAPID,
     +      IDTYPE,IATYP,LOCATE,MWORDS,MTYP,MASKM,IBW,LEN,LABEL,
     +       IHEAD,SCALEZ,DEFLT,MAXR,MAXC,IER)
        GO TO 9999
   47 CONTINUE
C
C.....IF KRIGING OPTION SELECTED, BRANCH TO KRIGING PROGRAM AND FINISH
      IF (IOPT.NE.3) GOTO 50
       CALL KRIG(NPRNT,IOIN,ICHAN1,ICHAN5,ICHAT,
     +    ICHKPR,ICHM,ICHOUT,ICHSTP,ICHV1,ICHV2,WIND,MAPID,IDTYPE,IATYP,
     +    LOCATE,MTYP,MASKM,IBW,LEN,LABEL,IHEAD,SCALEZ,
     +    AWIND,DEFLT,MAXR,MAXC,YMIN,IER)
        GO TO 9999
C
C.....WEIGHT OR QUAD OPTION SELECTED:  GET WINDOW SIZE
   50 CONTINUE
      WRITE(NPRNT,1038)
 1038 FORMAT (' Enter Roving Window Matrix size (3 to 120) [CR = 40]',\)
      CALL readin ( ICARD, 80, ICARDP, LENICD )
      CALL INUM(ICARD,MOVWIN,ICARDP)
      IF ( MOVWIN.EQ.0 ) MOVWIN=40
      IF ( MOVWIN.LT.3 .OR. MOVWIN.GT.120 ) GO TO 50
C
C.....DELETE, CREATE AND OPEN CELL, X, Y, Z FILE
   51 CONTINUE
C.....GWF 2048 -> 4096 FEB 86
      CALL DSOPN(ICHRCZ,ITNAM,3,3,1,8,128,IER)
      IF(IER.NE.0) GO TO 85020
C
C.....BUILD FILE OF ROW,COLUMN AND A FILE OF X,Y,ELEVATIONS
      WRITE(NPRNT,90300)
90300 FORMAT(/,' Executing, Please wait')
      LINES = LINES + 3
C.....NEED NUMBER OF COLUMNS FOR CELL NUMBER CALCULATION
      CALL GRIDPT(MAPID,IDTYPE,IATYP,MWORDS,LOCATE,WIND,SCALEZ,AWIND,
     +            XSIDE,YSIDE,ICHAN1,ICHAT,ICHRCZ,MAXR,MAXC,NPTS,ZZMIN,
     +            IER)
      IF (IER .NE. 0) GO TO 86000
C
C.....CLOSE INPUT MAP DATA CHANNEL AND MULTIPLE ATTRIBUTE CHANNEL (IF OPEN)
   60 CONTINUE
C.....GWF FEB 86
      CALL DSCLS(ICHRCZ,IER)
      close(ICHAN1)
      IF (IATYP .NE. 0) CLOSE(ICHAT)
C
C.....TELL THEM HOW MANY SAMPLES
      WRITE(NPRNT,1025) NPTS
 1025 FORMAT('  *** ',I5,' Data Points have been read in  ***')
      LINES=LINES+5
      IF (NPTS .LT. 5) GO TO 999
C
C.....GWF FEB 86:  IF NO MASK BUF=7168; MASK BUF=6144
      IF ( ICHM.EQ.0 ) CALL DSOPN(ICHRCZ,ITNAM,1,1,1,8,128,IER)
      IF ( ICHM.NE.0 ) CALL DSOPN(ICHRCZ,ITNAM,1,1,1,8,128,IER)
C
C.....OPEN MASKING CELL FILE
      IF (ICHM .EQ. 0) GO TO 500
        CALL gtnam(-1,MTYP,MASKM,MAP,IER)
        CALL DSOPN(ICHM,MAP,1,1,IBW,LEN,256,IER)
        IF(IER.NE.0) GO TO 85020
C
C.....CREATE AND OPEN NEW CELL FILE AND HEADER
  500 CONTINUE
      CALL gtnam(-1,IHEAD(62),LABEL,MAP,IER)
      CALL DSOPN(ICHOUT,MAP,3,3,1,2,128,IER)
      IF(IER.NE.0) GO TO 85020
C
C.....BUILD THE NEW CELL FILE FROM THE ROW,COLUMN FILE AND X,Y,ELEVATION FILE
C.....USING ONE OF THE GRIDDING OPTIONS
      DEFLT = ZZMIN - 10.
   70 CONTINUE
      CALL GRIDMK(IOPT,NPTS,MOVWIN,DEFLT,MAXC,MAXR,AWIND,
     +     XSIDE,YSIDE,ICHRCZ,ICHM,ICHOUT,ZMIN,ZMAX,ibw,len,IER)
      IF (IER .NE. 0) GO TO 86020
      CALL DSCLS(ICHOUT,IER)
      IF (ICHM .NE. 0) CALL DSCLS(ICHM,IER)
      CALL DSCLS(ICHRCZ,IER)
C
C.....GET NEWMAP.HD NAME AND OPEN IT
      CALL gtnam(-1,5,LABEL,MAP,IER)
      CALL DSOPN(ICHAN5,MAP,3,3,1,256,256,IER)
      IF(IER.NE.0) GO TO 85020
      IRECL=512
C
C.....WRITE HEADER NOW THAT ZMIN AND ZMAX IS GIVEN
      RECN=1
       CALL DSOUT(ICHAN5,IHEAD,RECN,IER)
      IF (IER .NE. 0) GO TO 85060
C
C.....CLOSE UP HEADER AND CELL FILE AND MASK(IF OPEN)
      CALL DSCLS(ICHAN5,IER)
C
C.....UPDATE DIRECTORY AND WRITE IT TO THE DATABASE
c      CALL gtnam(0,1,IWORK,MAP,IER)
c      CALL openf(ICHAN2,MAP,2,512,2,IER)
c      IF(IER.NE.0) GO TO 85020
c      CALL gtnam(0,2,IWORK,MAP,IER)
      CALL TUPDIR(ITP1,ITP2,ITP3,LABEL,IHEAD,iwork,icwork,IER)
      CLOSE(ICHAN2)
C
C.....AND DO A NORMAL RETURN
      GO TO 999
C
C.....ERROR RETURNS
C
901   write(*,*)'This command only works with VECTOR data.'
      GO TO 999
C
  902 WRITE(NPRNT,3002)
 3002 FORMAT(' THIS MAP NAME ALREADY EXISTS')
      LINES=LINES+2
      GO TO 999
C
  903 WRITE(NPRNT,3003)
 3003 FORMAT(' *GRID*  FAULT LINE MAP IS NOT A LINE MAP')
      GO TO 999
C
  907 write(*,*)'Display window not set. Set window to active maps(s)' 
      GO TO 999
C
85020 WRITE(NPRNT,98502) (MAP(I),I=1,15), IER
98502 FORMAT(' *GRID*  ERROR FROM OPEN OF ',15A2,'  ERROR',I5)
      LINES=LINES+2
      GO TO 999
C
85040 WRITE(NPRNT,98504) IER
98504 FORMAT(' *GRID*  ERROR FROM DSIN  ERROR',I5)
      LINES=LINES+2
      GO TO 999
C
85060 WRITE(NPRNT,98506) IER
98506 FORMAT(' *GRID*  ERROR FROM DSOUT  ERROR',I5)
      LINES=LINES+2
      GO TO 999
C
86000 WRITE(NPRNT,98600) IER
98600 FORMAT(' *GRID*  ERROR FROM GRIDPT  ERROR',I5)
      LINES=LINES+2
      GO TO 999
C
86020 WRITE(NPRNT,98602) IER
98602 FORMAT(' *GRID*  ERROR FROM GRIDMK  ERROR',I5)
      LINES=LINES+2
      GO TO 999
C
86040 WRITE(NPRNT,98604) MAXR,MAXC
98604 FORMAT(' *GRID*  MASKING MAP DOES NOT HAVE SAME NUMBER OF ROWS',
     +       'OR',/, '         COLUMNS AS NEW MAP WHICH IS ROWS',I5,
     +       ' COLUMNS',I5)
      LINES=LINES+4
C
  999 CONTINUE
C
 9999 CONTINUE
C      CALL OUTCM
      END
