C******************************************************************************
C
C      NAME:          SUBROUTINE DSOPN
C
C      FUNCTION:      OPEN A FILE AS A DATA SET FOR BLOCK I/O.
C                      LOGICAL RECORDS SHOULD BE A LENGTH THAT IS A POWER OF 2.
C                      COMMON /DSBUF/ MUST BE PROVIDED.  PARAMETER MLEN
C                      IN THIS COMMON IS THE MAXIMUM SIZE OF THE DATA ARRAY.
C                      MLEN MUST BE ASSIGNED AND IDATA DIMENSIONED TO MLEN
C                      SOMEWHERE IN THE CALLING PROGRAM.  SEE ERROR 32759.
C
C       PARAMETERS:
C            ICHAN      THE FORTRAN CHANNEL NUMBER BETWEEN 1 AND 63.
C
C            NAMEF      THIS IS AN ARRAY OR CONSTANT CONTAINING THE
C                       NAME TO THE FILE THE USER WISHES TO OPEN.
C                       THE NAME MUST HAVE AT LEAST ONE TRAILING NULL.
C
C            IO      THIS PARAMETER SPECIFIES THE INPUT/OUTPUT
C                  STATUS OF THE FILE.  THE SETTING OF IO=1
C                  RESULTS IN THE FILE BEING A READ ONLY FILE.
C                  THE SETTING OF IO=2 RESULTS IN A WRITE ONLY
C                  FILE.  THE SETTING OF IO=3 RESULTS IN A
C                  READ/WRITE FILE.  A WRITE FILE IS EXCLUSIVLY OPENED.
C
C            ISTAT      THIS PARAMETER SPECIFIES THE STATUS OF THE
C                       FILE POINTED TO BY ARRAY NAME.  IF THE FILE CAN
C                       BE CREATED(ISTAT=2,3,4) IT WILL BE CREATED WITH
C                       AN ELEMENT SIZE OF NBLK/256 TO OPTIMIZE IO.
C                       1 - OPEN FILE (MUST EXIST)
C                       2 - CREATE FILE AND OPEN (MUST NOT EXIST)
C                       3 - DELETE FILE, CREATE AND OPEN (OK IF EXIST OR NOT)
C                       4 - OPEN FILE (CREATE IF FILE DOES NOT EXIST)
C
C               IBW     BIT OR WORD TRANSFER  1 - WORD  2 - BIT
C
C               LEN     SPECIFIES THE NUMBER OF WORDS OR BITS IN A LOGICAL
C                       RECORD.  FOR WORDS THIS VALUE SHOULD BE A POWER OF 2.
C
C               NBLK    SPECIFIES THE NUMBER OF WORDS IN A PHYSICAL RECORD.
C                       MUST BE EVENLY DIVISABLE BY 256.
C
C               NPATH   INDEX FOR PREFIXING ENTRYNAME TO BUILD PATHNAME
C
C               IER     ERROR FLAG  1 IS OK  IF NEGATIVE:
C                       32767 - CHANNEL NOT 1-63
C                       32766 - ISTAT NOT 1-3
C                       32765 - IO NOT 1-3
C                       32764 - CHANNEL ALREADY IN USE
C                       32763 - IBW NOT 1 OR 2
C                       32762 - NBLK NOT EVEN MULTIPLE OF 256
C                       32761 - LEN GT THAN NWORDS
C                       32760 - MORE THAN MLEN WORDS USED
C                       32759 - NBLK GREATER THAN OR EQUAL TO 16384
C                               THIS A LIMIT BECAUSE OF QRDB & QWDB RETURNED
C                               BYTE COUNT PARAMETER.
C******************************************************************************
C
       SUBROUTINE DSOPN (ICHAN,NAMEF,IO,ISTAT,IBW,LEN,NBLK,IER)
C
       COMMON /CMPKT/ ICHBY(4,64)
       COMMON /DSPKT/ RDPKT(2,64),IDPKT(3,64)
       COMMON /DSBUF/ MLEN,IDATA(8192)
       COMMON /CHMN/  MINCHN
       CHARACTER*25  CNAMEF
       INTEGER        BYTE,MINCHN, LNAMEF(66)
       DIMENSION      NAMEF(1)
       EQUIVALENCE    (LNAMEF,CNAMEF)
       DATA IWORDB/256/,IBITSW/16/
C       DATA L1HBLK/:240/L1HNUL/:200/
C
       IER = 0
       iwordb=256
       if(nblk.lt.256)iwordb=nblk
C
C       SEE IF ICHBY AND/OR IDPKT HAVE BEEN USED YET
C
c       CALL FBLNKI(NAMEF,1,132,NBYTES,IER)
c       NWRDS = ( NBYTES + 1 ) / 2
       CNAMEF = ' '
       DO 1 I = 1, 11
          LNAMEF(I) = NAMEF(I)
    1  CONTINUE
       IF (ICHBY(1,64) .EQ. -14325) GO TO 40
       DO 20 I=1,2
        DO 18 J = 1,64
         ICHBY(I,J) = -32767
18      CONTINUE
20     CONTINUE
       ICHBY(1,64) = -14325
40     IF (ICHBY(2,64) .EQ. -14325) GO TO 100
       DO 50 I=1,2
        DO 48 J = 1,64
         RDPKT(I,J) = -32767
48      CONTINUE
50     CONTINUE
       DO 60 I=1,3
        DO 58 J = 1,64
         IDPKT(I,J) = -32767
58      CONTINUE
60     CONTINUE
       ICHBY(2,64) = -14325
C
C      CHECK THE LIMITS
C
  100  IF ( (ISTAT .LT. 1)  .OR.  (ISTAT.GT.4) ) GO TO 80020
       IF ( (IO    .LT. 1)  .OR.  (IO  .GT. 3) ) GO TO 80030
       if(istat.eq.3)then
         istat=0
       elseif(istat.gt.1)then
         istat=2
       endif
C
C       CHECK FOR WORDS-1 OR BITS-2
C
       IF ( (IBW .LT. 1)  .OR.  (IBW .GT. 2) ) GO TO 80050
C
C       MAKE SURE WORDS IN NBLOCKS IS MULTIPLE OF WORDS PER BLOCK
C
       IF (MOD(NBLK,IWORDB) .NE. 0) GO TO 80060
C
C       MAKE SURE AT LEAST ONE LOGICAL PER PHYSICAL
C
       IF (IBW .EQ. 1  .AND.  LEN .GT. NBLK) GO TO 80070
C
C       FIND THE LARGEST WORD TO START AT FOR THIS DATASET
C
500    LOW   = 1
       DO 520 I=1,63
         IF (IDPKT(3,I) .EQ. -32767) GO TO 520
         LOW = LOW + (ICHBY(2,I) * IWORDB)
520    CONTINUE
C
C**     USING MORE THAN MLEN WORDS ?
C
       IF (LOW + NBLK - 1  .GT. MLEN) GO TO 80080
C
       IREC = 128
       CALL OPENF(ICHAN,NAMEF,ISTAT,IREC*2,2,IER)
       IF ( IER.NE.0 ) GO TO 90000
C
       ICHBY(1,ICHAN-MINCHN) = ICHAN
       ICHBY(2,ICHAN-MINCHN) = NBLK/IWORDB
       ICHBY(3,ICHAN-MINCHN) = IREC
       ICHBY(4,ICHAN-MINCHN) = NBLK/IREC
C
C**     EVERYTHING IS KOSHER SO LOAD THE DATA SET PACKET
C
       IF (IBW .EQ. 1) RDPKT(1,ICHAN-MINCHN) = NBLK/LEN
       IF (IBW .EQ. 2)
     +     RDPKT(1,ICHAN-MINCHN) = (FLOAT(NBLK) * FLOAT(IBITSW))/LEN
       RDPKT(2,ICHAN-MINCHN) = 0.
       IDPKT(1,ICHAN-MINCHN) = LEN
       IDPKT(2,ICHAN-MINCHN) = IBW
       IDPKT(3,ICHAN-MINCHN) = LOW
       GO TO 90000
C
C    ERROR RETURNS (32768 - 1-9)
C
C80010  IER =  32767
C       GO TO 90000
80020  IER =  32766
       GO TO 90000
80030  IER =  32765
       GO TO 90000
C80040  IER =  32764
C       GO TO 90000
80050  IER =  32763
       GO TO 90000
80060  IER =  32762
       GO TO 90000
80070  IER =  32761
       GO TO 90000
80080  IER =  32760
       GO TO 90000
80090  IER = 32759
       GO TO 90000
C
90000  RETURN
       END
