## Description, this script with take a fastafile of concatenated snps and 

import argparse
import pandas as pd
import random
import sys, os, shutil
import subprocess
import re
from Bio import SeqIO
from Bio.Seq import Seq

# Command line options
parser = argparse.ArgumentParser(description='Some dumb f*cked script I am writing')
parser.add_argument("-f","--fasta",
					type=argparse.FileType('r'),
					help="Fasta file of concatenatd SNPs.")
parser.add_argument("-c","--combinations",
					type=str,
					help="Text file containing list of Populations.")					
args=parser.parse_args()

## Read combinations file, store list of combinations as reference
print("Reading combinations file.")
df = pd.read_csv(args.combinations,sep=',',names=['pop1','pop2','pop3','pop4'])
#df = pd.read_csv("Dstat_tests.csv",sep=',',names=['pop1','pop2','pop3','pop4'])

## Read in fasta
sequences = list(SeqIO.parse(args.fasta,"fasta"))
#sequences = list(SeqIO.parse("Bothriechis_noMissing_SNPs.fasta","fasta"))

subprocess.call("mkdir Dtest_Fastas",shell=True)
for i in range(0,len(df)):
	pop_seqs=[]
	for j in range(0,len(df.ix[i,:])):
		pop=df.ix[i,j]
		tmp_list=[]
		for seq in sequences:
			if pop in seq.name:
				tmp_list.append(seq)
		chosen_one = random.choice(tmp_list)
		chosen_one.id = pop
		chosen_one.description = ''
		chosen_one
		pop_seqs.append(chosen_one)
	fname=str("Dtest_Fastas/" + pop_seqs[0].id + pop_seqs[1].id + pop_seqs[2].id + pop_seqs[3].id + ".fasta")
	SeqIO.write(pop_seqs, fname, "fasta-2line")
